/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.execution.dashboard;

import com.intellij.execution.ExecutionListener;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.RunContentDescriptorId;
import com.intellij.execution.RunContentDescriptorIdImpl;
import com.intellij.execution.RunContentDescriptorIdImplKt;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunManagerListener;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.ConfigurationTypeUtil;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.dashboard.RunDashboardCustomizer;
import com.intellij.execution.dashboard.RunDashboardDefaultTypesProvider;
import com.intellij.execution.dashboard.RunDashboardListener;
import com.intellij.execution.dashboard.RunDashboardManager;
import com.intellij.execution.dashboard.RunDashboardRunConfigurationStatus;
import com.intellij.execution.dashboard.RunDashboardService;
import com.intellij.execution.dashboard.RunDashboardServiceId;
import com.intellij.execution.dashboard.RunDashboardServiceIdKt;
import com.intellij.execution.dashboard.RunDashboardServiceIdType;
import com.intellij.execution.impl.ExecutionManagerImpl;
import com.intellij.execution.impl.RunManagerImpl;
import com.intellij.execution.impl.RunnerAndConfigurationSettingsImpl;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.RunContentManagerImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.platform.execution.dashboard.BackendRunDashboardManagerState;
import com.intellij.platform.execution.dashboard.RunDashboardCoroutineScopeProvider;
import com.intellij.platform.execution.dashboard.splitApi.RunDashboardServiceDto;
import com.intellij.platform.execution.dashboard.splitApi.RunDashboardSettingsDto;
import com.intellij.platform.execution.dashboard.splitApi.ServiceCustomizationDto;
import com.intellij.platform.execution.dashboard.splitApi.ServiceStatusDto;
import com.intellij.platform.execution.dashboard.splitApi.frontend.RunDashboardUiManagerImpl;
import com.intellij.platform.kernel.ids.BackendGlobalIdsKt;
import com.intellij.platform.kernel.ids.BackendValueIdType;
import com.intellij.ui.content.Content;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.flow.Flow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

@Service(value={Service.Level.PROJECT})
@com.intellij.openapi.components.State(name="RunDashboard", storages={@Storage(value="$WORKSPACE_FILE$")})
public final class RunDashboardManagerImpl
implements RunDashboardManager,
PersistentStateComponent<State> {
    private static final ExtensionPointName<RunDashboardDefaultTypesProvider> DEFAULT_TYPES_PROVIDER_EP_NAME = new ExtensionPointName("com.intellij.runDashboardDefaultTypesProvider");
    private final Project myProject;
    private State myState;
    private final Set<String> myTypes;
    private final Set<RunConfiguration> myHiddenConfigurations;
    private final Set<RunConfiguration> myShownConfigurations;
    private final Map<RunConfiguration, RunDashboardRunConfigurationStatus> myConfigurationStatuses;
    private volatile List<List<RunDashboardService>> myServices;
    private final BackendRunDashboardManagerState mySharedState;
    private final ReentrantReadWriteLock myServiceLock;
    private final AtomicBoolean myListenersInitialized;
    @NotNull
    private final CoroutineScope myScope;

    public static RunDashboardManagerImpl getInstance(Project project) {
        return (RunDashboardManagerImpl)project.getService(RunDashboardManagerImpl.class);
    }

    public RunDashboardManagerImpl(@NotNull Project project, @NotNull CoroutineScope coroutineScope) {
        if (project == null) {
            RunDashboardManagerImpl.$$$reportNull$$$0(0);
        }
        if (coroutineScope == null) {
            RunDashboardManagerImpl.$$$reportNull$$$0(1);
        }
        this.myState = new State();
        this.myTypes = new HashSet<String>();
        this.myHiddenConfigurations = new HashSet<RunConfiguration>();
        this.myShownConfigurations = new HashSet<RunConfiguration>();
        this.myConfigurationStatuses = new ConcurrentHashMap<RunConfiguration, RunDashboardRunConfigurationStatus>();
        this.myServices = new SmartList();
        this.myServiceLock = new ReentrantReadWriteLock();
        this.myListenersInitialized = new AtomicBoolean();
        this.myProject = project;
        this.myScope = coroutineScope;
        this.mySharedState = new BackendRunDashboardManagerState(this.myProject);
        this.initExtensionPointListeners();
    }

    public void updateServiceRunContentDescriptor(@NotNull Content contentWithNewDescriptor, @NotNull RunContentDescriptor oldDescriptor) {
        RunContentDescriptorId newContentId;
        RunContentDescriptorId oldDescriptorId;
        if (contentWithNewDescriptor == null) {
            RunDashboardManagerImpl.$$$reportNull$$$0(2);
        }
        if (oldDescriptor == null) {
            RunDashboardManagerImpl.$$$reportNull$$$0(3);
        }
        if ((oldDescriptorId = oldDescriptor.getId()) == null) {
            return;
        }
        RunContentDescriptor newDescriptor = RunContentManagerImpl.getRunContentDescriptorByContent((Content)contentWithNewDescriptor);
        RunContentDescriptorId runContentDescriptorId = newContentId = newDescriptor == null ? null : newDescriptor.getId();
        if (newContentId instanceof RunContentDescriptorIdImpl) {
            RunContentDescriptorIdImpl newContentIdImpl = (RunContentDescriptorIdImpl)newContentId;
            this.updateServiceRunContentDescriptor(oldDescriptorId, (RunContentDescriptorId)newContentIdImpl);
        }
        RunDashboardUiManagerImpl.getInstance(this.myProject).getDashboardContentManager().addContent(contentWithNewDescriptor);
    }

    private void initExtensionPointListeners() {
        final ExtensionPointListener dashboardUpdater = new ExtensionPointListener(){

            public void extensionAdded(@NotNull Object extension, @NotNull PluginDescriptor pluginDescriptor) {
                if (extension == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (pluginDescriptor == null) {
                    1.$$$reportNull$$$0(1);
                }
                RunDashboardManagerImpl.this.updateDashboard(true);
            }

            public void extensionRemoved(@NotNull Object extension, @NotNull PluginDescriptor pluginDescriptor) {
                if (extension == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (pluginDescriptor == null) {
                    1.$$$reportNull$$$0(3);
                }
                RunDashboardManagerImpl.this.updateDashboard(true);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "extension";
                        break;
                    }
                    case 1: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "pluginDescriptor";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/platform/execution/dashboard/RunDashboardManagerImpl$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "extensionAdded";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "extensionRemoved";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        RunDashboardCustomizer.CUSTOMIZER_EP_NAME.addExtensionPointListener(dashboardUpdater, (Disposable)this.myProject);
        DEFAULT_TYPES_PROVIDER_EP_NAME.addExtensionPointListener((ExtensionPointListener)new ExtensionPointListener<RunDashboardDefaultTypesProvider>(){

            public void extensionAdded(RunDashboardDefaultTypesProvider extension, @NotNull PluginDescriptor pluginDescriptor) {
                if (pluginDescriptor == null) {
                    2.$$$reportNull$$$0(0);
                }
                HashSet<String> types = new HashSet<String>(RunDashboardManagerImpl.this.getTypes());
                types.addAll(extension.getDefaultTypeIds(RunDashboardManagerImpl.this.myProject));
                RunDashboardManagerImpl.this.setTypes(types);
            }

            public void extensionRemoved(RunDashboardDefaultTypesProvider extension, @NotNull PluginDescriptor pluginDescriptor) {
                if (pluginDescriptor == null) {
                    2.$$$reportNull$$$0(1);
                }
                HashSet<String> types = new HashSet<String>(RunDashboardManagerImpl.this.getTypes());
                types.removeAll(extension.getDefaultTypeIds(RunDashboardManagerImpl.this.myProject));
                RunDashboardManagerImpl.this.setTypes(types);
                dashboardUpdater.extensionRemoved((Object)extension, pluginDescriptor);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "pluginDescriptor";
                objectArray2[1] = "com/intellij/platform/execution/dashboard/RunDashboardManagerImpl$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "extensionAdded";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "extensionRemoved";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, (Disposable)this.myProject);
        ConfigurationType.CONFIGURATION_TYPE_EP.addExtensionPointListener((ExtensionPointListener)new ExtensionPointListener<ConfigurationType>(){

            public void extensionAdded(ConfigurationType extension, @NotNull PluginDescriptor pluginDescriptor) {
                if (pluginDescriptor == null) {
                    3.$$$reportNull$$$0(0);
                }
                RunDashboardManagerImpl.this.setTypes(new HashSet<String>(RunDashboardManagerImpl.this.getTypes()));
            }

            public void extensionRemoved(ConfigurationType extension, @NotNull PluginDescriptor pluginDescriptor) {
                if (pluginDescriptor == null) {
                    3.$$$reportNull$$$0(1);
                }
                HashSet<String> types = new HashSet<String>(RunDashboardManagerImpl.this.getTypes());
                types.remove(extension.getId());
                RunDashboardManagerImpl.this.setTypes(types);
                dashboardUpdater.extensionRemoved((Object)extension, pluginDescriptor);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "pluginDescriptor";
                objectArray2[1] = "com/intellij/platform/execution/dashboard/RunDashboardManagerImpl$3";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "extensionAdded";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "extensionRemoved";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, (Disposable)this.myProject);
    }

    private void initServiceContentListeners() {
        if (!this.myListenersInitialized.compareAndSet(false, true)) {
            return;
        }
        MessageBusConnection connection = this.myProject.getMessageBus().connect((Disposable)this.myProject);
        connection.subscribe(RunManagerListener.TOPIC, (Object)new RunManagerListener(){
            private volatile boolean myUpdateStarted;

            public void runConfigurationAdded(@NotNull RunnerAndConfigurationSettings settings) {
                if (settings == null) {
                    4.$$$reportNull$$$0(0);
                }
                if (settings.isTemporary() && RunDashboardManagerImpl.this.myState.excludedNewTypes.contains(settings.getType().getId())) {
                    RunDashboardManagerImpl.this.myShownConfigurations.add(settings.getConfiguration());
                }
                if (!this.myUpdateStarted) {
                    RunDashboardManagerImpl.this.syncConfigurations();
                    RunDashboardManagerImpl.this.updateDashboardIfNeeded(settings);
                }
            }

            public void runConfigurationRemoved(@NotNull RunnerAndConfigurationSettings settings) {
                if (settings == null) {
                    4.$$$reportNull$$$0(1);
                }
                RunConfiguration configuration = settings.getConfiguration();
                RunDashboardManagerImpl.this.myHiddenConfigurations.remove(configuration);
                RunDashboardManagerImpl.this.myShownConfigurations.remove(configuration);
                RunDashboardManagerImpl.this.myConfigurationStatuses.remove(configuration);
                if (!this.myUpdateStarted) {
                    RunDashboardManagerImpl.this.syncConfigurations();
                    RunDashboardManagerImpl.this.updateDashboardIfNeeded(settings);
                }
            }

            public void runConfigurationChanged(@NotNull RunnerAndConfigurationSettings settings) {
                if (settings == null) {
                    4.$$$reportNull$$$0(2);
                }
                if (!this.myUpdateStarted) {
                    RunDashboardManagerImpl.this.updateDashboardIfNeeded(settings);
                }
            }

            public void beginUpdate() {
                this.myUpdateStarted = true;
            }

            public void endUpdate() {
                this.myUpdateStarted = false;
                RunDashboardManagerImpl.this.syncConfigurations();
                RunDashboardManagerImpl.this.updateDashboard(true);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "settings";
                objectArray2[1] = "com/intellij/platform/execution/dashboard/RunDashboardManagerImpl$4";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "runConfigurationAdded";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "runConfigurationRemoved";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "runConfigurationChanged";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        connection.subscribe(ExecutionManager.EXECUTION_TOPIC, (Object)new ExecutionListener(){

            public void processStarted(@NotNull String executorId, @NotNull ExecutionEnvironment env, @NotNull ProcessHandler handler) {
                if (executorId == null) {
                    5.$$$reportNull$$$0(0);
                }
                if (env == null) {
                    5.$$$reportNull$$$0(1);
                }
                if (handler == null) {
                    5.$$$reportNull$$$0(2);
                }
                RunDashboardManagerImpl.this.updateDashboardIfNeeded(env.getRunnerAndConfigurationSettings());
            }

            public void processTerminated(@NotNull String executorId, @NotNull ExecutionEnvironment env, @NotNull ProcessHandler handler, int exitCode) {
                RunConfiguration configuration;
                if (executorId == null) {
                    5.$$$reportNull$$$0(3);
                }
                if (env == null) {
                    5.$$$reportNull$$$0(4);
                }
                if (handler == null) {
                    5.$$$reportNull$$$0(5);
                }
                RunConfiguration runConfiguration = configuration = env.getRunnerAndConfigurationSettings() != null ? env.getRunnerAndConfigurationSettings().getConfiguration() : null;
                if (configuration != null && RunDashboardManagerImpl.this.isShowInDashboard(configuration)) {
                    boolean stopped = exitCode == 0 || handler.getUserData(ProcessHandler.TERMINATION_REQUESTED) == Boolean.TRUE;
                    RunDashboardRunConfigurationStatus status = stopped ? RunDashboardRunConfigurationStatus.STOPPED : RunDashboardRunConfigurationStatus.FAILED;
                    RunDashboardManagerImpl.this.myConfigurationStatuses.put(configuration, status);
                }
                RunDashboardManagerImpl.this.updateDashboardIfNeeded(env.getRunnerAndConfigurationSettings());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "executorId";
                        break;
                    }
                    case 1: 
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "env";
                        break;
                    }
                    case 2: 
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "handler";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/platform/execution/dashboard/RunDashboardManagerImpl$5";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processStarted";
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processTerminated";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        connection.subscribe(RunDashboardListener.DASHBOARD_TOPIC, (Object)new RunDashboardListener(){

            public void configurationChanged(@NotNull RunConfiguration configuration, boolean withStructure) {
                if (configuration == null) {
                    6.$$$reportNull$$$0(0);
                }
                RunDashboardManagerImpl.this.updateDashboardIfNeeded(configuration, withStructure);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/intellij/platform/execution/dashboard/RunDashboardManagerImpl$6", "configurationChanged"));
            }
        });
        connection.subscribe(DumbService.DUMB_MODE, (Object)new DumbService.DumbModeListener(){

            public void exitDumbMode() {
                RunDashboardManagerImpl.this.updateDashboard(false);
            }
        });
    }

    @Nullable
    public RunDashboardService findServiceById(RunDashboardServiceId id) {
        RunDashboardService valueFromGlobalStorage = RunDashboardServiceIdKt.findValue((RunDashboardServiceId)id);
        if (valueFromGlobalStorage != null) {
            return valueFromGlobalStorage;
        }
        Logger.getInstance(RunDashboardManagerImpl.class).warn("findServiceById failed to discover backend run dashboard service in global storage, falling back to manually managed collection");
        return (RunDashboardService)ContainerUtil.find(this.getRunConfigurations(), service -> service.getUuid().equals((Object)id));
    }

    public List<RunDashboardService> getRunConfigurations() {
        this.myServiceLock.readLock().lock();
        try {
            List<RunDashboardService> list = this.myServices.stream().flatMap(Collection::stream).collect(Collectors.toList());
            return list;
        }
        finally {
            this.myServiceLock.readLock().unlock();
        }
    }

    public Flow<RunDashboardSettingsDto> getSettingsDto() {
        return this.mySharedState.getSettings();
    }

    public Flow<List<RunDashboardServiceDto>> getServicesDto() {
        return this.mySharedState.getServices();
    }

    public Flow<ServiceStatusDto> getStatusesDto() {
        return this.mySharedState.getStatuses();
    }

    public Flow<ServiceCustomizationDto> getCustomizationsDto() {
        return this.mySharedState.getCustomizations();
    }

    public void runCallbackForLink(@NotNull String link, @NotNull RunDashboardServiceId serviceId) {
        Runnable callback;
        if (link == null) {
            RunDashboardManagerImpl.$$$reportNull$$$0(4);
        }
        if (serviceId == null) {
            RunDashboardManagerImpl.$$$reportNull$$$0(5);
        }
        if ((callback = this.mySharedState.getLinkByServiceId(link, serviceId)) != null) {
            callback.run();
        }
    }

    private @Unmodifiable List<RunContentDescriptor> filterByContent(List<? extends RunContentDescriptor> descriptors) {
        return ContainerUtil.filter(descriptors, descriptor -> ContainerUtil.find(this.getRunConfigurations(), service -> {
            RunContentDescriptor serviceDescriptor = service.getDescriptor();
            return serviceDescriptor != null && serviceDescriptor.getId().equals((Object)descriptor.getId());
        }) != null);
    }

    public boolean isShowInDashboard(@NotNull RunConfiguration runConfiguration) {
        if (runConfiguration == null) {
            RunDashboardManagerImpl.$$$reportNull$$$0(6);
        }
        if (this.isShown(runConfiguration)) {
            return true;
        }
        RunConfiguration baseConfiguration = RunDashboardManagerImpl.getBaseConfiguration(runConfiguration);
        if (baseConfiguration != null) {
            return this.isShown(baseConfiguration);
        }
        return false;
    }

    private boolean isShown(@NotNull RunConfiguration runConfiguration) {
        if (runConfiguration == null) {
            RunDashboardManagerImpl.$$$reportNull$$$0(7);
        }
        if (!this.myTypes.contains(runConfiguration.getType().getId())) {
            return false;
        }
        if (this.myState.excludedNewTypes.contains(runConfiguration.getType().getId())) {
            return this.myShownConfigurations.contains(runConfiguration);
        }
        return !this.myHiddenConfigurations.contains(runConfiguration);
    }

    @Nullable
    private static RunConfiguration getBaseConfiguration(@NotNull RunConfiguration runConfiguration) {
        RunProfile runProfile;
        if (runConfiguration == null) {
            RunDashboardManagerImpl.$$$reportNull$$$0(8);
        }
        return (runProfile = ExecutionManagerImpl.getDelegatedRunProfile((RunProfile)runConfiguration)) instanceof RunConfiguration ? (RunConfiguration)runProfile : null;
    }

    @NotNull
    public @Unmodifiable Set<String> getTypes() {
        Set<String> set = Collections.unmodifiableSet(this.myTypes);
        if (set == null) {
            RunDashboardManagerImpl.$$$reportNull$$$0(9);
        }
        return set;
    }

    public void setTypes(@NotNull Set<String> types) {
        if (types == null) {
            RunDashboardManagerImpl.$$$reportNull$$$0(10);
        }
        this.myTypes.clear();
        this.myTypes.addAll(types);
        if (!this.myTypes.isEmpty()) {
            this.initServiceContentListeners();
        }
        Set<String> enableByDefaultTypes = this.getEnableByDefaultTypes();
        this.myState.configurationTypes.clear();
        this.myState.configurationTypes.addAll(this.myTypes);
        this.myState.configurationTypes.removeAll(enableByDefaultTypes);
        this.myState.excludedTypes.clear();
        this.myState.excludedTypes.addAll(enableByDefaultTypes);
        this.myState.excludedTypes.removeAll(this.myTypes);
        this.myState.excludedNewTypes.retainAll(types);
        this.myHiddenConfigurations.removeIf(configuration -> !types.contains(configuration.getType().getId()));
        this.myShownConfigurations.removeIf(configuration -> !types.contains(configuration.getType().getId()));
        this.myConfigurationStatuses.entrySet().removeIf(configuration -> !types.contains(((RunConfiguration)configuration.getKey()).getType().getId()));
        this.syncConfigurations();
        this.updateDashboard(true);
    }

    private static Condition<? super RunnerAndConfigurationSettings> getContainsTypeIdCondition(Collection<String> types) {
        return settings -> {
            if (types.contains(settings.getType().getId())) {
                return true;
            }
            RunConfiguration baseConfiguration = RunDashboardManagerImpl.getBaseConfiguration(settings.getConfiguration());
            if (baseConfiguration != null) {
                return types.contains(baseConfiguration.getType().getId());
            }
            return false;
        };
    }

    @NotNull
    public Set<RunConfiguration> getHiddenConfigurations() {
        HashSet<RunConfiguration> hiddenConfigurations = new HashSet<RunConfiguration>(this.myHiddenConfigurations);
        for (String typeId : this.myState.excludedNewTypes) {
            hiddenConfigurations.addAll(this.getExcludedConfigurations(typeId, this.myShownConfigurations));
        }
        HashSet<RunConfiguration> hashSet = hiddenConfigurations;
        if (hashSet == null) {
            RunDashboardManagerImpl.$$$reportNull$$$0(11);
        }
        return hashSet;
    }

    private Collection<RunConfiguration> getExcludedConfigurations(String typeId, Collection<RunConfiguration> toExclude) {
        ConfigurationType type = ConfigurationTypeUtil.findConfigurationType((String)typeId);
        if (type == null) {
            return Collections.emptyList();
        }
        List configurations = RunManager.getInstance((Project)this.myProject).getConfigurationsList(type);
        return ContainerUtil.filter((Collection)configurations, configuration -> !toExclude.contains(configuration));
    }

    public void hideConfigurations(Collection<? extends RunConfiguration> configurations) {
        for (RunConfiguration runConfiguration : configurations) {
            if (this.myState.excludedNewTypes.contains(runConfiguration.getType().getId())) {
                this.myShownConfigurations.remove(runConfiguration);
                continue;
            }
            this.myHiddenConfigurations.add(runConfiguration);
        }
        this.syncConfigurations();
        this.updateDashboard(true);
    }

    public void restoreConfigurations(@NotNull Collection<? extends RunConfiguration> configurations) {
        if (configurations == null) {
            RunDashboardManagerImpl.$$$reportNull$$$0(12);
        }
        for (RunConfiguration runConfiguration : configurations) {
            if (this.myState.excludedNewTypes.contains(runConfiguration.getType().getId())) {
                this.myShownConfigurations.add(runConfiguration);
                continue;
            }
            this.myHiddenConfigurations.remove(runConfiguration);
        }
        this.syncConfigurations();
        this.updateDashboard(true);
    }

    public boolean isNewExcluded(@NotNull String typeId) {
        if (typeId == null) {
            RunDashboardManagerImpl.$$$reportNull$$$0(13);
        }
        return this.myState.excludedNewTypes.contains(typeId);
    }

    public void setNewExcluded(@NotNull String typeId, boolean newExcluded) {
        if (typeId == null) {
            RunDashboardManagerImpl.$$$reportNull$$$0(14);
        }
        if (newExcluded) {
            if (this.myState.excludedNewTypes.add(typeId)) {
                this.invert(typeId, this.myHiddenConfigurations, this.myShownConfigurations);
                this.updateDashboard(true);
            }
        } else if (this.myState.excludedNewTypes.remove(typeId)) {
            this.invert(typeId, this.myShownConfigurations, this.myHiddenConfigurations);
            this.updateDashboard(true);
        }
    }

    public void clearConfigurationStatus(@NotNull RunConfiguration configuration) {
        if (configuration == null) {
            RunDashboardManagerImpl.$$$reportNull$$$0(15);
        }
        this.myConfigurationStatuses.remove(configuration);
        this.updateDashboardIfNeeded(configuration, false);
    }

    @Nullable
    public RunDashboardRunConfigurationStatus getPersistedStatus(@NotNull RunConfiguration configuration) {
        if (configuration == null) {
            RunDashboardManagerImpl.$$$reportNull$$$0(16);
        }
        return this.myConfigurationStatuses.get(configuration);
    }

    private void invert(String typeId, Set<RunConfiguration> from, Set<RunConfiguration> to) {
        to.addAll(this.getExcludedConfigurations(typeId, from));
        from.removeIf(configuration -> configuration.getType().getId().equals(typeId));
    }

    public boolean isOpenRunningConfigInNewTab() {
        return this.myState.openRunningConfigInTab;
    }

    public void setOpenRunningConfigInNewTab(boolean value) {
        this.myState.openRunningConfigInTab = value;
        this.mySharedState.setSettings(this.myState.openRunningConfigInTab);
    }

    @NotNull
    public static List<RunDashboardCustomizer> getCustomizers(@NotNull RunnerAndConfigurationSettings settings, @Nullable RunContentDescriptor descriptor) {
        if (settings == null) {
            RunDashboardManagerImpl.$$$reportNull$$$0(17);
        }
        SmartList customizers = new SmartList();
        for (RunDashboardCustomizer customizer : (RunDashboardCustomizer[])RunDashboardCustomizer.CUSTOMIZER_EP_NAME.getExtensions()) {
            if (!customizer.isApplicable(settings, descriptor)) continue;
            customizers.add(customizer);
        }
        SmartList smartList = customizers;
        if (smartList == null) {
            RunDashboardManagerImpl.$$$reportNull$$$0(18);
        }
        return smartList;
    }

    private void updateDashboardIfNeeded(@Nullable RunnerAndConfigurationSettings settings) {
        if (settings != null) {
            this.updateDashboardIfNeeded(settings.getConfiguration(), true);
        }
    }

    private void updateDashboardIfNeeded(@NotNull RunConfiguration configuration, boolean withStructure) {
        if (configuration == null) {
            RunDashboardManagerImpl.$$$reportNull$$$0(19);
        }
        if (this.isShowInDashboard(configuration) || !this.filterByContent(this.getConfigurationDescriptors(configuration)).isEmpty()) {
            this.updateDashboard(withStructure);
        }
    }

    private List<RunContentDescriptor> getConfigurationDescriptors(@NotNull RunConfiguration configuration) {
        ExecutionManager instance;
        if (configuration == null) {
            RunDashboardManagerImpl.$$$reportNull$$$0(20);
        }
        if (!((instance = ExecutionManager.getInstance((Project)this.myProject)) instanceof ExecutionManagerImpl)) {
            return Collections.emptyList();
        }
        return ((ExecutionManagerImpl)instance).getDescriptors(s -> configuration.equals((Object)s.getConfiguration()) || configuration.equals((Object)RunDashboardManagerImpl.getBaseConfiguration(s.getConfiguration())));
    }

    public void updateDashboard(boolean withStructure) {
        for (RunDashboardService backendService : this.getRunConfigurations()) {
            this.mySharedState.fireStatusUpdated(backendService);
            List<RunDashboardCustomizer> applicableCustomizers = RunDashboardManagerImpl.getCustomizers(backendService.getConfigurationSettings(), backendService.getDescriptor());
            if (applicableCustomizers.isEmpty()) continue;
            this.mySharedState.fireCustomizationUpdated(backendService, applicableCustomizers);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void syncConfigurations() {
        List settingsList = ContainerUtil.filter((Collection)RunManager.getInstance((Project)this.myProject).getAllSettings(), settings -> this.isShowInDashboard(settings.getConfiguration()));
        ArrayList<List<RunDashboardService>> result = new ArrayList<List<RunDashboardService>>();
        this.myServiceLock.writeLock().lock();
        try {
            for (RunnerAndConfigurationSettings runnerAndConfigurationSettings : settingsList) {
                SmartList syncedServices = this.getServices(runnerAndConfigurationSettings);
                if (syncedServices == null) {
                    syncedServices = new SmartList((Object)new RunDashboardServiceImpl(RunDashboardCoroutineScopeProvider.getInstance(this.myProject).getCs(), runnerAndConfigurationSettings, null));
                }
                result.add((List<RunDashboardService>)syncedServices);
            }
            for (List list : this.myServices) {
                RunDashboardService oldService = (RunDashboardService)list.get(0);
                if (oldService.getDescriptorId() == null || settingsList.contains(oldService.getConfigurationSettings()) || RunDashboardManagerImpl.updateServiceSettings(this.myProject, result, list)) continue;
                result.add(list);
            }
            this.myServices = result;
        }
        finally {
            this.myServiceLock.writeLock().unlock();
            this.mySharedState.setServices(this.myServices);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public RunDashboardService updateServiceRunContentDescriptor(@NotNull RunContentDescriptorId oldDescriptorId, @NotNull RunContentDescriptorId descriptorId) {
        RunnerAndConfigurationSettings settings;
        if (oldDescriptorId == null) {
            RunDashboardManagerImpl.$$$reportNull$$$0(21);
        }
        if (descriptorId == null) {
            RunDashboardManagerImpl.$$$reportNull$$$0(22);
        }
        if ((settings = this.findSettings(descriptorId)) == null) {
            return null;
        }
        this.myServiceLock.writeLock().lock();
        try {
            RunDashboardService service = this.findService(oldDescriptorId);
            if (service != null) {
                this.doDetachServiceRunContentDescriptor(service);
            }
            RunDashboardService runDashboardService = this.doAttachServiceRunContentDescriptor(settings, descriptorId);
            return runDashboardService;
        }
        finally {
            this.myServiceLock.writeLock().unlock();
            this.mySharedState.setServices(this.myServices);
            this.updateDashboard(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public RunDashboardService attachServiceRunContentDescriptor(@NotNull RunContentDescriptorId descriptorId) {
        RunnerAndConfigurationSettings settings;
        if (descriptorId == null) {
            RunDashboardManagerImpl.$$$reportNull$$$0(23);
        }
        if ((settings = this.findSettings(descriptorId)) == null) {
            return null;
        }
        this.myServiceLock.writeLock().lock();
        try {
            RunDashboardService runDashboardService = this.doAttachServiceRunContentDescriptor(settings, descriptorId);
            return runDashboardService;
        }
        finally {
            this.myServiceLock.writeLock().unlock();
            this.mySharedState.setServices(this.myServices);
            this.updateDashboard(true);
        }
    }

    public void detachServiceRunContentDescriptor(@NotNull RunContentDescriptorId descriptorId) {
        if (descriptorId == null) {
            RunDashboardManagerImpl.$$$reportNull$$$0(24);
        }
        this.myServiceLock.writeLock().lock();
        try {
            RunDashboardService service = this.findService(descriptorId);
            if (service == null) {
                return;
            }
            this.doDetachServiceRunContentDescriptor(service);
        }
        finally {
            this.myServiceLock.writeLock().unlock();
            this.mySharedState.setServices(this.myServices);
            this.updateDashboard(true);
        }
    }

    @NotNull
    private RunDashboardService doAttachServiceRunContentDescriptor(@NotNull RunnerAndConfigurationSettings settings, @NotNull RunContentDescriptorId descriptorId) {
        SmartList settingsServices;
        if (settings == null) {
            RunDashboardManagerImpl.$$$reportNull$$$0(25);
        }
        if (descriptorId == null) {
            RunDashboardManagerImpl.$$$reportNull$$$0(26);
        }
        if ((settingsServices = this.getServices(settings)) == null) {
            RunDashboardServiceImpl newService = new RunDashboardServiceImpl(RunDashboardCoroutineScopeProvider.getInstance(this.myProject).getCs(), settings, descriptorId);
            settingsServices = new SmartList((Object)newService);
            this.myServices.add((List<RunDashboardService>)settingsServices);
            RunDashboardServiceImpl runDashboardServiceImpl = newService;
            if (runDashboardServiceImpl == null) {
                RunDashboardManagerImpl.$$$reportNull$$$0(27);
            }
            return runDashboardServiceImpl;
        }
        RunDashboardService service = settingsServices.get(0);
        boolean areDescriptorsWithSameExecutors = RunDashboardManagerImpl.areSameOriginDescriptorsBeingExchanged(descriptorId, service);
        if ((!areDescriptorsWithSameExecutors || service.getDescriptorId() == null) && service instanceof RunDashboardServiceImpl) {
            RunDashboardServiceImpl mainService = (RunDashboardServiceImpl)service;
            mainService.setDescriptorId(descriptorId);
            RunDashboardServiceImpl runDashboardServiceImpl = mainService;
            if (runDashboardServiceImpl == null) {
                RunDashboardManagerImpl.$$$reportNull$$$0(28);
            }
            return runDashboardServiceImpl;
        }
        AdditionalRunDashboardService newService = new AdditionalRunDashboardService(settings, descriptorId, service.getUuid());
        settingsServices.add(newService);
        AdditionalRunDashboardService additionalRunDashboardService = newService;
        if (additionalRunDashboardService == null) {
            RunDashboardManagerImpl.$$$reportNull$$$0(29);
        }
        return additionalRunDashboardService;
    }

    private static boolean areSameOriginDescriptorsBeingExchanged(@NotNull RunContentDescriptorId descriptorId, RunDashboardService service) {
        RunContentDescriptor runContentDescriptor;
        RunContentDescriptor resolvedExistingDescriptor;
        RunContentDescriptorId existingId;
        if (descriptorId == null) {
            RunDashboardManagerImpl.$$$reportNull$$$0(30);
        }
        if ((existingId = service.getDescriptorId()) instanceof RunContentDescriptorIdImpl) {
            RunContentDescriptorIdImpl impl = (RunContentDescriptorIdImpl)existingId;
            v0 = RunContentDescriptorIdImplKt.findContentValue((RunContentDescriptorIdImpl)impl);
        } else {
            v0 = resolvedExistingDescriptor = null;
        }
        if (descriptorId instanceof RunContentDescriptorIdImpl) {
            RunContentDescriptorIdImpl impl = (RunContentDescriptorIdImpl)descriptorId;
            runContentDescriptor = RunContentDescriptorIdImplKt.findContentValue((RunContentDescriptorIdImpl)impl);
        } else {
            runContentDescriptor = null;
        }
        RunContentDescriptor resolvedNewDescriptor = runContentDescriptor;
        boolean areDescriptorsWithSameExecutors = resolvedExistingDescriptor != null && resolvedNewDescriptor != null && resolvedExistingDescriptor.isHiddenContent() == resolvedNewDescriptor.isHiddenContent();
        return areDescriptorsWithSameExecutors;
    }

    private void doDetachServiceRunContentDescriptor(@NotNull RunDashboardService service) {
        RunnerAndConfigurationSettings contentSettings;
        List<RunDashboardService> services;
        if (service == null) {
            RunDashboardManagerImpl.$$$reportNull$$$0(31);
        }
        if ((services = this.getServices(contentSettings = service.getConfigurationSettings())) == null) {
            return;
        }
        if (!this.isShowInDashboard(contentSettings.getConfiguration()) || !RunManager.getInstance((Project)this.myProject).getAllSettings().contains(contentSettings)) {
            this.myServices.remove(services);
            return;
        }
        if (service instanceof RunDashboardServiceImpl) {
            RunDashboardServiceImpl mainService = (RunDashboardServiceImpl)service;
            RunContentDescriptorId descriptorId = services.size() > 1 ? services.remove(1).getDescriptorId() : null;
            mainService.setDescriptorId(descriptorId);
        } else {
            services.remove(service);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public RunDashboardService findService(@NotNull RunContentDescriptorId descriptorId) {
        if (descriptorId == null) {
            RunDashboardManagerImpl.$$$reportNull$$$0(32);
        }
        this.myServiceLock.readLock().lock();
        try {
            for (List<RunDashboardService> services : this.myServices) {
                for (RunDashboardService service : services) {
                    if (!descriptorId.equals((Object)service.getDescriptorId())) continue;
                    RunDashboardService runDashboardService = service;
                    return runDashboardService;
                }
            }
        }
        finally {
            this.myServiceLock.readLock().unlock();
            this.updateDashboard(true);
        }
        return null;
    }

    @Nullable
    public RunnerAndConfigurationSettings findSettings(@NotNull RunContentDescriptorId descriptorId) {
        RunnerAndConfigurationSettings baseSettings;
        RunContentDescriptor descriptor;
        if (descriptorId == null) {
            RunDashboardManagerImpl.$$$reportNull$$$0(33);
        }
        if ((descriptor = RunDashboardManagerImpl.getDescriptorById(descriptorId, this.myProject)) == null) {
            return null;
        }
        RunnerAndConfigurationSettings settings = this.findSettings(descriptor);
        if (settings == null) {
            return null;
        }
        RunConfiguration baseConfiguration = RunDashboardManagerImpl.getBaseConfiguration(settings.getConfiguration());
        if (baseConfiguration != null && (baseSettings = RunManager.getInstance((Project)this.myProject).findSettings(baseConfiguration)) != null) {
            return baseSettings;
        }
        return settings;
    }

    @Nullable
    private static RunContentDescriptor getDescriptorById(@NotNull RunContentDescriptorId descriptorId, @NotNull Project project) {
        if (descriptorId == null) {
            RunDashboardManagerImpl.$$$reportNull$$$0(34);
        }
        if (project == null) {
            RunDashboardManagerImpl.$$$reportNull$$$0(35);
        }
        RunContentDescriptor descriptor = null;
        if (descriptorId instanceof RunContentDescriptorIdImpl) {
            RunContentDescriptorIdImpl impl = (RunContentDescriptorIdImpl)descriptorId;
            descriptor = RunContentDescriptorIdImplKt.findContentValue((RunContentDescriptorIdImpl)impl);
        }
        return descriptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private RunnerAndConfigurationSettings findSettings(@NotNull RunContentDescriptor descriptor) {
        Set environments;
        ExecutionEnvironment environment;
        if (descriptor == null) {
            RunDashboardManagerImpl.$$$reportNull$$$0(36);
        }
        if ((environment = (ExecutionEnvironment)ContainerUtil.getFirstItem((Collection)(environments = ExecutionManagerImpl.getInstance((Project)this.myProject).getExecutionEnvironments(descriptor)))) == null) {
            return null;
        }
        RunnerAndConfigurationSettings settings = environment.getRunnerAndConfigurationSettings();
        if (settings != null) {
            return settings;
        }
        RunProfile runProfile = environment.getRunProfile();
        if (!(runProfile instanceof RunConfiguration)) {
            return null;
        }
        RunConfiguration runConfiguration = (RunConfiguration)runProfile;
        this.myServiceLock.readLock().lock();
        try {
            for (List<RunDashboardService> services : this.myServices) {
                for (RunDashboardService service : services) {
                    if (!runConfiguration.equals((Object)service.getConfigurationSettings().getConfiguration())) continue;
                    RunnerAndConfigurationSettings runnerAndConfigurationSettings = service.getConfigurationSettings();
                    return runnerAndConfigurationSettings;
                }
            }
        }
        finally {
            this.myServiceLock.readLock().unlock();
        }
        return new RunnerAndConfigurationSettingsImpl(RunManagerImpl.getInstanceImpl((Project)this.myProject), runConfiguration);
    }

    @Nullable
    public List<RunDashboardService> getServices(@NotNull RunnerAndConfigurationSettings settings) {
        if (settings == null) {
            RunDashboardManagerImpl.$$$reportNull$$$0(37);
        }
        for (List<RunDashboardService> services : this.myServices) {
            if (!services.get(0).getConfigurationSettings().equals((Object)settings)) continue;
            return services;
        }
        return null;
    }

    private static boolean updateServiceSettings(Project project, List<? extends List<RunDashboardService>> newServiceList, List<RunDashboardService> oldServices) {
        RunDashboardService oldService = oldServices.get(0);
        RunnerAndConfigurationSettings oldSettings = oldService.getConfigurationSettings();
        for (List<RunDashboardService> list : newServiceList) {
            RunnerAndConfigurationSettings newSettings = list.get(0).getConfigurationSettings();
            if (!newSettings.getType().equals((Object)oldSettings.getType()) || !newSettings.getName().equals(oldSettings.getName())) continue;
            list.remove(0);
            list.add(0, new RunDashboardServiceImpl(oldService.getScope(), newSettings, oldService.getDescriptorId()));
            for (int i = 1; i < oldServices.size(); ++i) {
                RunDashboardServiceImpl newService = new RunDashboardServiceImpl(oldService.getScope(), newSettings, oldServices.get(i).getDescriptorId());
                list.add(newService);
            }
            return true;
        }
        return false;
    }

    @NotNull
    public Set<String> getEnableByDefaultTypes() {
        HashSet<String> result = new HashSet<String>();
        for (RunDashboardDefaultTypesProvider provider : DEFAULT_TYPES_PROVIDER_EP_NAME.getExtensionList()) {
            result.addAll(provider.getDefaultTypeIds(this.myProject));
        }
        HashSet<String> hashSet = result;
        if (hashSet == null) {
            RunDashboardManagerImpl.$$$reportNull$$$0(38);
        }
        return hashSet;
    }

    @NotNull
    public State getState() {
        Set<String> configurations;
        ConfigurationType type;
        this.myState.excludedNewTypes.retainAll(this.myTypes);
        this.myState.hiddenConfigurations.clear();
        for (RunConfiguration runConfiguration : this.myHiddenConfigurations) {
            type = runConfiguration.getType();
            if (!this.myTypes.contains(type.getId())) continue;
            configurations = this.myState.hiddenConfigurations.get(type.getId());
            if (configurations == null) {
                configurations = new HashSet<String>();
                this.myState.hiddenConfigurations.put(type.getId(), configurations);
            }
            configurations.add(runConfiguration.getName());
        }
        this.myState.shownConfigurations.clear();
        for (RunConfiguration runConfiguration : this.myShownConfigurations) {
            type = runConfiguration.getType();
            if (!this.myTypes.contains(type.getId())) continue;
            configurations = this.myState.shownConfigurations.get(type.getId());
            if (configurations == null) {
                configurations = new HashSet<String>();
                this.myState.shownConfigurations.put(type.getId(), configurations);
            }
            configurations.add(runConfiguration.getName());
        }
        this.myState.configurationStatuses.clear();
        for (Map.Entry entry : this.myConfigurationStatuses.entrySet()) {
            RunConfiguration configuration = (RunConfiguration)entry.getKey();
            ConfigurationType type2 = configuration.getType();
            if (!this.myTypes.contains(type2.getId())) continue;
            Map<String, String> configurations2 = this.myState.configurationStatuses.get(type2.getId());
            if (configurations2 == null) {
                configurations2 = new HashMap<String, String>();
                this.myState.configurationStatuses.put(type2.getId(), configurations2);
            }
            configurations2.put(configuration.getName(), ((RunDashboardRunConfigurationStatus)entry.getValue()).getId());
        }
        for (String string : this.myState.excludedNewTypes) {
            Collection<RunConfiguration> hiddenConfigurations = this.getExcludedConfigurations(string, this.myShownConfigurations);
            this.myState.hiddenConfigurations.put(string, new HashSet(ContainerUtil.map(hiddenConfigurations, RunProfile::getName)));
        }
        State state = this.myState;
        if (state == null) {
            RunDashboardManagerImpl.$$$reportNull$$$0(39);
        }
        return state;
    }

    public void loadState(@NotNull State state) {
        if (state == null) {
            RunDashboardManagerImpl.$$$reportNull$$$0(40);
        }
        this.myState = state;
        this.myTypes.clear();
        this.myTypes.addAll(this.myState.configurationTypes);
        Set<String> enableByDefaultTypes = this.getEnableByDefaultTypes();
        enableByDefaultTypes.removeAll(this.myState.excludedTypes);
        this.myTypes.addAll(enableByDefaultTypes);
        this.myHiddenConfigurations.clear();
        this.myShownConfigurations.clear();
        this.myState.excludedNewTypes.retainAll(this.myTypes);
        if (!this.myTypes.isEmpty()) {
            this.loadStatuses();
            this.loadHiddenConfigurations();
            this.initTypes();
        }
    }

    private void loadHiddenConfigurations() {
        for (Map.Entry<String, Set<String>> entry : this.myState.hiddenConfigurations.entrySet()) {
            if (this.myState.excludedNewTypes.contains(entry.getKey())) continue;
            this.loadConfigurations(entry.getKey(), entry.getValue(), this.myHiddenConfigurations);
        }
        for (Map.Entry<String, Set<String>> entry : this.myState.shownConfigurations.entrySet()) {
            this.loadConfigurations(entry.getKey(), entry.getValue(), this.myShownConfigurations);
        }
    }

    private void loadConfigurations(String typeId, Set<String> configurationNames, Set<RunConfiguration> result) {
        ConfigurationType type = ConfigurationTypeUtil.findConfigurationType((String)typeId);
        if (type == null) {
            return;
        }
        List configurations = RunManager.getInstance((Project)this.myProject).getConfigurationsList(type);
        result.addAll(ContainerUtil.filter((Collection)configurations, configuration -> configurationNames.contains(configuration.getName())));
    }

    private void loadStatuses() {
        this.myState.configurationStatuses.forEach((typeId, statuses) -> {
            ConfigurationType type = ConfigurationTypeUtil.findConfigurationType((String)typeId);
            if (type == null) {
                return;
            }
            List configurations = RunManager.getInstance((Project)this.myProject).getConfigurationsList(type);
            statuses.forEach((name, statusId) -> {
                RunConfiguration configuration = (RunConfiguration)ContainerUtil.find((Iterable)configurations, it -> it.getName().equals(name));
                if (configuration == null) {
                    return;
                }
                RunDashboardRunConfigurationStatus status = RunDashboardRunConfigurationStatus.getStatusById((String)statusId);
                if (status == null) {
                    return;
                }
                this.myConfigurationStatuses.put(configuration, status);
            });
        });
    }

    private void initTypes() {
        this.syncConfigurations();
        this.initServiceContentListeners();
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            if (!this.myProject.isDisposed()) {
                this.updateDashboard(true);
            }
        });
    }

    public void noStateLoaded() {
        this.myTypes.clear();
        if (this.myProject.isDefault()) {
            this.myTypes.addAll(this.getEnableByDefaultTypes());
        } else {
            this.myTypes.addAll(RunDashboardManagerImpl.getInstance(ProjectManager.getInstance().getDefaultProject()).getTypes());
        }
        if (!this.myTypes.isEmpty()) {
            this.initTypes();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 9, 11, 18, 27, 28, 29, 38, 39 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "coroutineScope";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentWithNewDescriptor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldDescriptor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "link";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serviceId";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runConfiguration";
                break;
            }
            case 9: 
            case 11: 
            case 18: 
            case 27: 
            case 28: 
            case 29: 
            case 38: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/platform/execution/dashboard/RunDashboardManagerImpl";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurations";
                break;
            }
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeId";
                break;
            }
            case 15: 
            case 16: 
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 17: 
            case 25: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldDescriptorId";
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 26: 
            case 30: 
            case 32: 
            case 33: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptorId";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "service";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/platform/execution/dashboard/RunDashboardManagerImpl";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypes";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getHiddenConfigurations";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getCustomizers";
                break;
            }
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "doAttachServiceRunContentDescriptor";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getEnableByDefaultTypes";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "updateServiceRunContentDescriptor";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "runCallbackForLink";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isShowInDashboard";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isShown";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getBaseConfiguration";
                break;
            }
            case 9: 
            case 11: 
            case 18: 
            case 27: 
            case 28: 
            case 29: 
            case 38: 
            case 39: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "setTypes";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "restoreConfigurations";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isNewExcluded";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "setNewExcluded";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "clearConfigurationStatus";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getPersistedStatus";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getCustomizers";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "updateDashboardIfNeeded";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getConfigurationDescriptors";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "attachServiceRunContentDescriptor";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "detachServiceRunContentDescriptor";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "doAttachServiceRunContentDescriptor";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "areSameOriginDescriptorsBeingExchanged";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "doDetachServiceRunContentDescriptor";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "findService";
                break;
            }
            case 33: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "findSettings";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getDescriptorById";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getServices";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 9, 11, 18, 27, 28, 29, 38, 39 -> new IllegalStateException(string);
        };
    }

    static final class State {
        public final Set<String> configurationTypes = new HashSet<String>();
        public final Set<String> excludedTypes = new HashSet<String>();
        public final Map<String, Set<String>> hiddenConfigurations = new HashMap<String, Set<String>>();
        public final Map<String, Set<String>> shownConfigurations = new HashMap<String, Set<String>>();
        public final Map<String, Map<String, String>> configurationStatuses = new HashMap<String, Map<String, String>>();
        public final Set<String> excludedNewTypes = new HashSet<String>();
        public boolean openRunningConfigInTab = false;

        State() {
        }
    }

    public static final class RunDashboardServiceImpl
    implements RunDashboardService {
        private final CoroutineScope myScope;
        private final RunnerAndConfigurationSettings mySettings;
        private RunContentDescriptorId myDescriptorId;
        private final RunDashboardServiceId myId;

        RunDashboardServiceImpl(@NotNull CoroutineScope scope, @NotNull RunnerAndConfigurationSettings settings, @Nullable RunContentDescriptorId descriptorId) {
            if (scope == null) {
                RunDashboardServiceImpl.$$$reportNull$$$0(0);
            }
            if (settings == null) {
                RunDashboardServiceImpl.$$$reportNull$$$0(1);
            }
            this.mySettings = settings;
            this.myDescriptorId = descriptorId;
            this.myScope = scope;
            this.myId = (RunDashboardServiceId)BackendGlobalIdsKt.storeValueGlobally((CoroutineScope)scope, (Object)this, (BackendValueIdType)RunDashboardServiceIdType.INSTANCE);
        }

        @NotNull
        public CoroutineScope getScope() {
            CoroutineScope coroutineScope = this.myScope;
            if (coroutineScope == null) {
                RunDashboardServiceImpl.$$$reportNull$$$0(2);
            }
            return coroutineScope;
        }

        @NotNull
        public RunDashboardServiceId getUuid() {
            RunDashboardServiceId runDashboardServiceId = this.myId;
            if (runDashboardServiceId == null) {
                RunDashboardServiceImpl.$$$reportNull$$$0(3);
            }
            return runDashboardServiceId;
        }

        @NotNull
        public RunnerAndConfigurationSettings getConfigurationSettings() {
            RunnerAndConfigurationSettings runnerAndConfigurationSettings = this.mySettings;
            if (runnerAndConfigurationSettings == null) {
                RunDashboardServiceImpl.$$$reportNull$$$0(4);
            }
            return runnerAndConfigurationSettings;
        }

        @Nullable
        public RunContentDescriptorId getDescriptorId() {
            return this.myDescriptorId;
        }

        public Content getContent() {
            RunContentDescriptor descriptor = this.getDescriptor();
            return descriptor == null ? null : descriptor.getAttachedContent();
        }

        @Nullable
        public RunContentDescriptor getDescriptor() {
            RunContentDescriptorId descriptorId = this.myDescriptorId;
            if (descriptorId == null) {
                return null;
            }
            return RunDashboardManagerImpl.getDescriptorById(descriptorId, this.mySettings.getConfiguration().getProject());
        }

        void setDescriptorId(@Nullable RunContentDescriptorId descriptorId) {
            this.myDescriptorId = descriptorId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RunDashboardServiceImpl service = (RunDashboardServiceImpl)o;
            return this.mySettings.equals((Object)service.mySettings);
        }

        public int hashCode() {
            return this.mySettings.hashCode();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3, 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "scope";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "settings";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/platform/execution/dashboard/RunDashboardManagerImpl$RunDashboardServiceImpl";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/platform/execution/dashboard/RunDashboardManagerImpl$RunDashboardServiceImpl";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getScope";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getUuid";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getConfigurationSettings";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3, 4 -> new IllegalStateException(string);
            };
        }
    }

    static final class AdditionalRunDashboardService
    implements RunDashboardService {
        private final RunnerAndConfigurationSettings mySettings;
        private final RunContentDescriptorId myDescriptorId;
        private final RunDashboardServiceId myId;

        AdditionalRunDashboardService(@NotNull RunnerAndConfigurationSettings settings, @NotNull RunContentDescriptorId descriptorId, @NotNull RunDashboardServiceId id) {
            if (settings == null) {
                AdditionalRunDashboardService.$$$reportNull$$$0(0);
            }
            if (descriptorId == null) {
                AdditionalRunDashboardService.$$$reportNull$$$0(1);
            }
            if (id == null) {
                AdditionalRunDashboardService.$$$reportNull$$$0(2);
            }
            this.mySettings = settings;
            this.myDescriptorId = descriptorId;
            this.myId = id;
        }

        @NotNull
        public RunDashboardServiceId getUuid() {
            RunDashboardServiceId runDashboardServiceId = this.myId;
            if (runDashboardServiceId == null) {
                AdditionalRunDashboardService.$$$reportNull$$$0(3);
            }
            return runDashboardServiceId;
        }

        public CoroutineScope getScope() {
            return null;
        }

        @NotNull
        public RunnerAndConfigurationSettings getConfigurationSettings() {
            RunnerAndConfigurationSettings runnerAndConfigurationSettings = this.mySettings;
            if (runnerAndConfigurationSettings == null) {
                AdditionalRunDashboardService.$$$reportNull$$$0(4);
            }
            return runnerAndConfigurationSettings;
        }

        @NotNull
        public RunContentDescriptorId getDescriptorId() {
            RunContentDescriptorId runContentDescriptorId = this.myDescriptorId;
            if (runContentDescriptorId == null) {
                AdditionalRunDashboardService.$$$reportNull$$$0(5);
            }
            return runContentDescriptorId;
        }

        @Nullable
        public RunContentDescriptor getDescriptor() {
            return RunDashboardManagerImpl.getDescriptorById(this.myDescriptorId, this.mySettings.getConfiguration().getProject());
        }

        public Content getContent() {
            return this.getDescriptor().getAttachedContent();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AdditionalRunDashboardService service = (AdditionalRunDashboardService)o;
            return this.mySettings.equals((Object)service.mySettings) && Comparing.equal((Object)this.myDescriptorId, (Object)service.myDescriptorId);
        }

        public int hashCode() {
            int result = this.mySettings.hashCode();
            result = 31 * result + this.myDescriptorId.hashCode();
            return result;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3, 4, 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "settings";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptorId";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "id";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/platform/execution/dashboard/RunDashboardManagerImpl$AdditionalRunDashboardService";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/platform/execution/dashboard/RunDashboardManagerImpl$AdditionalRunDashboardService";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getUuid";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getConfigurationSettings";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDescriptorId";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3, 4, 5 -> new IllegalStateException(string);
            };
        }
    }
}

