/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.eel.impl.local;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.platform.eel.EelApi;
import com.intellij.platform.eel.EelDescriptor;
import com.intellij.platform.eel.EelResult;
import com.intellij.platform.eel.fs.EelFileSystemApi;
import com.intellij.platform.eel.impl.fs.EelFsResultImpl;
import com.intellij.platform.eel.path.EelPath;
import com.intellij.platform.eel.provider.EelNioBridgeServiceKt;
import com.intellij.platform.eel.provider.LocalEelDescriptor;
import com.intellij.util.text.StringKt;
import java.io.File;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import kotlin.text.HexExtensionsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u00006\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u001c\u0010\u0000\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00012\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u001c\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00012\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001aD\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00012\u0006\u0010\u0004\u001a\u00020\u00052&\u0010\b\u001a\"\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b\u0012\u0006\u0012\u0004\u0018\u00010\u000b\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\n0\tH\u0002\u001a\b\u0010\u0010\u001a\u00020\u0002H\u0002\"\u0013\u0010\r\u001a\u00070\u000e\u00a2\u0006\u0002\b\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"doCreateTemporaryDirectory", "Lcom/intellij/platform/eel/EelResult;", "Lcom/intellij/platform/eel/path/EelPath;", "Lcom/intellij/platform/eel/fs/EelFileSystemApi$CreateTemporaryEntryError;", "options", "Lcom/intellij/platform/eel/fs/EelFileSystemApi$CreateTemporaryEntryOptions;", "doCreateTemporaryFile", "doCreateTemporaryEntry", "localCreator", "Lkotlin/Function4;", "Ljava/io/File;", "", "", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLocalUserHome", "intellij.platform.eel.impl"})
@SourceDebugExtension(value={"SMAP\nLocalEelApiImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LocalEelApiImpl.kt\ncom/intellij/platform/eel/impl/local/LocalEelApiImplKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,135:1\n1#2:136\n*E\n"})
public final class LocalEelApiImplKt {
    @NotNull
    private static final Logger LOG;

    private static final EelResult<EelPath, EelFileSystemApi.CreateTemporaryEntryError> doCreateTemporaryDirectory(EelFileSystemApi.CreateTemporaryEntryOptions options) {
        return LocalEelApiImplKt.doCreateTemporaryEntry(options, (Function4<? super File, ? super String, ? super String, ? super Boolean, ? extends File>)((Function4)LocalEelApiImplKt::doCreateTemporaryDirectory$lambda$0));
    }

    private static final EelResult<EelPath, EelFileSystemApi.CreateTemporaryEntryError> doCreateTemporaryFile(EelFileSystemApi.CreateTemporaryEntryOptions options) {
        return LocalEelApiImplKt.doCreateTemporaryEntry(options, (Function4<? super File, ? super String, ? super String, ? super Boolean, ? extends File>)((Function4)LocalEelApiImplKt::doCreateTemporaryFile$lambda$0));
    }

    private static final EelResult<EelPath, EelFileSystemApi.CreateTemporaryEntryError> doCreateTemporaryEntry(EelFileSystemApi.CreateTemporaryEntryOptions options, Function4<? super File, ? super String, ? super String, ? super Boolean, ? extends File> localCreator) {
        Object object = options.getParentDirectory();
        if (object == null || (object = EelNioBridgeServiceKt.asNioPathOrNull((EelPath)object)) == null || (object = object.toFile()) == null) {
            boolean bl = false;
            Path path = Path.of(FileUtilRt.getTempDirectory(), new String[0]);
            object = path.toFile();
        }
        Object dir = object;
        Intrinsics.checkNotNull((Object)dir);
        File tempEntry = (File)localCreator.invoke(dir, (Object)options.getPrefix(), (Object)StringKt.nullize$default((String)options.getSuffix(), (boolean)false, (int)1, null), (Object)options.getDeleteOnExit());
        Path path = tempEntry.toPath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toPath(...)");
        EelPath tempDirectoryEel = EelNioBridgeServiceKt.asEelPath((Path)path);
        return (EelResult)new EelFsResultImpl.Ok<EelPath>(tempDirectoryEel);
    }

    private static final EelPath getLocalUserHome() {
        String homeDirPath = ((Object)Path.of(System.getProperty("user.home"), new String[0]).toAbsolutePath()).toString();
        EelPath eelPath = EelPath.Companion.parse(homeDirPath, (EelDescriptor)LocalEelDescriptor.INSTANCE);
        if (eelPath == null) {
            boolean bl = false;
            String string = "Can't parse home dir path: " + homeDirPath;
            throw new IllegalStateException(string.toString());
        }
        return eelPath;
    }

    private static final File doCreateTemporaryDirectory$lambda$0(File dir, String prefix, String suffix, boolean deleteOnExit) {
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        File file = FileUtil.createTempDirectory((File)dir, (String)(prefix + HexExtensionsKt.toHexString$default((byte[])Random.Default.nextBytes(16), null, (int)1, null)), (String)suffix, (boolean)deleteOnExit);
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"createTempDirectory(...)");
        return file;
    }

    private static final File doCreateTemporaryFile$lambda$0(File dir, String prefix, String suffix, boolean deleteOnExit) {
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        File file = FileUtil.createTempFile((File)dir, (String)prefix, (String)suffix, (boolean)deleteOnExit);
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"createTempFile(...)");
        return file;
    }

    public static final /* synthetic */ EelPath access$getLocalUserHome() {
        return LocalEelApiImplKt.getLocalUserHome();
    }

    public static final /* synthetic */ EelResult access$doCreateTemporaryDirectory(EelFileSystemApi.CreateTemporaryEntryOptions options) {
        return LocalEelApiImplKt.doCreateTemporaryDirectory(options);
    }

    public static final /* synthetic */ EelResult access$doCreateTemporaryFile(EelFileSystemApi.CreateTemporaryEntryOptions options) {
        return LocalEelApiImplKt.doCreateTemporaryFile(options);
    }

    static {
        Logger logger = Logger.getInstance(EelApi.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }
}

