/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.station.core.toolbox;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.OSProcessUtil;
import com.intellij.execution.process.ProcessInfo;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.util.ExecUtil;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.idea.AppMode;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.openapi.util.io.NioPathUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.commercial.dependencies.StationDependenciesDownloader;
import com.intellij.station.core.toolbox.ToolboxDiscovery;
import com.intellij.station.core.toolbox.ToolboxStatus;
import com.intellij.station.core.toolbox.ToolboxStatusService;
import com.intellij.util.SystemProperties;
import com.intellij.util.download.DownloadableFileService;
import com.intellij.util.system.OS;
import com.sun.jna.platform.win32.Guid;
import com.sun.jna.platform.win32.KnownFolders;
import com.sun.jna.platform.win32.Shell32Util;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.invoke.MethodHandles;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.NotImplementedError;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.io.TextStreamsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.SpreadBuilder;
import kotlin.jvm.optionals.OptionalsKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.TimeoutKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.intellij.build.dependencies.BuildDependenciesCommunityRoot;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\r\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u0006\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\b\u0012\u0004\u0012\u00020\t0\u00072\u0006\u0010\n\u001a\u00020\u000bH\u0086@\u00a2\u0006\u0002\u0010\fJ\b\u0010\r\u001a\u00020\bH\u0002J!\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0012\u0010\u0010\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00120\u0011\"\u00020\u0012\u00a2\u0006\u0002\u0010\u0013J\u0006\u0010\u0014\u001a\u00020\u0015J\u0018\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u000bH\u0080@\u00a2\u0006\u0004\b\u0018\u0010\fJ\u0018\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u000bH\u0080@\u00a2\u0006\u0004\b\u001a\u0010\fJ\u001e\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\u000bH\u0086@\u00a2\u0006\u0002\u0010\u001dJ\u001e\u0010\u001e\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\b2\u0006\u0010\u001f\u001a\u00020\bH\u0082@\u00a2\u0006\u0002\u0010 J\u0018\u0010!\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\b2\u0006\u0010\u001f\u001a\u00020\bH\u0002J\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020$0#J\u000e\u0010%\u001a\u00020\u000bH\u0082@\u00a2\u0006\u0002\u0010&J\u000f\u0010'\u001a\u0004\u0018\u00010\tH\u0000\u00a2\u0006\u0002\b(J\b\u0010)\u001a\u00020\bH\u0002J\u0012\u0010*\u001a\u0004\u0018\u00010\b2\u0006\u0010+\u001a\u00020\u000bH\u0002J\b\u0010,\u001a\u00020\bH\u0002J-\u0010-\u001a\u0004\u0018\u00010.2\b\b\u0002\u0010+\u001a\u00020\u000b2\u0012\u0010\u0010\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00120\u0011\"\u00020\u0012H\u0002\u00a2\u0006\u0002\u0010/R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lcom/intellij/station/core/toolbox/ToolboxDiscovery;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "findOrDownloadFreshToolboxInstaller", "Lkotlin/Pair;", "Ljava/nio/file/Path;", "Lcom/intellij/openapi/util/BuildNumber;", "allowDownload", "", "(ZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "discoverToolboxInstallerPath", "launchDaemonSafe", "Ljava/lang/ProcessHandle;", "args", "", "", "([Ljava/lang/String;)Ljava/lang/ProcessHandle;", "openToolboxSafe", "", "findOrInstallToolboxSafe", "isFullApp", "findOrInstallToolboxSafe$intellij_station_core", "installOrUpdate", "installOrUpdate$intellij_station_core", "installToolbox", "dist", "(Ljava/nio/file/Path;ZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "extractDistTo", "target", "(Ljava/nio/file/Path;Ljava/nio/file/Path;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "cleanupExtractedDist", "listRunningToolboxProcesses", "", "Lcom/intellij/execution/process/ProcessInfo;", "killAllToolboxProcesses", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getInstalledBuild", "getInstalledBuild$intellij_station_core", "discoverToolboxBinaryDir", "discoverToolboxExecutablePath", "forDaemon", "discoverToolboxAppOnMacOS", "createLaunchToolboxCommand", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "(Z[Ljava/lang/String;)Lcom/intellij/execution/configurations/GeneralCommandLine;", "intellij.station.core"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nToolboxDiscovery.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ToolboxDiscovery.kt\ncom/intellij/station/core/toolbox/ToolboxDiscovery\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,429:1\n827#2:430\n855#2,2:431\n3919#3:433\n4434#3,2:434\n1#4:436\n57#5:437\n35#5,2:438\n*S KotlinDebug\n*F\n+ 1 ToolboxDiscovery.kt\ncom/intellij/station/core/toolbox/ToolboxDiscovery\n*L\n65#1:430\n65#1:431,2\n287#1:433\n287#1:434,2\n39#1:437\n39#1:438,2\n*E\n"})
public final class ToolboxDiscovery {
    @NotNull
    public static final ToolboxDiscovery INSTANCE = new ToolboxDiscovery();
    @NotNull
    private static final Logger LOG;

    private ToolboxDiscovery() {
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object findOrDownloadFreshToolboxInstaller(boolean allowDownload, @NotNull Continuation<? super Pair<? extends Path, BuildNumber>> $completion) {
        block16: {
            if (!($completion instanceof findOrDownloadFreshToolboxInstaller.1)) ** GOTO lbl-1000
            var19_3 = $completion;
            if ((var19_3.label & -2147483648) != 0) {
                var19_3.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, $completion){
                    boolean Z$0;
                    Object L$0;
                    Object L$1;
                    Object L$2;
                    Object L$3;
                    /* synthetic */ Object result;
                    final /* synthetic */ ToolboxDiscovery this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return this.this$0.findOrDownloadFreshToolboxInstaller(false, (Continuation<? super Pair<? extends Path, BuildNumber>>)((Continuation)this));
                    }
                };
            }
            $result = $continuation.result;
            var20_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    toolbox = this.discoverToolboxInstallerPath();
                    if (!PluginManagerCore.isRunningFromSources() && !AppMode.isRunningFromDevBuild()) break;
                    v0 = Path.of(PathManager.getCommunityHomePath(), new String[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"of(...)");
                    communityRoot = new BuildDependenciesCommunityRoot(v0);
                    versionString = StationDependenciesDownloader.INSTANCE.getToolboxBuildNumber(communityRoot);
                    v1 = BuildNumber.fromString((String)versionString);
                    if (v1 == null) {
                        throw new IllegalStateException(("Invalid version: " + versionString).toString());
                    }
                    version = v1;
                    if (!allowDownload) {
                        ToolboxDiscovery.LOG.debug("Toolbox discovery is not allowed to download its distribution (dev mode)");
                        return TuplesKt.to(null, (Object)version);
                    }
                    $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)toolbox);
                    $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)communityRoot);
                    $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)versionString);
                    $continuation.L$3 = version;
                    $continuation.Z$0 = allowDownload;
                    $continuation.label = 1;
                    v2 = StationDependenciesDownloader.INSTANCE.downloadToolbox(communityRoot, (Continuation)$continuation);
                    if (v2 == var20_5) {
                        return var20_5;
                    }
                    ** GOTO lbl43
                }
                case 1: {
                    allowDownload = $continuation.Z$0;
                    version = (BuildNumber)$continuation.L$3;
                    versionString = (String)$continuation.L$2;
                    communityRoot = (BuildDependenciesCommunityRoot)$continuation.L$1;
                    toolbox = (Path)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v2 = $result;
lbl43:
                    // 2 sources

                    downloaded = (StationDependenciesDownloader.ToolboxDownloadResult)v2;
                    v3 = TuplesKt.to((Object)downloaded.getSource(), (Object)version);
                    break block16;
                }
            }
            files = PathsKt.listDirectoryEntries$default((Path)toolbox, null, (int)1, null);
            if (files.size() == 2) {
                v4 = toolbox.resolve("build.txt");
                Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"resolve(...)");
                buildTxt = v4;
                v5 = toolbox.resolve("build.txt");
                Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"resolve(...)");
                buildTxtContent = PathsKt.readText$default((Path)v5, null, (int)1, null);
                v6 = BuildNumber.fromString((String)buildTxtContent);
                if (v6 == null) {
                    throw new IllegalStateException(("Invalid version: " + buildTxtContent).toString());
                }
                version = v6;
                $this$filterNot$iv = files;
                $i$f$filterNot = false;
                var11_25 = $this$filterNot$iv;
                destination$iv$iv = new ArrayList<E>();
                $i$f$filterNotTo = false;
                for (T element$iv$iv : $this$filterNotTo$iv$iv) {
                    it = (Path)element$iv$iv;
                    $i$a$-filterNot-ToolboxDiscovery$findOrDownloadFreshToolboxInstaller$dist$1 = false;
                    if (Intrinsics.areEqual((Object)it, (Object)buildTxt)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                dist = (Path)CollectionsKt.single((List)((List)destination$iv$iv));
                v3 = TuplesKt.to((Object)dist, (Object)version);
            } else {
                v7 = toolbox.resolve("build.txt");
                Intrinsics.checkNotNullExpressionValue((Object)v7, (String)"resolve(...)");
                buildTxtContent = PathsKt.readText$default((Path)v7, null, (int)1, null);
                v8 = BuildNumber.fromString((String)buildTxtContent);
                if (v8 == null) {
                    throw new IllegalStateException(("Invalid version: " + buildTxtContent).toString());
                }
                version = v8;
                if (!allowDownload) {
                    ToolboxDiscovery.LOG.debug("Toolbox discovery is not allowed to download its distribution");
                    return TuplesKt.to(null, (Object)version);
                }
                v9 = version.toString();
                Intrinsics.checkNotNullExpressionValue((Object)v9, (String)"toString(...)");
                fileName = StationDependenciesDownloader.INSTANCE.getDownloadFileName(v9);
                v10 = DownloadableFileService.getInstance().createFileDescription(StationDependenciesDownloader.INSTANCE.getDownloadLink(fileName), fileName);
                Intrinsics.checkNotNullExpressionValue((Object)v10, (String)"createFileDescription(...)");
                fileInfo = v10;
                tmpDir = Files.createTempDirectory(fileName, new FileAttribute[0]);
                v11 = DownloadableFileService.getInstance().createDownloader(CollectionsKt.listOf((Object)fileInfo), fileName);
                Intrinsics.checkNotNullExpressionValue((Object)v11, (String)"createDownloader(...)");
                downloader = v11;
                Intrinsics.checkNotNull((Object)tmpDir);
                files = downloader.downloadFilesWithProgress(tmpDir.toAbsolutePath().toString(), null, null);
                if (files == null || files.isEmpty()) {
                    ToolboxDiscovery.LOG.warn("Failed to download toolbox installer");
                    return TuplesKt.to(null, (Object)version);
                }
                v3 = TuplesKt.to((Object)((VirtualFile)CollectionsKt.first((List)files)).toNioPath(), (Object)version);
            }
        }
        return v3;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final Path discoverToolboxInstallerPath() {
        IdeaPluginDescriptor ideaPluginDescriptor = PluginManager.getInstance().findEnabledPlugin(PluginId.Companion.getId("com.jetbrains.station"));
        if (ideaPluginDescriptor == null) {
            throw new IllegalStateException("Can't find enabled station plugin".toString());
        }
        IdeaPluginDescriptor plugin = ideaPluginDescriptor;
        Path path = plugin.getPluginPath();
        if (path == null) {
            throw new IllegalStateException("Station plugin path must not be null".toString());
        }
        Path pluginPath = path;
        Path path2 = pluginPath.resolve("toolbox");
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"resolve(...)");
        return path2;
    }

    @Nullable
    public final ProcessHandle launchDaemonSafe(String ... args) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        GeneralCommandLine launchToolboxCommand = this.createLaunchToolboxCommand(true, Arrays.copyOf(args, args.length));
        if (launchToolboxCommand != null) {
            ProcessHandle processHandle;
            ProcessBuilder processBuilder = launchToolboxCommand.toProcessBuilder();
            Intrinsics.checkNotNullExpressionValue((Object)processBuilder, (String)"toProcessBuilder(...)");
            ProcessBuilder builder = processBuilder;
            builder.redirectOutput(ProcessBuilder.Redirect.DISCARD);
            builder.redirectError(ProcessBuilder.Redirect.DISCARD);
            try {
                processHandle = builder.start().toHandle();
            }
            catch (Exception ex) {
                LOG.error("Failed to launch daemon", (Throwable)ex);
                processHandle = null;
            }
            return processHandle;
        }
        LOG.warn("Unable to launch daemon: can't find the executable");
        return null;
    }

    public final void openToolboxSafe() {
        GeneralCommandLine launchToolboxCommand = ToolboxDiscovery.createLaunchToolboxCommand$default(this, false, new String[0], 1, null);
        if (launchToolboxCommand != null) {
            LOG.warn("Launching toolbox command: " + launchToolboxCommand.getCommandLineString());
            ProcessOutput output = ExecUtil.execAndGetOutput((GeneralCommandLine)launchToolboxCommand);
            if (output.getExitCode() == 0) {
                String string = output.getStderr();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getStderr(...)");
                if (((CharSequence)string).length() == 0) {
                    ToolboxStatusService.Companion.getInstance().rememberAboutInstallationAttempt();
                }
            }
            LOG.warn("Output of the toolbox command: exit code " + output.getExitCode() + ", stderr: " + output.getStderr());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public final Object findOrInstallToolboxSafe$intellij_station_core(boolean isFullApp, @NotNull Continuation<? super Unit> $completion) {
        if (!($completion instanceof findOrInstallToolboxSafe.1)) ** GOTO lbl-1000
        var5_3 = $completion;
        if ((var5_3.label & -2147483648) != 0) {
            var5_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                boolean Z$0;
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ ToolboxDiscovery this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.findOrInstallToolboxSafe$intellij_station_core(false, (Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var6_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                if (ToolboxStatusService.Companion.getInstance().getToolboxStatus().getValue() == ToolboxStatus.Installing) {
                    ToolboxDiscovery.LOG.debug("Toolbox is already being installed. Skipping another attempt");
                    return Unit.INSTANCE;
                }
                ToolboxStatusService.Companion.getInstance().getToolboxStatus().setValue((Object)ToolboxStatus.Installing);
                $continuation.Z$0 = isFullApp;
                $continuation.label = 1;
                v0 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(isFullApp != false, null){
                    int label;
                    final /* synthetic */ boolean $isFullApp;
                    {
                        this.$isFullApp = $isFullApp;
                        super(2, $completion);
                    }

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final Object invokeSuspend(Object $result) {
                        Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                this.label = 1;
                                Object object2 = ToolboxDiscovery.INSTANCE.installOrUpdate$intellij_station_core(this.$isFullApp, (Continuation<? super Unit>)((Continuation)this));
                                if (object2 != object) return Unit.INSTANCE;
                                return object;
                            }
                            case 1: {
                                ResultKt.throwOnFailure((Object)$result);
                                Object object2 = $result;
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (Continuation)$continuation);
                ** if (v0 != var6_5) goto lbl23
lbl22:
                // 1 sources

                return var6_5;
lbl23:
                // 1 sources

                ** GOTO lbl30
            }
            case 1: {
                isFullApp = $continuation.Z$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl30:
                // 2 sources

                $continuation.Z$0 = isFullApp;
                $continuation.label = 2;
                v1 = ToolboxStatusService.Companion.getInstance().updateToolboxStatusSafe((Continuation<? super Unit>)$continuation);
                v2 = v1;
                if (v1 != var6_5) return Unit.INSTANCE;
                return var6_5;
            }
            case 2: {
                isFullApp = $continuation.Z$0;
                ResultKt.throwOnFailure((Object)$result);
                v2 = $result;
                return Unit.INSTANCE;
            }
            catch (IllegalStateException e) {
                ToolboxDiscovery.LOG.debug("Toolbox installation failed with internal error", (Throwable)e);
                $continuation.Z$0 = isFullApp;
                $continuation.label = 3;
                v3 = ToolboxStatusService.Companion.getInstance().updateToolboxStatusSafe((Continuation<? super Unit>)$continuation);
                {
                    catch (Throwable var3_8) {
                        $continuation.L$0 = var3_8;
                        $continuation.Z$0 = isFullApp;
                        $continuation.label = 5;
                        v4 = ToolboxStatusService.Companion.getInstance().updateToolboxStatusSafe((Continuation<? super Unit>)$continuation);
                        v5 = v4;
                        if (v4 != var6_5) throw var3_9;
                        return var6_5;
                    }
                }
                v6 = v3;
                if (v3 != var6_5) return Unit.INSTANCE;
                return var6_5;
                case 3: {
                    isFullApp = $continuation.Z$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v6 = $result;
                    return Unit.INSTANCE;
                }
                catch (IOException e) {
                    ToolboxDiscovery.LOG.debug("Toolbox installation failed, IO", (Throwable)e);
                    $continuation.Z$0 = isFullApp;
                    $continuation.label = 4;
                    v7 = ToolboxStatusService.Companion.getInstance().updateToolboxStatusSafe((Continuation<? super Unit>)$continuation);
                    v8 = v7;
                    if (v7 != var6_5) return Unit.INSTANCE;
                    return var6_5;
                    case 4: {
                        isFullApp = $continuation.Z$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v8 = $result;
                        return Unit.INSTANCE;
                    }
                }
            }
            case 5: {
                isFullApp = $continuation.Z$0;
                var3_9 = (Throwable)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v5 = $result;
                throw var3_9;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object installOrUpdate$intellij_station_core(boolean isFullApp, @NotNull Continuation<? super Unit> $completion) {
        block12: {
            block13: {
                if (!($completion instanceof installOrUpdate.1)) ** GOTO lbl-1000
                var8_3 = $completion;
                if ((var8_3.label & -2147483648) != 0) {
                    var8_3.label -= -2147483648;
                } else lbl-1000:
                // 2 sources

                {
                    $continuation = new ContinuationImpl(this, $completion){
                        boolean Z$0;
                        Object L$0;
                        Object L$1;
                        Object L$2;
                        /* synthetic */ Object result;
                        final /* synthetic */ ToolboxDiscovery this$0;
                        int label;
                        {
                            this.this$0 = this$0;
                            super($completion);
                        }

                        @Nullable
                        public final Object invokeSuspend(@NotNull Object $result) {
                            this.result = $result;
                            this.label |= Integer.MIN_VALUE;
                            return this.this$0.installOrUpdate$intellij_station_core(false, (Continuation<? super Unit>)((Continuation)this));
                        }
                    };
                }
                $result = $continuation.result;
                var9_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch ($continuation.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        $continuation.Z$0 = isFullApp;
                        $continuation.label = 1;
                        v0 = this.findOrDownloadFreshToolboxInstaller(true, (Continuation<? super Pair<? extends Path, BuildNumber>>)$continuation);
                        if (v0 == var9_5) {
                            return var9_5;
                        }
                        ** GOTO lbl22
                    }
                    case 1: {
                        isFullApp = $continuation.Z$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl22:
                        // 2 sources

                        var3_6 = (Pair)v0;
                        dist = (Path)var3_6.component1();
                        distVersion = (BuildNumber)var3_6.component2();
                        installedBuild = this.getInstalledBuild$intellij_station_core();
                        if (dist == null) {
                            ToolboxDiscovery.LOG.debug("Toolbox installer distribution was not found. Abort process");
                            return Unit.INSTANCE;
                        }
                        if (installedBuild != null) break;
                        ToolboxDiscovery.LOG.debug("No Toolbox installation found, will install v" + distVersion + " from " + dist);
                        $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)dist);
                        $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)distVersion);
                        $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)installedBuild);
                        $continuation.Z$0 = isFullApp;
                        $continuation.label = 2;
                        v1 = this.installToolbox(dist, isFullApp != false, (Continuation<? super Unit>)$continuation);
                        if (v1 == var9_5) {
                            return var9_5;
                        }
                        ** GOTO lbl47
                    }
                    case 2: {
                        isFullApp = $continuation.Z$0;
                        installedBuild = (BuildNumber)$continuation.L$2;
                        distVersion = (BuildNumber)$continuation.L$1;
                        dist = (Path)$continuation.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl47:
                        // 2 sources

                        ToolboxDiscovery.LOG.debug("Toolbox installation completed");
                        break block12;
                    }
                }
                if (installedBuild.compareTo(distVersion) >= 0) break block13;
                ToolboxDiscovery.LOG.debug("Found toolbox v" + installedBuild + ", will update to v" + distVersion + " from " + dist);
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)dist);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)distVersion);
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)installedBuild);
                $continuation.Z$0 = isFullApp;
                $continuation.label = 3;
                v2 = this.installToolbox(dist, isFullApp != false, (Continuation<? super Unit>)$continuation);
                if (v2 == var9_5) {
                    return var9_5;
                }
                ** GOTO lbl67
                {
                    case 3: {
                        isFullApp = $continuation.Z$0;
                        installedBuild = (BuildNumber)$continuation.L$2;
                        distVersion = (BuildNumber)$continuation.L$1;
                        dist = (Path)$continuation.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v2 = $result;
lbl67:
                        // 2 sources

                        ToolboxDiscovery.LOG.debug("Toolbox update completed");
                        break block12;
                    }
                }
            }
            ToolboxDiscovery.LOG.debug("Toolbox v" + installedBuild + " is already installed");
        }
        return Unit.INSTANCE;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Nullable
    public final Object installToolbox(@NotNull Path dist, boolean isFullApp, @NotNull Continuation<? super Unit> $completion) {
        if (!($completion instanceof installToolbox.1)) ** GOTO lbl-1000
        var17_4 = $completion;
        if ((var17_4.label & -2147483648) != 0) {
            var17_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                boolean Z$0;
                /* synthetic */ Object result;
                final /* synthetic */ ToolboxDiscovery this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.installToolbox(null, false, (Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var18_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.L$0 = dist;
                $continuation.Z$0 = isFullApp;
                $continuation.label = 1;
                v0 = this.killAllToolboxProcesses((Continuation<? super Boolean>)$continuation);
                if (v0 == var18_6) {
                    return var18_6;
                }
                ** GOTO lbl24
            }
            case 1: {
                isFullApp = $continuation.Z$0;
                dist = (Path)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl24:
                // 2 sources

                if (!((Boolean)v0).booleanValue()) {
                    return Unit.INSTANCE;
                }
                preTarget = Files.createTempDirectory("jbapp", new FileAttribute[0]);
                Intrinsics.checkNotNull((Object)preTarget);
                $continuation.L$0 = dist;
                $continuation.L$1 = preTarget;
                $continuation.Z$0 = isFullApp;
                $continuation.label = 2;
                v1 = this.extractDistTo(dist, preTarget, (Continuation<? super Unit>)$continuation);
                ** if (v1 != var18_6) goto lbl37
lbl36:
                // 1 sources

                return var18_6;
lbl37:
                // 1 sources

                ** GOTO lbl46
            }
            case 2: {
                isFullApp = $continuation.Z$0;
                preTarget = (Path)$continuation.L$1;
                dist = (Path)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v1 = $result;
lbl46:
                    // 2 sources

                    if (var6_8 = isFullApp) {
                        v2 = TuplesKt.to((Object)"jetbrains-toolbox", (Object)"APP");
                    } else if (!var6_8) {
                        v2 = TuplesKt.to((Object)"jetbrainsd", (Object)"DAEMON");
                    } else {
                        throw new NoWhenBranchMatchedException();
                    }
                    var5_10 = v2;
                    executableName = (String)var5_10.component1();
                    installType = (String)var5_10.component2();
                    Intrinsics.checkNotNull((Object)preTarget);
                    var9_13 = preTarget;
                    v3 = OS.CURRENT;
                    switch (v3 == null ? -1 : WhenMappings.$EnumSwitchMapping$0[v3.ordinal()]) {
                        case 1: {
                            v4 = executableName + ".exe";
                            break;
                        }
                        case 2: {
                            v4 = executableName;
                            break;
                        }
                        case 3: {
                            var11_14 = "somewhere in Helpers";
                            throw new NotImplementedError("An operation is not implemented: " + var11_14);
                        }
                        default: {
                            throw new IllegalStateException(("Not supported: " + OS.CURRENT).toString());
                        }
                    }
                    var10_18 = v4;
                    v5 = var9_13.resolve((String)var10_18);
                    Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"resolve(...)");
                    executable = v5;
                    var10_18 = new String[]{executable.toAbsolutePath().toString(), "--install", "--install-type=" + installType};
                    gcl = new GeneralCommandLine(var10_18);
                    selfInstallProcess = gcl.toProcessBuilder().start();
                    selfInstallProcess.waitFor(10L, TimeUnit.MINUTES);
                    if (!(selfInstallProcess.isAlive() == false)) {
                        var11_15 = "Failed requirement.";
                        throw new IllegalArgumentException(var11_15.toString());
                    }
                    if (!(selfInstallProcess.exitValue() == 0)) {
                        $i$a$-require-ToolboxDiscovery$installToolbox$2 = false;
                        v6 = selfInstallProcess.getErrorStream();
                        Intrinsics.checkNotNullExpressionValue((Object)v6, (String)"getErrorStream(...)");
                        var12_20 = v6;
                        var13_21 = Charsets.UTF_8;
                        var14_22 = new InputStreamReader(var12_20, var13_21);
                        var15_23 = 8192;
                        var11_17 = "Failed to install " + dist + ": " + TextStreamsKt.readText((Reader)(var14_22 instanceof BufferedReader != false ? (BufferedReader)var14_22 : new BufferedReader(var14_22, var15_23)));
                        throw new IllegalArgumentException(var11_17.toString());
                    }
                    ToolboxDiscovery.LOG.debug(gcl.getPreparedCommandLine() + " returned 0 in time");
                    this.cleanupExtractedDist(dist, preTarget);
                }
                catch (Throwable var5_11) {
                    Intrinsics.checkNotNull((Object)preTarget);
                    this.cleanupExtractedDist(dist, preTarget);
                    throw var5_11;
                }
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final Object extractDistTo(Path dist, Path target, Continuation<? super Unit> $completion) {
        LOG.debug("Installing Toolbox from " + dist);
        OS oS = OS.CURRENT;
        switch (oS == null ? -1 : WhenMappings.$EnumSwitchMapping$0[oS.ordinal()]) {
            case 1: {
                String[] stringArray = new String[]{((Object)dist).toString(), "self-extract", ((Object)target.toAbsolutePath()).toString()};
                GeneralCommandLine gcl = new GeneralCommandLine(stringArray);
                Process installerProcess = gcl.toProcessBuilder().start();
                installerProcess.waitFor(60L, TimeUnit.SECONDS);
                if (!(!installerProcess.isAlive())) {
                    String string = "Failed requirement.";
                    throw new IllegalArgumentException(string.toString());
                }
                if (!(installerProcess.exitValue() == 0)) {
                    boolean $i$a$-require-ToolboxDiscovery$extractDistTo$42 = false;
                    InputStream inputStream = installerProcess.getErrorStream();
                    Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"getErrorStream(...)");
                    InputStream inputStream2 = inputStream;
                    Charset charset = Charsets.UTF_8;
                    Reader reader = new InputStreamReader(inputStream2, charset);
                    int n = 8192;
                    String $i$a$-require-ToolboxDiscovery$extractDistTo$42 = "Failed to install " + dist + ": " + TextStreamsKt.readText((Reader)(reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader, n)));
                    throw new IllegalArgumentException($i$a$-require-ToolboxDiscovery$extractDistTo$42.toString());
                }
                LOG.debug(gcl.getPreparedCommandLine() + " returned 0 in time");
                break;
            }
            case 3: {
                LOG.debug("Mounting " + dist + " as " + target);
                String[] installerProcess = new String[]{"hdiutil", "attach", "-readonly", "-noautoopen", "-noautofsck", "-nobrowse", "-mountpoint", ((Object)target.toAbsolutePath()).toString(), ((Object)dist.toAbsolutePath()).toString()};
                GeneralCommandLine gcl = new GeneralCommandLine(installerProcess);
                Process process2 = gcl.toProcessBuilder().start();
                process2.waitFor(60L, TimeUnit.SECONDS);
                if (!(!process2.isAlive())) {
                    String $i$a$-require-ToolboxDiscovery$extractDistTo$42 = "Failed requirement.";
                    throw new IllegalArgumentException($i$a$-require-ToolboxDiscovery$extractDistTo$42.toString());
                }
                if (!(process2.exitValue() == 0)) {
                    boolean bl = false;
                    InputStream inputStream = process2.getErrorStream();
                    Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"getErrorStream(...)");
                    InputStream inputStream3 = inputStream;
                    Charset charset = Charsets.UTF_8;
                    Reader reader = new InputStreamReader(inputStream3, charset);
                    int n = 8192;
                    String string = "Failed to mount " + dist + ": " + TextStreamsKt.readText((Reader)(reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader, n)));
                    throw new IllegalArgumentException(string.toString());
                }
                LOG.debug("Mounted " + dist + " as " + target);
                break;
            }
            case 2: {
                String string = "untar";
                throw new NotImplementedError("An operation is not implemented: " + string);
            }
            default: {
                throw new IllegalStateException(("Not supported: " + OS.CURRENT).toString());
            }
        }
        return Unit.INSTANCE;
    }

    private final void cleanupExtractedDist(Path dist, Path target) {
        OS oS = OS.CURRENT;
        switch (oS == null ? -1 : WhenMappings.$EnumSwitchMapping$0[oS.ordinal()]) {
            case 3: {
                LOG.debug("Un-mounting " + dist);
                String[] stringArray = new String[]{"hdiutil", "detach", "-force", ((Object)target.toAbsolutePath()).toString()};
                GeneralCommandLine gcl = new GeneralCommandLine(stringArray);
                Process process2 = gcl.toProcessBuilder().start();
                process2.waitFor(60L, TimeUnit.SECONDS);
                if (!(!process2.isAlive())) {
                    String string = "Failed requirement.";
                    throw new IllegalArgumentException(string.toString());
                }
                if (!(process2.exitValue() == 0)) {
                    boolean bl = false;
                    InputStream inputStream = process2.getErrorStream();
                    Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"getErrorStream(...)");
                    InputStream inputStream2 = inputStream;
                    Charset charset = Charsets.UTF_8;
                    Reader reader = new InputStreamReader(inputStream2, charset);
                    int n = 8192;
                    String string = "Failed to un-mount " + dist + ": " + TextStreamsKt.readText((Reader)(reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader, n)));
                    throw new IllegalArgumentException(string.toString());
                }
                LOG.debug("Un-mounted " + dist);
                break;
            }
            case 1: 
            case 2: {
                PathsKt.deleteRecursively((Path)target);
                break;
            }
            default: {
                throw new IllegalStateException(("Not supported: " + OS.CURRENT).toString());
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<ProcessInfo> listRunningToolboxProcesses() {
        void $this$filterTo$iv$iv;
        ProcessInfo[] processInfoArray = OSProcessUtil.getProcessList();
        Intrinsics.checkNotNullExpressionValue((Object)processInfoArray, (String)"getProcessList(...)");
        Object[] $this$filter$iv = processInfoArray;
        boolean $i$f$filter = false;
        Object[] objectArray = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (void element$iv$iv : $this$filterTo$iv$iv) {
            ProcessInfo it = (ProcessInfo)element$iv$iv;
            boolean bl = false;
            String string = it.getExecutableDisplayName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getExecutableDisplayName(...)");
            if (!StringsKt.endsWith$default((String)string, (String)"jetbrains-toolbox", (boolean)false, (int)2, null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final Object killAllToolboxProcesses(Continuation<? super Boolean> $completion) {
        if (!($completion instanceof killAllToolboxProcesses.1)) ** GOTO lbl-1000
        var11_2 = $completion;
        if ((var11_2.label & -2147483648) != 0) {
            var11_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                /* synthetic */ Object result;
                final /* synthetic */ ToolboxDiscovery this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return ToolboxDiscovery.access$killAllToolboxProcesses(this.this$0, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var12_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                try {
                    processes = this.listRunningToolboxProcesses();
                    var3_6 = processes.iterator();
                }
                catch (Throwable e) {
                    ToolboxDiscovery.LOG.warn("Failed to kill all toolbox processes", e);
                    return Boxing.boxBoolean((boolean)false);
                }
lbl20:
                // 2 sources

                while (var3_6.hasNext()) {
                    process = (ProcessInfo)var3_6.next();
                    v0 = ProcessHandle.of(process.getPid());
                    Intrinsics.checkNotNullExpressionValue(v0, (String)"of(...)");
                    if ((ProcessHandle)OptionalsKt.getOrNull(v0) == null) {
                        $this$killAllToolboxProcesses_u24lambda_u240 = this;
                        $i$a$-run-ToolboxDiscovery$killAllToolboxProcesses$handle$1 = false;
                        ToolboxDiscovery.LOG.debug("Failed to get handle for " + process + ", can't check if it's alive");
                        return Boxing.boxBoolean((boolean)false);
                    }
                    ToolboxDiscovery.LOG.debug("Terminating process " + process);
                    try {
                        OSProcessUtil.terminateProcessGracefully((int)process.getPid());
                        ToolboxDiscovery.LOG.debug("Process " + process + " was gracefully terminated");
                    }
                    catch (UnsupportedOperationException <unused var>) {
                        ToolboxDiscovery.LOG.debug("Failed to gracefully terminate process " + process + ", killing it");
                        OSProcessUtil.killProcess((int)process.getPid());
                    }
                    $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)processes);
                    $continuation.L$1 = var3_6;
                    $continuation.L$2 = process;
                    $continuation.L$3 = handle;
                    $continuation.label = 1;
                    v1 = TimeoutKt.withTimeout((long)5000L, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(handle, null){
                        int label;
                        final /* synthetic */ ProcessHandle $handle;
                        {
                            this.$handle = $handle;
                            super(2, $completion);
                        }

                        /*
                         * Unable to fully structure code
                         */
                        public final Object invokeSuspend(Object $result) {
                            var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)$result);
lbl5:
                                    // 3 sources

                                    while (this.$handle.isAlive()) {
                                        this.label = 1;
                                        v0 = DelayKt.delay((long)100L, (Continuation)((Continuation)this));
                                        if (v0 != var2_2) continue;
                                        return var2_2;
                                    }
                                    break;
                                }
                                case 1: {
                                    ResultKt.throwOnFailure((Object)$result);
                                    v0 = $result;
                                    ** GOTO lbl5
                                }
                            }
                            return Unit.INSTANCE;
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                        }

                        public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }
                    }), (Continuation)$continuation);
                    if (v1 == var12_4) {
                        return var12_4;
                    }
                    ** GOTO lbl56
                }
                return Boxing.boxBoolean((boolean)true);
            }
            case 1: {
                handle = (ProcessHandle)$continuation.L$3;
                process = (ProcessInfo)$continuation.L$2;
                var3_6 = (Iterator)$continuation.L$1;
                processes = (List)$continuation.L$0;
                {
                    ResultKt.throwOnFailure((Object)$result);
                    v1 = $result;
lbl56:
                    // 2 sources

                    if (!(handle.isAlive() == false)) {
                        $i$a$-require-ToolboxDiscovery$killAllToolboxProcesses$4 = false;
                        var7_14 = "Failed to kill process " + process;
                        throw new IllegalArgumentException(var7_14.toString());
                    }
                    ToolboxDiscovery.LOG.debug("Process " + process + " was terminated");
                    ** GOTO lbl20
                }
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Nullable
    public final BuildNumber getInstalledBuild$intellij_station_core() {
        Path binDir = this.discoverToolboxBinaryDir();
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.isDirectory(binDir, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            LOG.debug(binDir + " directory not found, assuming no Toolbox installation");
            return null;
        }
        LOG.debug("Toolbox installation detected at " + binDir);
        BuildNumber buildNumber = BuildNumber.fromString((String)"2.6.0.34345");
        Intrinsics.checkNotNull((Object)buildNumber);
        BuildNumber lastVersionWithNoBuildNumber = buildNumber;
        Path path = binDir.resolve("build.txt");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        Path buildTxt = path;
        LinkOption[] linkOptionArray2 = new LinkOption[]{};
        if (!Files.isRegularFile(buildTxt, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length))) {
            LOG.debug(buildTxt + " file not found, assuming " + lastVersionWithNoBuildNumber + " or earlier");
            return lastVersionWithNoBuildNumber;
        }
        String buildTxtContents = PathsKt.readText$default((Path)buildTxt, null, (int)1, null);
        BuildNumber buildNumber2 = BuildNumber.fromString((String)buildTxtContents);
        if (buildNumber2 == null) {
            throw new IllegalStateException(("Invalid build number: " + buildTxtContents).toString());
        }
        BuildNumber buildNumber3 = buildNumber2;
        if (!(buildNumber3.compareTo(lastVersionWithNoBuildNumber) > 0)) {
            boolean bl = false;
            String string = buildTxt + " contains " + buildNumber3 + ", but it can only be present after " + lastVersionWithNoBuildNumber;
            throw new IllegalArgumentException(string.toString());
        }
        return buildNumber3;
    }

    private final Path discoverToolboxBinaryDir() {
        Path path;
        String string = SystemProperties.getUserHome();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUserHome(...)");
        Path path2 = NioPathUtil.toNioPathOrNull((String)string);
        Intrinsics.checkNotNull((Object)path2);
        Path userHome = path2;
        OS oS = OS.CURRENT;
        switch (oS == null ? -1 : WhenMappings.$EnumSwitchMapping$0[oS.ordinal()]) {
            case 1: {
                String string2 = Shell32Util.getKnownFolderPath((Guid.GUID)KnownFolders.FOLDERID_LocalAppData);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getKnownFolderPath(...)");
                Path path3 = NioPathUtil.toNioPathOrNull((String)string2);
                if (path3 == null) {
                    Path path4 = userHome.resolve("AppData");
                    Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"resolve(...)");
                    Path path5 = path4.resolve("Local");
                    path3 = path5;
                    Intrinsics.checkNotNullExpressionValue((Object)path5, (String)"resolve(...)");
                }
                Path localAppData = path3;
                Path path6 = localAppData.resolve("JetBrains");
                Intrinsics.checkNotNullExpressionValue((Object)path6, (String)"resolve(...)");
                Path path7 = path6.resolve("Toolbox");
                Intrinsics.checkNotNullExpressionValue((Object)path7, (String)"resolve(...)");
                Path path8 = path7.resolve("bin");
                path = path8;
                Intrinsics.checkNotNullExpressionValue((Object)path8, (String)"resolve(...)");
                break;
            }
            case 3: {
                Path path9 = this.discoverToolboxAppOnMacOS().resolve("Contents");
                path = path9;
                Intrinsics.checkNotNullExpressionValue((Object)path9, (String)"resolve(...)");
                break;
            }
            case 2: {
                Path path10 = userHome;
                Path path11 = Path.of(".local/share/JetBrains/Toolbox/bin", new String[0]);
                Intrinsics.checkNotNullExpressionValue((Object)path11, (String)"of(...)");
                Path path12 = path10.resolve(path11);
                path = path12;
                Intrinsics.checkNotNullExpressionValue((Object)path12, (String)"resolve(...)");
                break;
            }
            default: {
                throw new IllegalStateException(("Not supported: " + OS.CURRENT).toString());
            }
        }
        return path;
    }

    private final Path discoverToolboxExecutablePath(boolean forDaemon) {
        Path initialPath;
        int n;
        String exeName = forDaemon ? "jetbrainsd" : "jetbrains-toolbox";
        OS oS = OS.CURRENT;
        int n2 = n = oS == null ? -1 : WhenMappings.$EnumSwitchMapping$0[oS.ordinal()];
        if (n == 1) {
            Path path = this.discoverToolboxBinaryDir().resolve(exeName + ".exe");
            v3 = path;
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        } else if (n == 2) {
            Path path = this.discoverToolboxBinaryDir().resolve(exeName);
            v3 = path;
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        } else if (n == 3 && forDaemon) {
            LOG.warn("Can't launch daemon on macOS yet");
            v3 = null;
        } else if (n == 3) {
            v3 = this.discoverToolboxAppOnMacOS();
        } else {
            LOG.debug("Toolbox executable is not available on " + OS.CURRENT);
            v3 = initialPath = null;
        }
        if (initialPath != null) {
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (!Files.exists(initialPath, Arrays.copyOf(linkOptionArray, linkOptionArray.length)) && forDaemon && Registry.Companion.is("station.daemon.process.allow.default.exe.fallback")) {
                LOG.debug("Daemon binary not found, falling back to normal binary");
                initialPath = this.discoverToolboxExecutablePath(false);
            }
        }
        return initialPath;
    }

    private final Path discoverToolboxAppOnMacOS() {
        Path fallbackPath = Path.of("/Applications/JetBrains Toolbox.app", new String[0]);
        try {
            Object object;
            block6: {
                block5: {
                    String string;
                    String[] stringArray = new String[]{"mdfind", "kMDItemCFBundleIdentifier=\"com.jetbrains.toolbox\""};
                    GeneralCommandLine searchForInstallationDirectoryCommand = new GeneralCommandLine(stringArray);
                    ProcessOutput result = ExecUtil.execAndGetOutput((GeneralCommandLine)searchForInstallationDirectoryCommand);
                    List list = result.getStdoutLines();
                    Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getStdoutLines(...)");
                    String stdoutLine = (String)CollectionsKt.firstOrNull((List)list);
                    LOG.debug("Toolbox installation directory: " + stdoutLine);
                    object = stdoutLine;
                    if (object == null) break block5;
                    String it = string = object;
                    boolean bl = false;
                    object = ((CharSequence)it).length() > 0 ? string : null;
                    if (object != null && (object = NioPathUtil.toNioPathOrNull((String)object)) != null) break block6;
                }
                Intrinsics.checkNotNull((Object)fallbackPath);
                object = fallbackPath;
            }
            return object;
        }
        catch (IOException exception) {
            LOG.warn("Failed to discover Toolbox app on macOS. Falling back to the default path", (Throwable)exception);
            Intrinsics.checkNotNull((Object)fallbackPath);
            return fallbackPath;
        }
    }

    private final GeneralCommandLine createLaunchToolboxCommand(boolean forDaemon, String ... args) {
        Object object = this.discoverToolboxExecutablePath(forDaemon);
        if (object == null || (object = ((Object)object.toAbsolutePath()).toString()) == null) {
            return null;
        }
        Object exePath = object;
        OS oS = OS.CURRENT;
        return switch (oS == null ? -1 : WhenMappings.$EnumSwitchMapping$0[oS.ordinal()]) {
            case 1 -> {
                SpreadBuilder var4_4 = new SpreadBuilder(2);
                var4_4.add(exePath);
                var4_4.addSpread((Object)args);
                GeneralCommandLine v2 = new GeneralCommandLine((String[])var4_4.toArray((Object[])new String[var4_4.size()]));
                yield v2;
            }
            case 2 -> {
                SpreadBuilder var4_5 = new SpreadBuilder(2);
                var4_5.add(exePath);
                var4_5.addSpread((Object)args);
                GeneralCommandLine v4 = new GeneralCommandLine((String[])var4_5.toArray((Object[])new String[var4_5.size()]));
                yield v4;
            }
            case 3 -> {
                SpreadBuilder var4_6 = new SpreadBuilder(3);
                var4_6.add((Object)"open");
                var4_6.add(exePath);
                var4_6.addSpread((Object)args);
                GeneralCommandLine v5 = new GeneralCommandLine((String[])var4_6.toArray((Object[])new String[var4_6.size()]));
                yield v5;
            }
            default -> {
                LOG.debug("Toolbox is not possible to launch on " + OS.CURRENT);
                yield null;
            }
        };
    }

    static /* synthetic */ GeneralCommandLine createLaunchToolboxCommand$default(ToolboxDiscovery toolboxDiscovery, boolean bl, String[] stringArray, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return toolboxDiscovery.createLaunchToolboxCommand(bl, stringArray);
    }

    public static final /* synthetic */ Object access$extractDistTo(ToolboxDiscovery $this, Path dist, Path target, Continuation $completion) {
        return $this.extractDistTo(dist, target, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ Object access$killAllToolboxProcesses(ToolboxDiscovery $this, Continuation $completion) {
        return $this.killAllToolboxProcesses((Continuation<? super Boolean>)$completion);
    }

    static {
        boolean $i$f$fileLogger = false;
        boolean $i$f$currentClassLogger = false;
        Class<?> clazz$iv$iv = MethodHandles.lookup().lookupClass();
        Logger logger = Logger.getInstance(clazz$iv$iv);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[OS.values().length];
            try {
                nArray[OS.Windows.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OS.Linux.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OS.macOS.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

