/*
 * Decompiled with CFR 0.152.
 */
package circlet.documents;

import circlet.client.api.DocumentFolder;
import circlet.client.api.DocumentLocation;
import circlet.client.api.DocumentsFolderLocation;
import circlet.client.api.DocumentsLocation;
import circlet.client.api.DocumentsTabsLocation;
import circlet.client.api.FolderIdentifier;
import circlet.client.api.Navigator;
import circlet.client.api.documents.DocumentsSearchHighlights;
import circlet.common.documents.DocumentPermissionChecker;
import circlet.common.documents.DocumentPermissions;
import circlet.common.documents.FolderPermissionChecker;
import circlet.common.documents.FolderPermissions;
import circlet.documents.DocumentsTreeItemKt;
import circlet.documents.SharedFolderPermissions;
import circlet.platform.api.Ref;
import circlet.platform.client.ArenaManagerKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import libraries.coroutines.extra.Lifetime;
import libraries.coroutines.extra.Lifetimed;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import runtime.reactive.CellableKt;
import runtime.reactive.Property;
import runtime.reactive.PropertyKt;
import runtime.reactive.XTrackableLifetimed;
import runtime.routing.Location;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0006%&'()*B\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0019\u001a\u00020\u001aH&J\b\u0010\u001b\u001a\u00020\u001aH&J\u0019\u0010\u001c\u001a\u00020\u001a2\n\u0010\u001d\u001a\u00060\u0005j\u0002`\u001eH&\u00a2\u0006\u0002\u0010\u001fJ\u0013\u0010 \u001a\u00020\u001a2\b\u0010!\u001a\u0004\u0018\u00010\"H\u0096\u0002J\b\u0010#\u001a\u00020$H\u0016R\u0012\u0010\u0004\u001a\u00020\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0018\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\tX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0018\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\tX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000bR\u0018\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\tX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u000bR\u0018\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\tX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u000bR\u0014\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018\u0082\u0001\u0002+,\u00a8\u0006-"}, d2={"Lcirclet/documents/DocumentsTreeItem;", "Llibraries/coroutines/extra/Lifetimed;", "<init>", "()V", "key", "", "getKey", "()Ljava/lang/String;", "name", "Lruntime/reactive/Property;", "getName", "()Lruntime/reactive/Property;", "documentsLocation", "Lcirclet/client/api/DocumentsLocation;", "getDocumentsLocation", "documentsTabsLocation", "Lcirclet/client/api/DocumentsTabsLocation;", "getDocumentsTabsLocation", "location", "Lruntime/routing/Location;", "getLocation", "highlights", "Lcirclet/client/api/documents/DocumentsSearchHighlights;", "getHighlights", "()Lcirclet/client/api/documents/DocumentsSearchHighlights;", "canDrag", "", "canDropInto", "hasParent", "folderId", "Lcirclet/platform/api/TID;", "(Ljava/lang/String;)Z", "equals", "other", "", "hashCode", "", "Document", "ItemsContainer", "ItemsContainerWithFolder", "Folder", "SharedWithMe", "RootFolder", "Lcirclet/documents/DocumentsTreeItem$Document;", "Lcirclet/documents/DocumentsTreeItem$ItemsContainer;", "spaceport-app-state"})
public abstract class DocumentsTreeItem
implements Lifetimed {
    private DocumentsTreeItem() {
    }

    @NotNull
    public abstract String getKey();

    @NotNull
    public abstract Property<String> getName();

    @NotNull
    public abstract Property<DocumentsLocation> getDocumentsLocation();

    @NotNull
    public abstract Property<DocumentsTabsLocation> getDocumentsTabsLocation();

    @NotNull
    public abstract Property<Location> getLocation();

    @Nullable
    public abstract DocumentsSearchHighlights getHighlights();

    public abstract boolean canDrag();

    public abstract boolean canDropInto();

    public abstract boolean hasParent(@NotNull String var1);

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof DocumentsTreeItem)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.getKey(), (Object)((DocumentsTreeItem)other).getKey());
    }

    public int hashCode() {
        return this.getKey().hashCode();
    }

    public /* synthetic */ DocumentsTreeItem(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001BS\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0005\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0005\u0012\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000e\u00a2\u0006\u0004\b\u000f\u0010\u0010J\b\u0010#\u001a\u00020$H\u0016J\b\u0010%\u001a\u00020$H\u0016J\u0019\u0010&\u001a\u00020$2\n\u0010'\u001a\u00060\u001bj\u0002`(H\u0016\u00a2\u0006\u0002\u0010)J\b\u0010*\u001a\u00020\u001bH\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0014R\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0014R\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0014R\u0016\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001a\u001a\u00020\u001b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u001a\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001b0\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u0014R\u001a\u0010 \u001a\b\u0012\u0004\u0012\u00020!0\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\u0014\u00a8\u0006+"}, d2={"Lcirclet/documents/DocumentsTreeItem$Document;", "Lcirclet/documents/DocumentsTreeItem;", "lifetime", "Llibraries/coroutines/extra/Lifetime;", "document", "Lruntime/reactive/Property;", "Lcirclet/client/api/Document;", "documentsLocation", "Lcirclet/client/api/DocumentsLocation;", "documentsTabsLocation", "Lcirclet/client/api/DocumentsTabsLocation;", "permissionsChecker", "Lcirclet/common/documents/DocumentPermissionChecker;", "highlights", "Lcirclet/client/api/documents/DocumentsSearchHighlights;", "<init>", "(Llibraries/coroutines/extra/Lifetime;Lruntime/reactive/Property;Lruntime/reactive/Property;Lruntime/reactive/Property;Lruntime/reactive/Property;Lcirclet/client/api/documents/DocumentsSearchHighlights;)V", "getLifetime", "()Llibraries/coroutines/extra/Lifetime;", "getDocument", "()Lruntime/reactive/Property;", "getDocumentsLocation", "getDocumentsTabsLocation", "getPermissionsChecker", "getHighlights", "()Lcirclet/client/api/documents/DocumentsSearchHighlights;", "key", "", "getKey", "()Ljava/lang/String;", "name", "getName", "location", "Lcirclet/client/api/DocumentLocation;", "getLocation", "canDrag", "", "canDropInto", "hasParent", "folderId", "Lcirclet/platform/api/TID;", "(Ljava/lang/String;)Z", "toString", "spaceport-app-state"})
    public static final class Document
    extends DocumentsTreeItem {
        @NotNull
        private final Lifetime lifetime;
        @NotNull
        private final Property<circlet.client.api.Document> document;
        @NotNull
        private final Property<DocumentsLocation> documentsLocation;
        @NotNull
        private final Property<DocumentsTabsLocation> documentsTabsLocation;
        @NotNull
        private final Property<DocumentPermissionChecker> permissionsChecker;
        @Nullable
        private final DocumentsSearchHighlights highlights;
        @NotNull
        private final Property<String> name;
        @NotNull
        private final Property<DocumentLocation> location;

        public Document(@NotNull Lifetime lifetime, @NotNull Property<circlet.client.api.Document> document2, @NotNull Property<? extends DocumentsLocation> documentsLocation, @NotNull Property<? extends DocumentsTabsLocation> documentsTabsLocation, @NotNull Property<? extends DocumentPermissionChecker> permissionsChecker, @Nullable DocumentsSearchHighlights highlights) {
            Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
            Intrinsics.checkNotNullParameter(document2, (String)"document");
            Intrinsics.checkNotNullParameter(documentsLocation, (String)"documentsLocation");
            Intrinsics.checkNotNullParameter(documentsTabsLocation, (String)"documentsTabsLocation");
            Intrinsics.checkNotNullParameter(permissionsChecker, (String)"permissionsChecker");
            super(null);
            this.lifetime = lifetime;
            this.document = document2;
            this.documentsLocation = documentsLocation;
            this.documentsTabsLocation = documentsTabsLocation;
            this.permissionsChecker = permissionsChecker;
            this.highlights = highlights;
            this.name = CellableKt.derived$default(this, false, arg_0 -> Document.name$lambda$0(this, arg_0), 1, null);
            this.location = CellableKt.derived$default(this, false, arg_0 -> Document.location$lambda$1(this, arg_0), 1, null);
        }

        public /* synthetic */ Document(Lifetime lifetime, Property property2, Property property3, Property property4, Property property5, DocumentsSearchHighlights documentsSearchHighlights, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 0x20) != 0) {
                documentsSearchHighlights = null;
            }
            this(lifetime, property2, property3, property4, property5, documentsSearchHighlights);
        }

        @Override
        @NotNull
        public Lifetime getLifetime() {
            return this.lifetime;
        }

        @NotNull
        public final Property<circlet.client.api.Document> getDocument() {
            return this.document;
        }

        @Override
        @NotNull
        public Property<DocumentsLocation> getDocumentsLocation() {
            return this.documentsLocation;
        }

        @Override
        @NotNull
        public Property<DocumentsTabsLocation> getDocumentsTabsLocation() {
            return this.documentsTabsLocation;
        }

        @NotNull
        public final Property<DocumentPermissionChecker> getPermissionsChecker() {
            return this.permissionsChecker;
        }

        @Override
        @Nullable
        public DocumentsSearchHighlights getHighlights() {
            return this.highlights;
        }

        @Override
        @NotNull
        public String getKey() {
            return "d-" + this.document.getValue().getId();
        }

        @Override
        @NotNull
        public Property<String> getName() {
            return this.name;
        }

        @NotNull
        public Property<DocumentLocation> getLocation() {
            return this.location;
        }

        @Override
        public boolean canDrag() {
            return DocumentPermissions.INSTANCE.canBeMoved(this.permissionsChecker.getValue());
        }

        @Override
        public boolean canDropInto() {
            return false;
        }

        @Override
        public boolean hasParent(@NotNull String folderId) {
            Intrinsics.checkNotNullParameter((Object)folderId, (String)"folderId");
            Ref<DocumentFolder> ref2 = this.document.getValue().getFolderRef();
            return ref2 != null ? DocumentsTreeItemKt.access$hasParent(ref2, folderId) : false;
        }

        @NotNull
        public String toString() {
            return this.getName().getValue();
        }

        private static final String name$lambda$0(Document this$0, XTrackableLifetimed $this$derived) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)$this$derived, (String)"$this$derived");
            return $this$derived.getLive(this$0.document).notEmptyTitle();
        }

        private static final DocumentLocation location$lambda$1(Document this$0, XTrackableLifetimed $this$derived) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)$this$derived, (String)"$this$derived");
            return Navigator.INSTANCE.getDocuments().document($this$derived.getLive(this$0.document));
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001BS\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0005\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0005\u0012\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000e\u00a2\u0006\u0004\b\u000f\u0010\u0010J\b\u0010'\u001a\u00020(H\u0016J\b\u0010)\u001a\u00020(H\u0016J\u0019\u0010*\u001a\u00020(2\n\u0010+\u001a\u00060\u001bj\u0002`,H\u0016\u00a2\u0006\u0002\u0010-J\b\u00103\u001a\u00020\u001bH\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0014R\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0014R\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0014R\u0016\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001a\u001a\u00020\u001b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u001a\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001b0\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u0014R\u0014\u0010 \u001a\u00020!X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u001a\u0010$\u001a\b\u0012\u0004\u0012\u00020%0\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010\u0014R\u001c\u0010.\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010/0\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u0010\u0014R\u001a\u00101\u001a\b\u0012\u0004\u0012\u00020(0\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b2\u0010\u0014\u00a8\u00064"}, d2={"Lcirclet/documents/DocumentsTreeItem$Folder;", "Lcirclet/documents/DocumentsTreeItem$ItemsContainerWithFolder;", "lifetime", "Llibraries/coroutines/extra/Lifetime;", "folder", "Lruntime/reactive/Property;", "Lcirclet/client/api/DocumentFolder;", "documentsLocation", "Lcirclet/client/api/DocumentsLocation;", "documentsTabsLocation", "Lcirclet/client/api/DocumentsTabsLocation;", "permissionsChecker", "Lcirclet/common/documents/FolderPermissionChecker;", "highlights", "Lcirclet/client/api/documents/DocumentsSearchHighlights;", "<init>", "(Llibraries/coroutines/extra/Lifetime;Lruntime/reactive/Property;Lruntime/reactive/Property;Lruntime/reactive/Property;Lruntime/reactive/Property;Lcirclet/client/api/documents/DocumentsSearchHighlights;)V", "getLifetime", "()Llibraries/coroutines/extra/Lifetime;", "getFolder", "()Lruntime/reactive/Property;", "getDocumentsLocation", "getDocumentsTabsLocation", "getPermissionsChecker", "getHighlights", "()Lcirclet/client/api/documents/DocumentsSearchHighlights;", "key", "", "getKey", "()Ljava/lang/String;", "name", "getName", "identifier", "Lcirclet/client/api/FolderIdentifier$Id;", "getIdentifier", "()Lcirclet/client/api/FolderIdentifier$Id;", "location", "Lcirclet/client/api/DocumentsFolderLocation;", "getLocation", "canDrag", "", "canDropInto", "hasParent", "folderId", "Lcirclet/platform/api/TID;", "(Ljava/lang/String;)Z", "description", "Lcirclet/client/api/Document;", "getDescription", "deleted", "getDeleted", "toString", "spaceport-app-state"})
    @SourceDebugExtension(value={"SMAP\nDocumentsTreeItem.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DocumentsTreeItem.kt\ncirclet/documents/DocumentsTreeItem$Folder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,222:1\n1#2:223\n*E\n"})
    public static final class Folder
    extends ItemsContainerWithFolder {
        @NotNull
        private final Lifetime lifetime;
        @NotNull
        private final Property<DocumentFolder> folder;
        @NotNull
        private final Property<DocumentsLocation> documentsLocation;
        @NotNull
        private final Property<DocumentsTabsLocation> documentsTabsLocation;
        @NotNull
        private final Property<FolderPermissionChecker> permissionsChecker;
        @Nullable
        private final DocumentsSearchHighlights highlights;
        @NotNull
        private final Property<String> name;
        @NotNull
        private final FolderIdentifier.Id identifier;
        @NotNull
        private final Property<DocumentsFolderLocation> location;
        @NotNull
        private final Property<circlet.client.api.Document> description;
        @NotNull
        private final Property<Boolean> deleted;

        public Folder(@NotNull Lifetime lifetime, @NotNull Property<DocumentFolder> folder, @NotNull Property<? extends DocumentsLocation> documentsLocation, @NotNull Property<? extends DocumentsTabsLocation> documentsTabsLocation, @NotNull Property<? extends FolderPermissionChecker> permissionsChecker, @Nullable DocumentsSearchHighlights highlights) {
            Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
            Intrinsics.checkNotNullParameter(folder, (String)"folder");
            Intrinsics.checkNotNullParameter(documentsLocation, (String)"documentsLocation");
            Intrinsics.checkNotNullParameter(documentsTabsLocation, (String)"documentsTabsLocation");
            Intrinsics.checkNotNullParameter(permissionsChecker, (String)"permissionsChecker");
            super(null);
            this.lifetime = lifetime;
            this.folder = folder;
            this.documentsLocation = documentsLocation;
            this.documentsTabsLocation = documentsTabsLocation;
            this.permissionsChecker = permissionsChecker;
            this.highlights = highlights;
            this.name = CellableKt.derived$default(this, false, arg_0 -> Folder.name$lambda$0(this, arg_0), 1, null);
            this.identifier = new FolderIdentifier.Id(this.getFolder().getValue().getId());
            this.location = CellableKt.derived$default(this, false, arg_0 -> Folder.location$lambda$1(this, arg_0), 1, null);
            this.description = CellableKt.derived$default(this, false, arg_0 -> Folder.description$lambda$3(this, arg_0), 1, null);
            this.deleted = CellableKt.derived$default(this, false, arg_0 -> Folder.deleted$lambda$4(this, arg_0), 1, null);
        }

        public /* synthetic */ Folder(Lifetime lifetime, Property property2, Property property3, Property property4, Property property5, DocumentsSearchHighlights documentsSearchHighlights, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 0x20) != 0) {
                documentsSearchHighlights = null;
            }
            this(lifetime, property2, property3, property4, property5, documentsSearchHighlights);
        }

        @Override
        @NotNull
        public Lifetime getLifetime() {
            return this.lifetime;
        }

        @Override
        @NotNull
        public Property<DocumentFolder> getFolder() {
            return this.folder;
        }

        @Override
        @NotNull
        public Property<DocumentsLocation> getDocumentsLocation() {
            return this.documentsLocation;
        }

        @Override
        @NotNull
        public Property<DocumentsTabsLocation> getDocumentsTabsLocation() {
            return this.documentsTabsLocation;
        }

        @Override
        @NotNull
        public Property<FolderPermissionChecker> getPermissionsChecker() {
            return this.permissionsChecker;
        }

        @Override
        @Nullable
        public DocumentsSearchHighlights getHighlights() {
            return this.highlights;
        }

        @Override
        @NotNull
        public String getKey() {
            return DocumentsTreeItemKt.treeKey(this.getFolder().getValue());
        }

        @Override
        @NotNull
        public Property<String> getName() {
            return this.name;
        }

        @Override
        @NotNull
        public FolderIdentifier.Id getIdentifier() {
            return this.identifier;
        }

        @Override
        @NotNull
        public Property<DocumentsFolderLocation> getLocation() {
            return this.location;
        }

        @Override
        public boolean canDrag() {
            return FolderPermissions.INSTANCE.canBeMoved(this.getPermissionsChecker().getValue());
        }

        @Override
        public boolean canDropInto() {
            return FolderPermissions.INSTANCE.canMoveTo(this.getPermissionsChecker().getValue());
        }

        @Override
        public boolean hasParent(@NotNull String folderId) {
            Intrinsics.checkNotNullParameter((Object)folderId, (String)"folderId");
            return DocumentsTreeItemKt.access$hasParent(this.getFolder().getValue(), folderId);
        }

        @Override
        @NotNull
        public Property<circlet.client.api.Document> getDescription() {
            return this.description;
        }

        @Override
        @NotNull
        public Property<Boolean> getDeleted() {
            return this.deleted;
        }

        @NotNull
        public String toString() {
            return this.getName().getValue();
        }

        private static final String name$lambda$0(Folder this$0, XTrackableLifetimed $this$derived) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)$this$derived, (String)"$this$derived");
            return $this$derived.getLive(this$0.getFolder()).getName();
        }

        private static final DocumentsFolderLocation location$lambda$1(Folder this$0, XTrackableLifetimed $this$derived) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)$this$derived, (String)"$this$derived");
            return DocumentsLocation.DefaultImpls.folder$default(Navigator.INSTANCE.getDocuments(), $this$derived.getLive(this$0.getFolder()).getAlias(), null, 2, null);
        }

        private static final circlet.client.api.Document description$lambda$3(Folder this$0, XTrackableLifetimed $this$derived) {
            Ref<circlet.client.api.Document> ref2;
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)$this$derived, (String)"$this$derived");
            Ref<circlet.client.api.Document> ref3 = $this$derived.getLive(this$0.getFolder()).getCover();
            if (ref3 != null && (ref3 = ArenaManagerKt.property(ref3)) != null && (ref3 = (circlet.client.api.Document)$this$derived.getLive(ref3)) != null) {
                Ref<circlet.client.api.Document> ref4;
                Ref<circlet.client.api.Document> it = ref4 = ref3;
                boolean bl = false;
                ref2 = !((circlet.client.api.Document)((Object)it)).getArchived() ? ref4 : null;
            } else {
                ref2 = null;
            }
            return ref2;
        }

        private static final boolean deleted$lambda$4(Folder this$0, XTrackableLifetimed $this$derived) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)$this$derived, (String)"$this$derived");
            return $this$derived.getLive(this$0.getFolder()).getArchived();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001B\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0018\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0018\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\bR\u0012\u0010\f\u001a\u00020\rX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00110\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\bR\u0018\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\b\u0082\u0001\u0002\u0016\u0017\u00a8\u0006\u0018"}, d2={"Lcirclet/documents/DocumentsTreeItem$ItemsContainer;", "Lcirclet/documents/DocumentsTreeItem;", "<init>", "()V", "location", "Lruntime/reactive/Property;", "Lcirclet/client/api/DocumentsFolderLocation;", "getLocation", "()Lruntime/reactive/Property;", "permissionsChecker", "Lcirclet/common/documents/FolderPermissionChecker;", "getPermissionsChecker", "identifier", "Lcirclet/client/api/FolderIdentifier;", "getIdentifier", "()Lcirclet/client/api/FolderIdentifier;", "description", "Lcirclet/client/api/Document;", "getDescription", "deleted", "", "getDeleted", "Lcirclet/documents/DocumentsTreeItem$ItemsContainerWithFolder;", "Lcirclet/documents/DocumentsTreeItem$SharedWithMe;", "spaceport-app-state"})
    public static abstract class ItemsContainer
    extends DocumentsTreeItem {
        private ItemsContainer() {
            super(null);
        }

        @NotNull
        public abstract Property<DocumentsFolderLocation> getLocation();

        @NotNull
        public abstract Property<FolderPermissionChecker> getPermissionsChecker();

        @NotNull
        public abstract FolderIdentifier getIdentifier();

        @NotNull
        public abstract Property<circlet.client.api.Document> getDescription();

        @NotNull
        public abstract Property<Boolean> getDeleted();

        public /* synthetic */ ItemsContainer(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001B\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0018\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u0082\u0001\u0002\t\n\u00a8\u0006\u000b"}, d2={"Lcirclet/documents/DocumentsTreeItem$ItemsContainerWithFolder;", "Lcirclet/documents/DocumentsTreeItem$ItemsContainer;", "<init>", "()V", "folder", "Lruntime/reactive/Property;", "Lcirclet/client/api/DocumentFolder;", "getFolder", "()Lruntime/reactive/Property;", "Lcirclet/documents/DocumentsTreeItem$Folder;", "Lcirclet/documents/DocumentsTreeItem$RootFolder;", "spaceport-app-state"})
    public static abstract class ItemsContainerWithFolder
    extends ItemsContainer {
        private ItemsContainerWithFolder() {
            super(null);
        }

        @NotNull
        public abstract Property<DocumentFolder> getFolder();

        public /* synthetic */ ItemsContainerWithFolder(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u0000 92\u00020\u0001:\u00019BG\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0005\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0005\u00a2\u0006\u0004\b\r\u0010\u000eJ\b\u0010'\u001a\u00020(H\u0016J\b\u0010)\u001a\u00020(H\u0016J\u0019\u0010*\u001a\u00020(2\n\u0010+\u001a\u00060\u0017j\u0002`,H\u0016\u00a2\u0006\u0002\u0010-J\b\u00103\u001a\u00020\u0017H\u0016J\u0013\u00104\u001a\u00020(2\b\u00105\u001a\u0004\u0018\u000106H\u0096\u0002J\b\u00107\u001a\u000208H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0012R\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0012R\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0012R\u0014\u0010\u0016\u001a\u00020\u0017X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u001a\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00170\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0012R\u001a\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u0012R\u0014\u0010\u001f\u001a\u00020 X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u0016\u0010#\u001a\u0004\u0018\u00010$X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u001c\u0010.\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010/0\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u0010\u0012R\u001a\u00101\u001a\b\u0012\u0004\u0012\u00020(0\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b2\u0010\u0012\u00a8\u0006:"}, d2={"Lcirclet/documents/DocumentsTreeItem$RootFolder;", "Lcirclet/documents/DocumentsTreeItem$ItemsContainerWithFolder;", "lifetime", "Llibraries/coroutines/extra/Lifetime;", "folder", "Lruntime/reactive/Property;", "Lcirclet/client/api/DocumentFolder;", "documentsLocation", "Lcirclet/client/api/DocumentsLocation;", "documentsTabsLocation", "Lcirclet/client/api/DocumentsTabsLocation;", "permissionsChecker", "Lcirclet/common/documents/FolderPermissionChecker;", "<init>", "(Llibraries/coroutines/extra/Lifetime;Lruntime/reactive/Property;Lruntime/reactive/Property;Lruntime/reactive/Property;Lruntime/reactive/Property;)V", "getLifetime", "()Llibraries/coroutines/extra/Lifetime;", "getFolder", "()Lruntime/reactive/Property;", "getDocumentsLocation", "getDocumentsTabsLocation", "getPermissionsChecker", "key", "", "getKey", "()Ljava/lang/String;", "name", "getName", "location", "Lcirclet/client/api/DocumentsFolderLocation;", "getLocation", "identifier", "Lcirclet/client/api/FolderIdentifier;", "getIdentifier", "()Lcirclet/client/api/FolderIdentifier;", "highlights", "Lcirclet/client/api/documents/DocumentsSearchHighlights;", "getHighlights", "()Lcirclet/client/api/documents/DocumentsSearchHighlights;", "canDrag", "", "canDropInto", "hasParent", "folderId", "Lcirclet/platform/api/TID;", "(Ljava/lang/String;)Z", "description", "Lcirclet/client/api/Document;", "getDescription", "deleted", "getDeleted", "toString", "equals", "other", "", "hashCode", "", "Companion", "spaceport-app-state"})
    @SourceDebugExtension(value={"SMAP\nDocumentsTreeItem.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DocumentsTreeItem.kt\ncirclet/documents/DocumentsTreeItem$RootFolder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,222:1\n1#2:223\n*E\n"})
    public static final class RootFolder
    extends ItemsContainerWithFolder {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final Lifetime lifetime;
        @NotNull
        private final Property<DocumentFolder> folder;
        @NotNull
        private final Property<DocumentsLocation> documentsLocation;
        @NotNull
        private final Property<DocumentsTabsLocation> documentsTabsLocation;
        @NotNull
        private final Property<FolderPermissionChecker> permissionsChecker;
        @NotNull
        private final String key;
        @NotNull
        private final Property<String> name;
        @NotNull
        private final Property<DocumentsFolderLocation> location;
        @NotNull
        private final FolderIdentifier identifier;
        @Nullable
        private final DocumentsSearchHighlights highlights;
        @NotNull
        private final Property<circlet.client.api.Document> description;
        @NotNull
        private final Property<Boolean> deleted;
        @NotNull
        public static final String ID = "root-folder";
        @NotNull
        public static final String NAME_IN_TREE = "Documents";

        public RootFolder(@NotNull Lifetime lifetime, @NotNull Property<DocumentFolder> folder, @NotNull Property<? extends DocumentsLocation> documentsLocation, @NotNull Property<? extends DocumentsTabsLocation> documentsTabsLocation, @NotNull Property<? extends FolderPermissionChecker> permissionsChecker) {
            Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
            Intrinsics.checkNotNullParameter(folder, (String)"folder");
            Intrinsics.checkNotNullParameter(documentsLocation, (String)"documentsLocation");
            Intrinsics.checkNotNullParameter(documentsTabsLocation, (String)"documentsTabsLocation");
            Intrinsics.checkNotNullParameter(permissionsChecker, (String)"permissionsChecker");
            super(null);
            this.lifetime = lifetime;
            this.folder = folder;
            this.documentsLocation = documentsLocation;
            this.documentsTabsLocation = documentsTabsLocation;
            this.permissionsChecker = permissionsChecker;
            this.key = ID;
            this.name = CellableKt.derived$default(this, false, arg_0 -> RootFolder.name$lambda$0(this, arg_0), 1, null);
            this.location = CellableKt.derived$default(this, false, arg_0 -> RootFolder.location$lambda$1(this, arg_0), 1, null);
            this.identifier = FolderIdentifier.Root.INSTANCE;
            this.description = CellableKt.derived$default(this, false, arg_0 -> RootFolder.description$lambda$3(this, arg_0), 1, null);
            this.deleted = PropertyKt.property(false);
        }

        @Override
        @NotNull
        public Lifetime getLifetime() {
            return this.lifetime;
        }

        @Override
        @NotNull
        public Property<DocumentFolder> getFolder() {
            return this.folder;
        }

        @Override
        @NotNull
        public Property<DocumentsLocation> getDocumentsLocation() {
            return this.documentsLocation;
        }

        @Override
        @NotNull
        public Property<DocumentsTabsLocation> getDocumentsTabsLocation() {
            return this.documentsTabsLocation;
        }

        @Override
        @NotNull
        public Property<FolderPermissionChecker> getPermissionsChecker() {
            return this.permissionsChecker;
        }

        @Override
        @NotNull
        public String getKey() {
            return this.key;
        }

        @Override
        @NotNull
        public Property<String> getName() {
            return this.name;
        }

        @Override
        @NotNull
        public Property<DocumentsFolderLocation> getLocation() {
            return this.location;
        }

        @Override
        @NotNull
        public FolderIdentifier getIdentifier() {
            return this.identifier;
        }

        @Override
        @Nullable
        public DocumentsSearchHighlights getHighlights() {
            return this.highlights;
        }

        @Override
        public boolean canDrag() {
            return false;
        }

        @Override
        public boolean canDropInto() {
            return FolderPermissions.INSTANCE.canMoveTo(this.getPermissionsChecker().getValue());
        }

        @Override
        public boolean hasParent(@NotNull String folderId) {
            Intrinsics.checkNotNullParameter((Object)folderId, (String)"folderId");
            return false;
        }

        @Override
        @NotNull
        public Property<circlet.client.api.Document> getDescription() {
            return this.description;
        }

        @Override
        @NotNull
        public Property<Boolean> getDeleted() {
            return this.deleted;
        }

        @NotNull
        public String toString() {
            return this.getName().getValue();
        }

        @Override
        public boolean equals(@Nullable Object other) {
            return other instanceof RootFolder && Intrinsics.areEqual((Object)((RootFolder)other).getKey(), (Object)this.getKey());
        }

        @Override
        public int hashCode() {
            return this.getKey().hashCode();
        }

        private static final String name$lambda$0(RootFolder this$0, XTrackableLifetimed $this$derived) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)$this$derived, (String)"$this$derived");
            return $this$derived.getLive(this$0.getFolder()).getName();
        }

        private static final DocumentsFolderLocation location$lambda$1(RootFolder this$0, XTrackableLifetimed $this$derived) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)$this$derived, (String)"$this$derived");
            return $this$derived.getLive(this$0.getDocumentsTabsLocation()).getFolders();
        }

        private static final circlet.client.api.Document description$lambda$3(RootFolder this$0, XTrackableLifetimed $this$derived) {
            Ref<circlet.client.api.Document> ref2;
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)$this$derived, (String)"$this$derived");
            Ref<circlet.client.api.Document> ref3 = $this$derived.getLive(this$0.getFolder()).getCover();
            if (ref3 != null && (ref3 = ArenaManagerKt.property(ref3)) != null && (ref3 = (circlet.client.api.Document)$this$derived.getLive(ref3)) != null) {
                Ref<circlet.client.api.Document> ref4;
                Ref<circlet.client.api.Document> it = ref4 = ref3;
                boolean bl = false;
                ref2 = !((circlet.client.api.Document)((Object)it)).getArchived() ? ref4 : null;
            } else {
                ref2 = null;
            }
            return ref2;
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcirclet/documents/DocumentsTreeItem$RootFolder$Companion;", "", "<init>", "()V", "ID", "", "NAME_IN_TREE", "spaceport-app-state"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0001\n\u0002\b\u0006\u0018\u0000 12\u00020\u0001:\u00011B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010$\u001a\u00020%H\u0016J\b\u0010&\u001a\u00020%H\u0016J\u0019\u0010'\u001a\u00020%2\n\u0010(\u001a\u00060\u0011j\u0002`)H\u0016\u00a2\u0006\u0002\u0010*J\b\u00100\u001a\u00020\u0011H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR\u0014\u0010\u0010\u001a\u00020\u0011X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00110\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u000eR\u001a\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u000eR\u001a\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u000eR\u0014\u0010\u001c\u001a\u00020\u001dX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0016\u0010 \u001a\u0004\u0018\u00010!X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u001c\u0010+\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010,0\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010\u000eR\u001a\u0010.\u001a\b\u0012\u0004\u0012\u00020%0\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u0010\u000e\u00a8\u00062"}, d2={"Lcirclet/documents/DocumentsTreeItem$SharedWithMe;", "Lcirclet/documents/DocumentsTreeItem$ItemsContainer;", "lifetime", "Llibraries/coroutines/extra/Lifetime;", "documentsLocation", "Lruntime/reactive/Property;", "Lcirclet/client/api/DocumentsLocation;", "documentsTabsLocation", "Lcirclet/client/api/DocumentsTabsLocation;", "<init>", "(Llibraries/coroutines/extra/Lifetime;Lruntime/reactive/Property;Lruntime/reactive/Property;)V", "getLifetime", "()Llibraries/coroutines/extra/Lifetime;", "getDocumentsLocation", "()Lruntime/reactive/Property;", "getDocumentsTabsLocation", "key", "", "getKey", "()Ljava/lang/String;", "name", "getName", "location", "Lcirclet/client/api/DocumentsFolderLocation;", "getLocation", "permissionsChecker", "Lcirclet/common/documents/FolderPermissionChecker;", "getPermissionsChecker", "identifier", "Lcirclet/client/api/FolderIdentifier;", "getIdentifier", "()Lcirclet/client/api/FolderIdentifier;", "highlights", "Lcirclet/client/api/documents/DocumentsSearchHighlights;", "getHighlights", "()Lcirclet/client/api/documents/DocumentsSearchHighlights;", "canDrag", "", "canDropInto", "hasParent", "folderId", "Lcirclet/platform/api/TID;", "(Ljava/lang/String;)Z", "description", "", "getDescription", "deleted", "getDeleted", "toString", "Companion", "spaceport-app-state"})
    public static final class SharedWithMe
    extends ItemsContainer {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final Lifetime lifetime;
        @NotNull
        private final Property<DocumentsLocation> documentsLocation;
        @NotNull
        private final Property<DocumentsTabsLocation> documentsTabsLocation;
        @NotNull
        private final String key;
        @NotNull
        private final Property<String> name;
        @NotNull
        private final Property<DocumentsFolderLocation> location;
        @NotNull
        private final Property<FolderPermissionChecker> permissionsChecker;
        @NotNull
        private final FolderIdentifier identifier;
        @Nullable
        private final DocumentsSearchHighlights highlights;
        @NotNull
        private final Property description;
        @NotNull
        private final Property<Boolean> deleted;
        @NotNull
        public static final String ID = "shared-with-me";
        @NotNull
        public static final String NAME = "Shared with me";

        public SharedWithMe(@NotNull Lifetime lifetime, @NotNull Property<? extends DocumentsLocation> documentsLocation, @NotNull Property<? extends DocumentsTabsLocation> documentsTabsLocation) {
            Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
            Intrinsics.checkNotNullParameter(documentsLocation, (String)"documentsLocation");
            Intrinsics.checkNotNullParameter(documentsTabsLocation, (String)"documentsTabsLocation");
            super(null);
            this.lifetime = lifetime;
            this.documentsLocation = documentsLocation;
            this.documentsTabsLocation = documentsTabsLocation;
            this.key = ID;
            this.name = PropertyKt.property(NAME);
            this.location = CellableKt.derived$default(this, false, arg_0 -> SharedWithMe.location$lambda$0(this, arg_0), 1, null);
            this.permissionsChecker = PropertyKt.property(SharedFolderPermissions.INSTANCE);
            this.identifier = FolderIdentifier.SharedWithMe.INSTANCE;
            this.description = PropertyKt.property(null);
            this.deleted = PropertyKt.property(false);
        }

        @Override
        @NotNull
        public Lifetime getLifetime() {
            return this.lifetime;
        }

        @Override
        @NotNull
        public Property<DocumentsLocation> getDocumentsLocation() {
            return this.documentsLocation;
        }

        @Override
        @NotNull
        public Property<DocumentsTabsLocation> getDocumentsTabsLocation() {
            return this.documentsTabsLocation;
        }

        @Override
        @NotNull
        public String getKey() {
            return this.key;
        }

        @Override
        @NotNull
        public Property<String> getName() {
            return this.name;
        }

        @Override
        @NotNull
        public Property<DocumentsFolderLocation> getLocation() {
            return this.location;
        }

        @Override
        @NotNull
        public Property<FolderPermissionChecker> getPermissionsChecker() {
            return this.permissionsChecker;
        }

        @Override
        @NotNull
        public FolderIdentifier getIdentifier() {
            return this.identifier;
        }

        @Override
        @Nullable
        public DocumentsSearchHighlights getHighlights() {
            return this.highlights;
        }

        @Override
        public boolean canDrag() {
            return false;
        }

        @Override
        public boolean canDropInto() {
            return false;
        }

        @Override
        public boolean hasParent(@NotNull String folderId) {
            Intrinsics.checkNotNullParameter((Object)folderId, (String)"folderId");
            return false;
        }

        @NotNull
        public Property getDescription() {
            return this.description;
        }

        @Override
        @NotNull
        public Property<Boolean> getDeleted() {
            return this.deleted;
        }

        @NotNull
        public String toString() {
            return ID;
        }

        private static final DocumentsFolderLocation location$lambda$0(SharedWithMe this$0, XTrackableLifetimed $this$derived) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)$this$derived, (String)"$this$derived");
            return $this$derived.getLive(this$0.getDocumentsTabsLocation()).getFolders().getSharedWithMe();
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcirclet/documents/DocumentsTreeItem$SharedWithMe$Companion;", "", "<init>", "()V", "ID", "", "NAME", "spaceport-app-state"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

