/*
 * Decompiled with CFR 0.152.
 */
package circlet.platform.api;

import circlet.platform.api.WeekDayTimeInterval;
import circlet.platform.api.Weekday;
import circlet.platform.api.WeekdayFormat;
import circlet.platform.api.Workday;
import java.time.DayOfWeek;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import runtime.Math;
import runtime.date.TimeInterval;
import runtime.date.TimeOfDay;
import runtime.date.TimeOfDayKt;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000P\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u000b\n\u0002\u0010$\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a\u0012\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u001a\n\u0010\u0005\u001a\u00020\u0002*\u00020\u0006\u001a\f\u0010\u0005\u001a\u0004\u0018\u00010\u0002*\u00020\u0001\u001a\u0013\u0010\u0005\u001a\u00020\u0002*\u00060\bj\u0002`\u0007\u00a2\u0006\u0002\u0010\t\u001a\u000e\u0010\n\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0002\u001a\u0010\u0010\u000b\u001a\u0004\u0018\u00010\u00022\u0006\u0010\f\u001a\u00020\u0001\u001a-\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u000e0#2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020&0%2\u0006\u0010'\u001a\u00020\u000e\u00a2\u0006\u0002\u0010(\u001a\u0014\u0010)\u001a\u0004\u0018\u00010\u0001*\u00020\u00132\u0006\u0010*\u001a\u00020\u0001\"\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0017\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0017\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00060\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0017\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00020\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0019\"\u0011\u0010\u001c\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0010\"\u0017\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u0015\"\u0017\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00060\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u0019\u00a8\u0006+"}, d2={"title", "", "Lcirclet/platform/api/Weekday;", "format", "Lcirclet/platform/api/WeekdayFormat;", "weekday", "", "Lkotlinx/datetime/DayOfWeek;", "Ljava/time/DayOfWeek;", "(Ljava/time/DayOfWeek;)Lcirclet/platform/api/Weekday;", "weekdayToICal", "iCalToWeekday", "it", "DefaultWorkingHoursInterval", "Lruntime/date/TimeInterval;", "getDefaultWorkingHoursInterval", "()Lruntime/date/TimeInterval;", "DefaultWorkingWeekHours", "", "Lcirclet/platform/api/WeekDayTimeInterval;", "getDefaultWorkingWeekHours", "()Ljava/util/List;", "DefaultWorkingDays", "", "getDefaultWorkingDays", "()Ljava/util/Set;", "DefaultWeekends", "getDefaultWeekends", "DefaultNotificationHoursInterval", "getDefaultNotificationHoursInterval", "DefaultNotificationWeekHours", "getDefaultNotificationWeekHours", "DefaultNotificationDays", "getDefaultNotificationDays", "convertWorkingDaysToHours", "", "days", "", "Lcirclet/platform/api/Workday;", "timeInterval", "([Lcirclet/platform/api/Workday;Lruntime/date/TimeInterval;)Ljava/util/Map;", "validate", "intervalName", "platform-api"})
@SourceDebugExtension(value={"SMAP\nWorkingDays.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WorkingDays.kt\ncirclet/platform/api/WorkingDaysKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,144:1\n1#2:145\n1#2:159\n3829#3:146\n4344#3,2:147\n1611#4,9:149\n1863#4:158\n1864#4:160\n1620#4:161\n1187#4,2:162\n1261#4,4:164\n774#4:168\n865#4,2:169\n1557#4:171\n1628#4,3:172\n774#4:175\n865#4,2:176\n1557#4:178\n1628#4,3:179\n*S KotlinDebug\n*F\n+ 1 WorkingDays.kt\ncirclet/platform/api/WorkingDaysKt\n*L\n112#1:159\n111#1:146\n111#1:147,2\n112#1:149,9\n112#1:158\n112#1:160\n112#1:161\n123#1:162,2\n123#1:164,4\n94#1:168\n94#1:169,2\n94#1:171\n94#1:172,3\n107#1:175\n107#1:176,2\n107#1:178\n107#1:179,3\n*E\n"})
public final class WorkingDaysKt {
    @NotNull
    private static final TimeInterval DefaultWorkingHoursInterval;
    @NotNull
    private static final List<WeekDayTimeInterval> DefaultWorkingWeekHours;
    @NotNull
    private static final Set<Integer> DefaultWorkingDays;
    @NotNull
    private static final Set<Weekday> DefaultWeekends;
    @NotNull
    private static final TimeInterval DefaultNotificationHoursInterval;
    @NotNull
    private static final List<WeekDayTimeInterval> DefaultNotificationWeekHours;
    @NotNull
    private static final Set<Integer> DefaultNotificationDays;

    @NotNull
    public static final String title(@NotNull Weekday $this$title, @NotNull WeekdayFormat format) {
        String string;
        Intrinsics.checkNotNullParameter((Object)((Object)$this$title), (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)((Object)format), (String)"format");
        switch (WhenMappings.$EnumSwitchMapping$0[format.ordinal()]) {
            case 1: {
                string = $this$title.getTitle();
                break;
            }
            case 2: {
                String string2 = $this$title.getTitle().substring(0, 3);
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                break;
            }
            case 3: {
                string = WorkingDaysKt.weekdayToICal($this$title);
                break;
            }
            case 4: {
                string = String.valueOf(StringsKt.first((CharSequence)$this$title.getTitle()));
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return string;
    }

    @NotNull
    public static final Weekday weekday(int $this$weekday) {
        Weekday weekday;
        switch (Math.INSTANCE.floorMod($this$weekday, 7)) {
            case 0: {
                weekday = Weekday.SUNDAY;
                break;
            }
            case 1: {
                weekday = Weekday.MONDAY;
                break;
            }
            case 2: {
                weekday = Weekday.TUESDAY;
                break;
            }
            case 3: {
                weekday = Weekday.WEDNESDAY;
                break;
            }
            case 4: {
                weekday = Weekday.THURSDAY;
                break;
            }
            case 5: {
                weekday = Weekday.FRIDAY;
                break;
            }
            case 6: {
                weekday = Weekday.SATURDAY;
                break;
            }
            default: {
                throw new IllegalStateException(("can't calculate a weekday number " + $this$weekday).toString());
            }
        }
        return weekday;
    }

    @Nullable
    public static final Weekday weekday(@NotNull String $this$weekday) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)$this$weekday, (String)"<this>");
            Iterable iterable = (Iterable)Weekday.getEntries();
            for (Object t : iterable) {
                Weekday it = (Weekday)((Object)t);
                boolean bl = false;
                if (!StringsKt.equals((String)it.getTitle(), (String)$this$weekday, (boolean)true)) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    @NotNull
    public static final Weekday weekday(@NotNull DayOfWeek $this$weekday) {
        Intrinsics.checkNotNullParameter((Object)$this$weekday, (String)"<this>");
        return Weekday.valueOf($this$weekday.name());
    }

    @NotNull
    public static final String weekdayToICal(@NotNull Weekday weekday) {
        String string;
        Intrinsics.checkNotNullParameter((Object)((Object)weekday), (String)"weekday");
        switch (WhenMappings.$EnumSwitchMapping$1[weekday.ordinal()]) {
            case 1: {
                string = "SU";
                break;
            }
            case 2: {
                string = "MO";
                break;
            }
            case 3: {
                string = "TU";
                break;
            }
            case 4: {
                string = "WE";
                break;
            }
            case 5: {
                string = "TH";
                break;
            }
            case 6: {
                string = "FR";
                break;
            }
            case 7: {
                string = "SA";
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return string;
    }

    @Nullable
    public static final Weekday iCalToWeekday(@NotNull String it) {
        Weekday weekday;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        switch (it) {
            case "SU": {
                weekday = Weekday.SUNDAY;
                break;
            }
            case "MO": {
                weekday = Weekday.MONDAY;
                break;
            }
            case "TU": {
                weekday = Weekday.TUESDAY;
                break;
            }
            case "WE": {
                weekday = Weekday.WEDNESDAY;
                break;
            }
            case "TH": {
                weekday = Weekday.THURSDAY;
                break;
            }
            case "FR": {
                weekday = Weekday.FRIDAY;
                break;
            }
            case "SA": {
                weekday = Weekday.SATURDAY;
                break;
            }
            default: {
                weekday = null;
            }
        }
        return weekday;
    }

    @NotNull
    public static final TimeInterval getDefaultWorkingHoursInterval() {
        return DefaultWorkingHoursInterval;
    }

    @NotNull
    public static final List<WeekDayTimeInterval> getDefaultWorkingWeekHours() {
        return DefaultWorkingWeekHours;
    }

    @NotNull
    public static final Set<Integer> getDefaultWorkingDays() {
        return DefaultWorkingDays;
    }

    @NotNull
    public static final Set<Weekday> getDefaultWeekends() {
        return DefaultWeekends;
    }

    @NotNull
    public static final TimeInterval getDefaultNotificationHoursInterval() {
        return DefaultNotificationHoursInterval;
    }

    @NotNull
    public static final List<WeekDayTimeInterval> getDefaultNotificationWeekHours() {
        return DefaultNotificationWeekHours;
    }

    @NotNull
    public static final Set<Integer> getDefaultNotificationDays() {
        return DefaultNotificationDays;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Map<Integer, TimeInterval> convertWorkingDaysToHours(@NotNull Workday[] days, @NotNull TimeInterval timeInterval) {
        void $this$associateTo$iv$iv;
        void $this$mapNotNullTo$iv$iv;
        Iterator element$iv$iv2;
        Iterable $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)days, (String)"days");
        Intrinsics.checkNotNullParameter((Object)timeInterval, (String)"timeInterval");
        Workday[] $this$filter$iv = days;
        boolean $i$f$filter = false;
        Workday[] workdayArray = $this$filter$iv;
        Iterable<Pair> destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Iterator element$iv$iv2 : $this$filterTo$iv$iv) {
            void it = element$iv$iv2;
            boolean bl = false;
            if (!it.getWorking()) continue;
            destination$iv$iv.add(element$iv$iv2);
        }
        Iterable $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$mapNotNull = false;
        $this$filterTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        element$iv$iv2 = $this$forEach$iv$iv$iv.iterator();
        while (element$iv$iv2.hasNext()) {
            Pair pair;
            Object element$iv$iv$iv;
            Object element$iv$iv3 = element$iv$iv$iv = element$iv$iv2.next();
            boolean bl = false;
            Workday it = (Workday)element$iv$iv3;
            boolean bl2 = false;
            Weekday weekday = WorkingDaysKt.weekday(it.getWeekday());
            if (weekday == null) {
                pair = null;
            } else {
                int day = weekday.ordinal();
                TimeOfDay since = timeInterval.getSince();
                int hoursTill = since.getHours() + it.getHours() + 1;
                TimeOfDay till = hoursTill > 23 ? new TimeOfDay(23, 59, null, 4, null) : new TimeOfDay(hoursTill, 0, null, 6, null);
                pair = TuplesKt.to((Object)day, (Object)new TimeInterval(since, till));
            }
            if (pair == null) continue;
            Pair it$iv$iv = pair;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Iterable $this$associate$iv = (List)destination$iv$iv;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        destination$iv$iv = $this$associate$iv;
        Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Iterator element$iv$iv2 : $this$associateTo$iv$iv) {
            Map map2 = destination$iv$iv2;
            Pair it = (Pair)element$iv$iv2;
            boolean bl = false;
            Pair pair = TuplesKt.to((Object)it.getFirst(), (Object)it.getSecond());
            map2.put(pair.getFirst(), pair.getSecond());
        }
        return destination$iv$iv2;
    }

    @Nullable
    public static final String validate(@NotNull WeekDayTimeInterval $this$validate, @NotNull String intervalName) {
        Intrinsics.checkNotNullParameter((Object)$this$validate, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)intervalName, (String)"intervalName");
        if (!$this$validate.getChecked()) {
            return null;
        }
        String string = TimeOfDayKt.validate($this$validate.getInterval().getSince());
        if (string != null) {
            String it = string;
            boolean bl = false;
            return intervalName + " interval start " + $this$validate.getInterval().getSince() + " is invalid: " + it;
        }
        string = TimeOfDayKt.validate($this$validate.getInterval().getTill());
        if (string != null) {
            String it = string;
            boolean bl = false;
            return intervalName + " interval end " + $this$validate.getInterval().getTill() + " is invalid: " + it;
        }
        return $this$validate.getInterval().getSince().compareTo($this$validate.getInterval().getTill()) >= 0 ? intervalName + " period " + TimeOfDayKt.format($this$validate.getInterval()) + " is invalid" : null;
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var3_3;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        boolean bl;
        WeekDayTimeInterval it;
        Weekday[] $this$filterTo$iv$iv;
        DefaultWorkingHoursInterval = new TimeInterval(new TimeOfDay(9, 0, null, 6, null), new TimeOfDay(18, 0, null, 6, null));
        Object[] objectArray = new WeekDayTimeInterval[]{new WeekDayTimeInterval(Weekday.MONDAY.ordinal(), true, DefaultWorkingHoursInterval), new WeekDayTimeInterval(Weekday.TUESDAY.ordinal(), true, DefaultWorkingHoursInterval), new WeekDayTimeInterval(Weekday.WEDNESDAY.ordinal(), true, DefaultWorkingHoursInterval), new WeekDayTimeInterval(Weekday.THURSDAY.ordinal(), true, DefaultWorkingHoursInterval), new WeekDayTimeInterval(Weekday.FRIDAY.ordinal(), true, DefaultWorkingHoursInterval), new WeekDayTimeInterval(Weekday.SATURDAY.ordinal(), false, DefaultWorkingHoursInterval), new WeekDayTimeInterval(Weekday.SUNDAY.ordinal(), false, DefaultWorkingHoursInterval)};
        DefaultWorkingWeekHours = CollectionsKt.listOf((Object[])objectArray);
        Iterable $this$filter$iv = DefaultWorkingWeekHours;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object t : $this$filterTo$iv$iv) {
            it = (WeekDayTimeInterval)t;
            bl = false;
            if (!it.getChecked()) continue;
            destination$iv$iv.add(t);
        }
        Object $this$map$iv = (Weekday[])((List)destination$iv$iv);
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object t : $this$mapTo$iv$iv) {
            it = (WeekDayTimeInterval)t;
            collection = destination$iv$iv;
            bl = false;
            collection.add(it.getDay());
        }
        DefaultWorkingDays = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        $this$map$iv = new Weekday[]{Weekday.SATURDAY, Weekday.SUNDAY};
        DefaultWeekends = SetsKt.setOf((Object[])$this$map$iv);
        DefaultNotificationHoursInterval = new TimeInterval(new TimeOfDay(8, 0, null, 6, null), new TimeOfDay(20, 0, null, 6, null));
        $this$map$iv = new WeekDayTimeInterval[]{new WeekDayTimeInterval(Weekday.MONDAY.ordinal(), true, DefaultNotificationHoursInterval), new WeekDayTimeInterval(Weekday.TUESDAY.ordinal(), true, DefaultNotificationHoursInterval), new WeekDayTimeInterval(Weekday.WEDNESDAY.ordinal(), true, DefaultNotificationHoursInterval), new WeekDayTimeInterval(Weekday.THURSDAY.ordinal(), true, DefaultNotificationHoursInterval), new WeekDayTimeInterval(Weekday.FRIDAY.ordinal(), true, DefaultNotificationHoursInterval), new WeekDayTimeInterval(Weekday.SATURDAY.ordinal(), true, DefaultNotificationHoursInterval), new WeekDayTimeInterval(Weekday.SUNDAY.ordinal(), true, DefaultNotificationHoursInterval)};
        DefaultNotificationWeekHours = CollectionsKt.listOf((Object[])$this$map$iv);
        $this$filter$iv = DefaultNotificationWeekHours;
        $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        for (Object t : $this$filterTo$iv$iv) {
            it = (WeekDayTimeInterval)t;
            bl = false;
            if (!it.getChecked()) continue;
            destination$iv$iv.add(t);
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object t : $this$mapTo$iv$iv) {
            it = (WeekDayTimeInterval)t;
            collection = destination$iv$iv;
            bl = false;
            collection.add(it.getDay());
        }
        DefaultNotificationDays = CollectionsKt.toSet((Iterable)((List)var3_3));
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[WeekdayFormat.values().length];
            try {
                nArray[WeekdayFormat.LONG.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WeekdayFormat.MEDIUM.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WeekdayFormat.ICAL.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WeekdayFormat.SHORT.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[Weekday.values().length];
            try {
                nArray[Weekday.SUNDAY.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Weekday.MONDAY.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Weekday.TUESDAY.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Weekday.WEDNESDAY.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Weekday.THURSDAY.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Weekday.FRIDAY.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Weekday.SATURDAY.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

