/*
 * Decompiled with CFR 0.152.
 */
package com.dd.plist;

import com.dd.plist.NSArray;
import com.dd.plist.NSDictionary;
import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Objects;

public final class ASCIIPropertyListWriter {
    private ASCIIPropertyListWriter() {
    }

    public static void write(NSDictionary root, File out) throws IOException {
        File parent = out.getParentFile();
        if (!parent.exists() && !parent.mkdirs()) {
            throw new IOException("The output directory does not exist and could not be created.");
        }
        ASCIIPropertyListWriter.write(root, out.toPath());
    }

    public static void write(NSDictionary root, Path path) throws IOException {
        try (OutputStreamWriter w2 = new OutputStreamWriter(Files.newOutputStream(path, new OpenOption[0]), StandardCharsets.US_ASCII);){
            w2.write(root.toASCIIPropertyList());
        }
    }

    public static void write(NSArray root, File out) throws IOException {
        Objects.requireNonNull(root, "The root object is null.");
        File parent = out.getParentFile();
        if (!parent.exists() && !parent.mkdirs()) {
            throw new IOException("The output directory does not exist and could not be created.");
        }
        ASCIIPropertyListWriter.write(root, out.toPath());
    }

    public static void write(NSArray root, Path path) throws IOException {
        try (OutputStreamWriter w2 = new OutputStreamWriter(Files.newOutputStream(path, new OpenOption[0]), StandardCharsets.US_ASCII);){
            w2.write(root.toASCIIPropertyList());
        }
    }

    public static void writeGnuStep(NSDictionary root, File out) throws IOException {
        Objects.requireNonNull(root, "The root object is null.");
        File parent = out.getParentFile();
        if (!parent.exists() && !parent.mkdirs()) {
            throw new IOException("The output directory does not exist and could not be created.");
        }
        ASCIIPropertyListWriter.writeGnuStep(root, out.toPath());
    }

    public static void writeGnuStep(NSDictionary root, Path path) throws IOException {
        try (OutputStreamWriter w2 = new OutputStreamWriter(Files.newOutputStream(path, new OpenOption[0]), StandardCharsets.US_ASCII);){
            w2.write(root.toGnuStepASCIIPropertyList());
        }
    }

    public static void writeGnuStep(NSArray root, File out) throws IOException {
        Objects.requireNonNull(root, "The root object is null.");
        File parent = out.getParentFile();
        if (!parent.exists() && !parent.mkdirs()) {
            throw new IOException("The output directory does not exist and could not be created.");
        }
        ASCIIPropertyListWriter.writeGnuStep(root, out.toPath());
    }

    public static void writeGnuStep(NSArray root, Path path) throws IOException {
        try (OutputStreamWriter w2 = new OutputStreamWriter(Files.newOutputStream(path, new OpenOption[0]), StandardCharsets.US_ASCII);){
            w2.write(root.toGnuStepASCIIPropertyList());
        }
    }
}

