/*
 * Decompiled with CFR 0.152.
 */
package com.dd.plist;

import com.dd.plist.BinaryPropertyListWriter;
import com.dd.plist.NSArray;
import com.dd.plist.NSData;
import com.dd.plist.NSDate;
import com.dd.plist.NSNumber;
import com.dd.plist.NSObject;
import com.dd.plist.NSString;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class NSDictionary
extends NSObject
implements Map<String, NSObject> {
    private final HashMap<String, NSObject> dict = new LinkedHashMap<String, NSObject>();

    public HashMap<String, NSObject> getHashMap() {
        return this.dict;
    }

    public NSObject objectForKey(String key) {
        return this.dict.get(key);
    }

    @Override
    public int size() {
        return this.dict.size();
    }

    @Override
    public boolean isEmpty() {
        return this.dict.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.dict.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        if (value == null) {
            return false;
        }
        NSObject wrap = NSObject.fromJavaObject(value);
        return this.dict.containsValue(wrap);
    }

    @Override
    public NSObject get(Object key) {
        return this.dict.get(key);
    }

    @Override
    public void putAll(Map<? extends String, ? extends NSObject> values) {
        Iterator<Map.Entry<? extends String, ? extends NSObject>> iterator2 = values.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<? extends String, ? extends NSObject> object;
            Map.Entry<? extends String, ? extends NSObject> entry = object = iterator2.next();
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public NSObject put(String key, NSObject obj) {
        if (key == null) {
            return null;
        }
        if (obj == null) {
            return this.dict.get(key);
        }
        return this.dict.put(key, obj);
    }

    @Override
    public NSObject put(String key, Object obj) {
        return this.put(key, NSObject.fromJavaObject(obj));
    }

    public NSObject remove(String key) {
        return this.dict.remove(key);
    }

    @Override
    public NSObject remove(Object key) {
        return this.dict.remove(key);
    }

    @Override
    public void clear() {
        this.dict.clear();
    }

    @Override
    public Set<String> keySet() {
        return this.dict.keySet();
    }

    @Override
    public Collection<NSObject> values() {
        return this.dict.values();
    }

    @Override
    public Set<Map.Entry<String, NSObject>> entrySet() {
        return this.dict.entrySet();
    }

    public boolean containsKey(String key) {
        return this.dict.containsKey(key);
    }

    public boolean containsValue(NSObject val) {
        return val != null && this.dict.containsValue(val);
    }

    public boolean containsValue(String val) {
        for (NSObject o2 : this.dict.values()) {
            NSString str;
            if (!o2.getClass().equals(NSString.class) || !(str = (NSString)o2).getContent().equals(val)) continue;
            return true;
        }
        return false;
    }

    public boolean containsValue(long val) {
        for (NSObject o2 : this.dict.values()) {
            NSNumber num;
            if (!o2.getClass().equals(NSNumber.class) || !(num = (NSNumber)o2).isInteger() || (long)num.intValue() != val) continue;
            return true;
        }
        return false;
    }

    public boolean containsValue(double val) {
        for (NSObject o2 : this.dict.values()) {
            NSNumber num;
            if (!o2.getClass().equals(NSNumber.class) || !(num = (NSNumber)o2).isReal() || num.doubleValue() != val) continue;
            return true;
        }
        return false;
    }

    public boolean containsValue(boolean val) {
        for (NSObject o2 : this.dict.values()) {
            NSNumber num;
            if (!o2.getClass().equals(NSNumber.class) || !(num = (NSNumber)o2).isBoolean() || num.boolValue() != val) continue;
            return true;
        }
        return false;
    }

    public boolean containsValue(Date val) {
        for (NSObject o2 : this.dict.values()) {
            NSDate dat;
            if (!o2.getClass().equals(NSDate.class) || !(dat = (NSDate)o2).getDate().equals(val)) continue;
            return true;
        }
        return false;
    }

    public boolean containsValue(byte[] val) {
        for (NSObject o2 : this.dict.values()) {
            NSData dat;
            if (!o2.getClass().equals(NSData.class) || !Arrays.equals((dat = (NSData)o2).bytes(), val)) continue;
            return true;
        }
        return false;
    }

    public int count() {
        return this.dict.size();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        return obj.getClass().equals(this.getClass()) && ((NSDictionary)obj).dict.equals(this.dict);
    }

    public String[] allKeys() {
        return this.dict.keySet().toArray(new String[this.count()]);
    }

    @Override
    public int hashCode() {
        int hash = 7;
        hash = 83 * hash + this.dict.hashCode();
        return hash;
    }

    @Override
    public NSDictionary clone() {
        NSDictionary clone = new NSDictionary();
        for (Map.Entry<String, NSObject> entry : this.dict.entrySet()) {
            clone.dict.put(entry.getKey(), entry.getValue() != null ? entry.getValue().clone() : null);
        }
        return clone;
    }

    @Override
    public Object toJavaObject() {
        HashMap<String, Object> clonedMap = new HashMap<String, Object>(this.dict.size());
        for (String key : this.dict.keySet()) {
            clonedMap.put(key, this.dict.get(key).toJavaObject());
        }
        return clonedMap;
    }

    @Override
    public int compareTo(NSObject o2) {
        Objects.requireNonNull(o2);
        if (o2 == this) {
            return 0;
        }
        if (o2 instanceof NSDictionary) {
            long uniqueForOther;
            NSDictionary other = (NSDictionary)o2;
            long uniqueForMe = this.dict.keySet().stream().filter(e2 -> !other.dict.containsKey(e2)).count();
            int keyDifference = Long.compare(uniqueForMe, uniqueForOther = other.dict.keySet().stream().filter(e2 -> !this.dict.containsKey(e2)).count());
            if (keyDifference != 0) {
                return keyDifference;
            }
            for (String key : this.dict.keySet().stream().sorted(String::compareTo).collect(Collectors.toCollection(LinkedList::new))) {
                int itemDifference = this.objectForKey(key).compareTo(other.objectForKey(key));
                if (itemDifference == 0) continue;
                return itemDifference;
            }
            return 0;
        }
        return this.getClass().getName().compareTo(o2.getClass().getName());
    }

    @Override
    void toXML(StringBuilder xml, int level) {
        this.indent(xml, level);
        xml.append("<dict>");
        xml.append(NSObject.NEWLINE);
        for (String key : this.dict.keySet()) {
            NSObject val = this.objectForKey(key);
            this.indent(xml, level + 1);
            xml.append("<key>");
            if (key.contains("&") || key.contains("<") || key.contains(">")) {
                xml.append("<![CDATA[");
                xml.append(key.replaceAll("]]>", "]]]]><![CDATA[>"));
                xml.append("]]>");
            } else {
                xml.append(key);
            }
            xml.append("</key>");
            xml.append(NSObject.NEWLINE);
            val.toXML(xml, level + 1);
            xml.append(NSObject.NEWLINE);
        }
        this.indent(xml, level);
        xml.append("</dict>");
    }

    @Override
    void assignIDs(BinaryPropertyListWriter out) {
        super.assignIDs(out);
        for (Map.Entry<String, NSObject> entry : this.dict.entrySet()) {
            new NSString(entry.getKey()).assignIDs(out);
        }
        for (Map.Entry<String, NSObject> entry : this.dict.entrySet()) {
            entry.getValue().assignIDs(out);
        }
    }

    @Override
    void toBinary(BinaryPropertyListWriter out) throws IOException {
        out.writeIntHeader(13, this.dict.size());
        Set<Map.Entry<String, NSObject>> entries2 = this.dict.entrySet();
        for (Map.Entry<String, NSObject> entry : entries2) {
            out.writeID(out.getID(new NSString(entry.getKey())));
        }
        for (Map.Entry<String, NSObject> entry : entries2) {
            out.writeID(out.getID(entry.getValue()));
        }
    }

    public String toASCIIPropertyList() {
        StringBuilder ascii = new StringBuilder();
        this.toASCII(ascii, 0);
        ascii.append(NEWLINE);
        return ascii.toString();
    }

    public String toGnuStepASCIIPropertyList() {
        StringBuilder ascii = new StringBuilder();
        this.toASCIIGnuStep(ascii, 0);
        ascii.append(NEWLINE);
        return ascii.toString();
    }

    @Override
    protected void toASCII(StringBuilder ascii, int level) {
        String[] keys;
        this.indent(ascii, level);
        ascii.append('{');
        ascii.append(NEWLINE);
        for (String key : keys = this.allKeys()) {
            NSObject val = this.objectForKey(key);
            this.indent(ascii, level + 1);
            ascii.append('\"');
            ascii.append(NSString.escapeStringForASCII(key));
            ascii.append("\" =");
            Class<?> objClass = val.getClass();
            if (objClass.equals(NSDictionary.class) || objClass.equals(NSArray.class) || objClass.equals(NSData.class)) {
                ascii.append(NEWLINE);
                val.toASCII(ascii, level + 2);
            } else {
                ascii.append(' ');
                val.toASCII(ascii, 0);
            }
            ascii.append(';');
            ascii.append(NEWLINE);
        }
        this.indent(ascii, level);
        ascii.append('}');
    }

    @Override
    protected void toASCIIGnuStep(StringBuilder ascii, int level) {
        String[] keys;
        this.indent(ascii, level);
        ascii.append('{');
        ascii.append(NEWLINE);
        for (String key : keys = this.dict.keySet().toArray(new String[0])) {
            NSObject val = this.objectForKey(key);
            this.indent(ascii, level + 1);
            ascii.append('\"');
            ascii.append(NSString.escapeStringForASCII(key));
            ascii.append("\" =");
            Class<?> objClass = val.getClass();
            if (objClass.equals(NSDictionary.class) || objClass.equals(NSArray.class) || objClass.equals(NSData.class)) {
                ascii.append(NEWLINE);
                val.toASCIIGnuStep(ascii, level + 2);
            } else {
                ascii.append(' ');
                val.toASCIIGnuStep(ascii, 0);
            }
            ascii.append(';');
            ascii.append(NEWLINE);
        }
        this.indent(ascii, level);
        ascii.append('}');
    }
}

