/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.kryo.kryo5.io;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;

public class ByteBufferOutputStream
extends OutputStream {
    private ByteBuffer byteBuffer;

    public ByteBufferOutputStream() {
    }

    public ByteBufferOutputStream(int bufferSize) {
        this(ByteBuffer.allocate(bufferSize));
    }

    public ByteBufferOutputStream(ByteBuffer byteBuffer) {
        this.byteBuffer = byteBuffer;
    }

    public ByteBuffer getByteBuffer() {
        return this.byteBuffer;
    }

    public void setByteBuffer(ByteBuffer byteBuffer) {
        this.byteBuffer = byteBuffer;
    }

    @Override
    public void write(int b2) throws IOException {
        if (!this.byteBuffer.hasRemaining()) {
            this.flush();
        }
        this.byteBuffer.put((byte)b2);
    }

    @Override
    public void write(byte[] bytes, int offset, int length) throws IOException {
        if (this.byteBuffer.remaining() < length) {
            this.flush();
        }
        this.byteBuffer.put(bytes, offset, length);
    }
}

