/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.kryo.kryo5.io;

import com.esotericsoftware.kryo.kryo5.KryoException;
import com.esotericsoftware.kryo.kryo5.io.Input;
import com.esotericsoftware.kryo.kryo5.minlog.Log;
import java.io.IOException;
import java.io.InputStream;

public class InputChunked
extends Input {
    private int chunkSize = -1;

    public InputChunked() {
    }

    public InputChunked(int bufferSize) {
        super(bufferSize);
    }

    public InputChunked(InputStream inputStream2) {
        super(inputStream2);
    }

    public InputChunked(InputStream inputStream2, int bufferSize) {
        super(inputStream2, bufferSize);
    }

    @Override
    public void setInputStream(InputStream inputStream2) {
        super.setInputStream(inputStream2);
        this.chunkSize = -1;
    }

    @Override
    public void setBuffer(byte[] bytes, int offset, int count) {
        super.setBuffer(bytes, offset, count);
        this.chunkSize = -1;
    }

    @Override
    public void reset() {
        super.reset();
        this.chunkSize = -1;
    }

    @Override
    protected int fill(byte[] buffer, int offset, int count) throws KryoException {
        if (this.chunkSize == -1 ? !this.readChunkSize() : this.chunkSize == 0) {
            return -1;
        }
        int actual = super.fill(buffer, offset, Math.min(this.chunkSize, count));
        this.chunkSize -= actual;
        if (this.chunkSize == 0 && !this.readChunkSize()) {
            return -1;
        }
        return actual;
    }

    private boolean readChunkSize() {
        try {
            InputStream inputStream2 = this.getInputStream();
            int result2 = 0;
            for (int offset = 0; offset < 32; offset += 7) {
                int b2 = inputStream2.read();
                if (b2 == -1) {
                    return false;
                }
                result2 |= (b2 & 0x7F) << offset;
                if ((b2 & 0x80) != 0) continue;
                this.chunkSize = result2;
                if (Log.TRACE && this.chunkSize > 0) {
                    Log.trace("kryo", "Read chunk: " + this.chunkSize);
                }
                return true;
            }
        }
        catch (IOException ex2) {
            throw new KryoException("Unable to read chunk size.", ex2);
        }
        throw new KryoException("Unable to read chunk size: malformed integer");
    }

    public void nextChunk() {
        this.position = this.limit;
        if (this.chunkSize == -1) {
            this.readChunkSize();
        }
        while (this.chunkSize > 0) {
            this.skip(this.chunkSize);
        }
        this.chunkSize = -1;
        if (Log.TRACE) {
            Log.trace("kryo", "Next chunk.");
        }
    }
}

