/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.kryo.kryo5.io;

import com.esotericsoftware.kryo.kryo5.KryoException;
import com.esotericsoftware.kryo.kryo5.io.Output;
import com.esotericsoftware.kryo.kryo5.minlog.Log;
import com.esotericsoftware.kryo.kryo5.util.Util;
import java.io.IOException;
import java.io.OutputStream;

public class OutputChunked
extends Output {
    public OutputChunked() {
    }

    public OutputChunked(int bufferSize) {
        super(bufferSize);
    }

    public OutputChunked(OutputStream outputStream2) {
        super(outputStream2);
    }

    public OutputChunked(OutputStream outputStream2, int bufferSize) {
        super(outputStream2, bufferSize);
    }

    @Override
    public void flush() throws KryoException {
        if (this.position() > 0) {
            try {
                this.writeChunkSize();
                super.flush();
            }
            catch (IOException ex2) {
                throw new KryoException(ex2);
            }
        } else {
            super.flush();
        }
    }

    private void writeChunkSize() throws IOException {
        int size = this.position();
        if (Log.TRACE) {
            Log.trace("kryo", "Write chunk: " + size + Util.pos(size));
        }
        OutputStream outputStream2 = this.getOutputStream();
        if ((size & 0xFFFFFF80) == 0) {
            outputStream2.write(size);
            return;
        }
        outputStream2.write(size & 0x7F | 0x80);
        if (((size >>>= 7) & 0xFFFFFF80) == 0) {
            outputStream2.write(size);
            return;
        }
        outputStream2.write(size & 0x7F | 0x80);
        if (((size >>>= 7) & 0xFFFFFF80) == 0) {
            outputStream2.write(size);
            return;
        }
        outputStream2.write(size & 0x7F | 0x80);
        if (((size >>>= 7) & 0xFFFFFF80) == 0) {
            outputStream2.write(size);
            return;
        }
        outputStream2.write(size & 0x7F | 0x80);
        outputStream2.write(size >>>= 7);
    }

    public void endChunk() {
        this.flush();
        if (Log.TRACE) {
            Log.trace("kryo", "End chunk.");
        }
        try {
            this.getOutputStream().write(0);
        }
        catch (IOException ex2) {
            throw new KryoException(ex2);
        }
    }
}

