/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.kryo.kryo5.serializers;

import com.esotericsoftware.kryo.kryo5.KryoException;
import com.esotericsoftware.kryo.kryo5.io.Input;
import com.esotericsoftware.kryo.kryo5.io.Output;
import com.esotericsoftware.kryo.kryo5.serializers.FieldSerializer;
import com.esotericsoftware.kryo.kryo5.serializers.ReflectField;
import com.esotericsoftware.kryo.kryo5.util.Generics;
import java.lang.reflect.Field;

class AsmField
extends ReflectField {
    public AsmField(Field field, FieldSerializer serializer2, Generics.GenericType genericType) {
        super(field, serializer2, genericType);
    }

    @Override
    public Object get(Object object) throws IllegalAccessException {
        return this.access.get(object, this.accessIndex);
    }

    @Override
    public void set(Object object, Object value) throws IllegalAccessException {
        this.access.set(object, this.accessIndex, value);
    }

    @Override
    public void copy(Object original, Object copy) {
        try {
            this.access.set(copy, this.accessIndex, this.fieldSerializer.kryo.copy(this.access.get(original, this.accessIndex)));
        }
        catch (KryoException ex2) {
            ex2.addTrace(this + " (" + this.fieldSerializer.type.getName() + ")");
            throw ex2;
        }
        catch (Throwable t2) {
            KryoException ex3 = new KryoException(t2);
            ex3.addTrace(this + " (" + this.fieldSerializer.type.getName() + ")");
            throw ex3;
        }
    }

    static final class StringAsmField
    extends FieldSerializer.CachedField {
        public StringAsmField(Field field) {
            super(field);
        }

        @Override
        public void write(Output output2, Object object) {
            output2.writeString(this.access.getString(object, this.accessIndex));
        }

        @Override
        public void read(Input input2, Object object) {
            this.access.set(object, this.accessIndex, (Object)input2.readString());
        }

        @Override
        public void copy(Object original, Object copy) {
            this.access.set(copy, this.accessIndex, (Object)this.access.getString(original, this.accessIndex));
        }
    }

    static final class DoubleAsmField
    extends FieldSerializer.CachedField {
        public DoubleAsmField(Field field) {
            super(field);
        }

        @Override
        public void write(Output output2, Object object) {
            output2.writeDouble(this.access.getDouble(object, this.accessIndex));
        }

        @Override
        public void read(Input input2, Object object) {
            this.access.setDouble(object, this.accessIndex, input2.readDouble());
        }

        @Override
        public void copy(Object original, Object copy) {
            this.access.setDouble(copy, this.accessIndex, this.access.getDouble(original, this.accessIndex));
        }
    }

    static final class LongAsmField
    extends FieldSerializer.CachedField {
        public LongAsmField(Field field) {
            super(field);
        }

        @Override
        public void write(Output output2, Object object) {
            if (this.varEncoding) {
                output2.writeVarLong(this.access.getLong(object, this.accessIndex), false);
            } else {
                output2.writeLong(this.access.getLong(object, this.accessIndex));
            }
        }

        @Override
        public void read(Input input2, Object object) {
            if (this.varEncoding) {
                this.access.setLong(object, this.accessIndex, input2.readVarLong(false));
            } else {
                this.access.setLong(object, this.accessIndex, input2.readLong());
            }
        }

        @Override
        public void copy(Object original, Object copy) {
            this.access.setLong(copy, this.accessIndex, this.access.getLong(original, this.accessIndex));
        }
    }

    static final class CharAsmField
    extends FieldSerializer.CachedField {
        public CharAsmField(Field field) {
            super(field);
        }

        @Override
        public void write(Output output2, Object object) {
            output2.writeChar(this.access.getChar(object, this.accessIndex));
        }

        @Override
        public void read(Input input2, Object object) {
            this.access.setChar(object, this.accessIndex, input2.readChar());
        }

        @Override
        public void copy(Object original, Object copy) {
            this.access.setChar(copy, this.accessIndex, this.access.getChar(original, this.accessIndex));
        }
    }

    static final class BooleanAsmField
    extends FieldSerializer.CachedField {
        public BooleanAsmField(Field field) {
            super(field);
        }

        @Override
        public void write(Output output2, Object object) {
            output2.writeBoolean(this.access.getBoolean(object, this.accessIndex));
        }

        @Override
        public void read(Input input2, Object object) {
            this.access.setBoolean(object, this.accessIndex, input2.readBoolean());
        }

        @Override
        public void copy(Object original, Object copy) {
            this.access.setBoolean(copy, this.accessIndex, this.access.getBoolean(original, this.accessIndex));
        }
    }

    static final class ByteAsmField
    extends FieldSerializer.CachedField {
        public ByteAsmField(Field field) {
            super(field);
        }

        @Override
        public void write(Output output2, Object object) {
            output2.writeByte(this.access.getByte(object, this.accessIndex));
        }

        @Override
        public void read(Input input2, Object object) {
            this.access.setByte(object, this.accessIndex, input2.readByte());
        }

        @Override
        public void copy(Object original, Object copy) {
            this.access.setByte(copy, this.accessIndex, this.access.getByte(original, this.accessIndex));
        }
    }

    static final class ShortAsmField
    extends FieldSerializer.CachedField {
        public ShortAsmField(Field field) {
            super(field);
        }

        @Override
        public void write(Output output2, Object object) {
            output2.writeShort(this.access.getShort(object, this.accessIndex));
        }

        @Override
        public void read(Input input2, Object object) {
            this.access.setShort(object, this.accessIndex, input2.readShort());
        }

        @Override
        public void copy(Object original, Object copy) {
            this.access.setShort(copy, this.accessIndex, this.access.getShort(original, this.accessIndex));
        }
    }

    static final class FloatAsmField
    extends FieldSerializer.CachedField {
        public FloatAsmField(Field field) {
            super(field);
        }

        @Override
        public void write(Output output2, Object object) {
            output2.writeFloat(this.access.getFloat(object, this.accessIndex));
        }

        @Override
        public void read(Input input2, Object object) {
            this.access.setFloat(object, this.accessIndex, input2.readFloat());
        }

        @Override
        public void copy(Object original, Object copy) {
            this.access.setFloat(copy, this.accessIndex, this.access.getFloat(original, this.accessIndex));
        }
    }

    static final class IntAsmField
    extends FieldSerializer.CachedField {
        public IntAsmField(Field field) {
            super(field);
        }

        @Override
        public void write(Output output2, Object object) {
            if (this.varEncoding) {
                output2.writeVarInt(this.access.getInt(object, this.accessIndex), false);
            } else {
                output2.writeInt(this.access.getInt(object, this.accessIndex));
            }
        }

        @Override
        public void read(Input input2, Object object) {
            if (this.varEncoding) {
                this.access.setInt(object, this.accessIndex, input2.readVarInt(false));
            } else {
                this.access.setInt(object, this.accessIndex, input2.readInt());
            }
        }

        @Override
        public void copy(Object original, Object copy) {
            this.access.setInt(copy, this.accessIndex, this.access.getInt(original, this.accessIndex));
        }
    }
}

