/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.kryo.kryo5.serializers;

import com.esotericsoftware.kryo.kryo5.Kryo;
import com.esotericsoftware.kryo.kryo5.Registration;
import com.esotericsoftware.kryo.kryo5.Serializer;
import com.esotericsoftware.kryo.kryo5.SerializerFactory;
import com.esotericsoftware.kryo.kryo5.io.Input;
import com.esotericsoftware.kryo.kryo5.io.Output;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;

public class CollectionSerializer<T extends Collection>
extends Serializer<T> {
    private boolean elementsCanBeNull = true;
    private Serializer elementSerializer;
    private Class elementClass;

    public CollectionSerializer() {
        this.setAcceptsNull(true);
    }

    public void setElementsCanBeNull(boolean elementsCanBeNull) {
        this.elementsCanBeNull = elementsCanBeNull;
    }

    public void setElementClass(Class elementClass) {
        this.elementClass = elementClass;
    }

    public Class getElementClass() {
        return this.elementClass;
    }

    public void setElementClass(Class elementClass, Serializer serializer2) {
        this.elementClass = elementClass;
        this.elementSerializer = serializer2;
    }

    public void setElementSerializer(Serializer elementSerializer) {
        this.elementSerializer = elementSerializer;
    }

    public Serializer getElementSerializer() {
        return this.elementSerializer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(Kryo kryo, Output output2, T collection) {
        Object genericClass;
        if (collection == null) {
            output2.writeByte((byte)0);
            return;
        }
        int length = collection.size();
        if (length == 0) {
            output2.writeByte(1);
            this.writeHeader(kryo, output2, collection);
            return;
        }
        boolean elementsCanBeNull = this.elementsCanBeNull;
        Serializer elementSerializer = this.elementSerializer;
        if (elementSerializer == null && (genericClass = kryo.getGenerics().nextGenericClass()) != null && kryo.isFinal((Class)genericClass)) {
            elementSerializer = kryo.getSerializer((Class)genericClass);
        }
        try {
            block25: {
                if (elementSerializer != null) {
                    block24: {
                        if (elementsCanBeNull) {
                            for (Object element : collection) {
                                if (element != null) continue;
                                output2.writeVarIntFlag(true, length + 1, true);
                                break block24;
                            }
                            output2.writeVarIntFlag(false, length + 1, true);
                            elementsCanBeNull = false;
                        } else {
                            output2.writeVarInt(length + 1, true);
                        }
                    }
                    this.writeHeader(kryo, output2, collection);
                } else {
                    Class<?> elementType = null;
                    boolean hasNull = false;
                    for (Object element : collection) {
                        if (element == null) {
                            hasNull = true;
                            continue;
                        }
                        if (elementType == null) {
                            elementType = element.getClass();
                            continue;
                        }
                        if (element.getClass() == elementType) continue;
                        output2.writeVarIntFlag(false, length + 1, true);
                        this.writeHeader(kryo, output2, collection);
                        break block25;
                    }
                    output2.writeVarIntFlag(true, length + 1, true);
                    this.writeHeader(kryo, output2, collection);
                    if (elementType == null) {
                        output2.writeByte((byte)0);
                        return;
                    }
                    kryo.writeClass(output2, elementType);
                    elementSerializer = kryo.getSerializer(elementType);
                    if (elementsCanBeNull) {
                        output2.writeBoolean(hasNull);
                        elementsCanBeNull = hasNull;
                    }
                }
            }
            if (elementSerializer != null) {
                if (elementsCanBeNull) {
                    for (Object element : collection) {
                        kryo.writeObjectOrNull(output2, element, elementSerializer);
                    }
                } else {
                    for (Object element : collection) {
                        kryo.writeObject(output2, element, elementSerializer);
                    }
                }
            } else {
                for (Object element : collection) {
                    kryo.writeClassAndObject(output2, element);
                }
            }
        }
        finally {
            kryo.getGenerics().popGenericType();
        }
    }

    protected void writeHeader(Kryo kryo, Output output2, T collection) {
    }

    protected T create(Kryo kryo, Input input2, Class<? extends T> type, int size) {
        if (type == ArrayList.class) {
            return (T)new ArrayList(size);
        }
        if (type == HashSet.class) {
            return (T)new HashSet(Math.max((int)((float)size / 0.75f) + 1, 16));
        }
        Collection collection = (Collection)kryo.newInstance(type);
        if (collection instanceof ArrayList) {
            ((ArrayList)collection).ensureCapacity(size);
        }
        return (T)collection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T read(Kryo kryo, Input input2, Class<? extends T> type) {
        Class genericClass;
        Class elementClass = this.elementClass;
        Serializer elementSerializer = this.elementSerializer;
        if (elementSerializer == null && (genericClass = kryo.getGenerics().nextGenericClass()) != null && kryo.isFinal(genericClass)) {
            elementSerializer = kryo.getSerializer(genericClass);
            elementClass = genericClass;
        }
        try {
            int i2;
            T collection;
            int length;
            boolean elementsCanBeNull = this.elementsCanBeNull;
            if (elementSerializer != null) {
                if (elementsCanBeNull) {
                    elementsCanBeNull = input2.readVarIntFlag();
                    length = input2.readVarIntFlag(true);
                } else {
                    length = input2.readVarInt(true);
                }
                if (length == 0) {
                    T t2 = null;
                    return t2;
                }
                collection = this.create(kryo, input2, type, --length);
                kryo.reference(collection);
                if (length == 0) {
                    T t3 = collection;
                    return t3;
                }
            } else {
                boolean sameType = input2.readVarIntFlag();
                length = input2.readVarIntFlag(true);
                if (length == 0) {
                    T t4 = null;
                    return t4;
                }
                collection = this.create(kryo, input2, type, --length);
                kryo.reference(collection);
                if (length == 0) {
                    T t5 = collection;
                    return t5;
                }
                if (sameType) {
                    Registration registration = kryo.readClass(input2);
                    if (registration == null) {
                        for (int i3 = 0; i3 < length; ++i3) {
                            collection.add(null);
                        }
                        kryo.getGenerics().popGenericType();
                        T t6 = collection;
                        return t6;
                    }
                    elementClass = registration.getType();
                    elementSerializer = kryo.getSerializer(elementClass);
                    if (elementsCanBeNull) {
                        elementsCanBeNull = input2.readBoolean();
                    }
                }
            }
            if (elementSerializer != null) {
                if (elementsCanBeNull) {
                    for (i2 = 0; i2 < length; ++i2) {
                        collection.add(kryo.readObjectOrNull(input2, elementClass, elementSerializer));
                    }
                } else {
                    for (i2 = 0; i2 < length; ++i2) {
                        collection.add(kryo.readObject(input2, elementClass, elementSerializer));
                    }
                }
            } else {
                for (i2 = 0; i2 < length; ++i2) {
                    collection.add((Object)kryo.readClassAndObject(input2));
                }
            }
            T t7 = collection;
            return t7;
        }
        finally {
            kryo.getGenerics().popGenericType();
        }
    }

    protected T createCopy(Kryo kryo, T original) {
        return (T)((Collection)kryo.newInstance(original.getClass()));
    }

    @Override
    public T copy(Kryo kryo, T original) {
        T copy = this.createCopy(kryo, original);
        kryo.reference(copy);
        for (Object element : original) {
            copy.add(kryo.copy(element));
        }
        return copy;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface BindCollection {
        public Class elementClass() default Object.class;

        public Class<? extends Serializer> elementSerializer() default Serializer.class;

        public Class<? extends SerializerFactory> elementSerializerFactory() default SerializerFactory.class;

        public boolean elementsCanBeNull() default true;
    }
}

