/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.kryo.kryo5.serializers;

import com.esotericsoftware.kryo.kryo5.Kryo;
import com.esotericsoftware.kryo.kryo5.KryoException;
import com.esotericsoftware.kryo.kryo5.Serializer;
import com.esotericsoftware.kryo.kryo5.io.Input;
import com.esotericsoftware.kryo.kryo5.io.InputChunked;
import com.esotericsoftware.kryo.kryo5.io.Output;
import com.esotericsoftware.kryo.kryo5.io.OutputChunked;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;

public class DeflateSerializer
extends Serializer {
    private final Serializer serializer;
    private boolean noHeaders = true;
    private int compressionLevel = 4;

    public DeflateSerializer(Serializer serializer2) {
        this.serializer = serializer2;
    }

    public void write(Kryo kryo, Output output2, Object object) {
        OutputChunked outputChunked = new OutputChunked(output2, 256);
        Deflater deflater = new Deflater(this.compressionLevel, this.noHeaders);
        try {
            DeflaterOutputStream deflaterStream = new DeflaterOutputStream((OutputStream)outputChunked, deflater);
            Output deflaterOutput = new Output(deflaterStream, 256);
            this.serializer.write(kryo, deflaterOutput, object);
            deflaterOutput.flush();
            deflaterStream.finish();
        }
        catch (IOException ex2) {
            throw new KryoException(ex2);
        }
        finally {
            deflater.end();
        }
        outputChunked.endChunk();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object read(Kryo kryo, Input input2, Class type) {
        Inflater inflater = new Inflater(this.noHeaders);
        try {
            InflaterInputStream inflaterStream = new InflaterInputStream(new InputChunked(input2, 256), inflater);
            Object t2 = this.serializer.read(kryo, new Input(inflaterStream, 256), type);
            return t2;
        }
        finally {
            inflater.end();
        }
    }

    public void setNoHeaders(boolean noHeaders) {
        this.noHeaders = noHeaders;
    }

    public void setCompressionLevel(int compressionLevel) {
        this.compressionLevel = compressionLevel;
    }

    public Object copy(Kryo kryo, Object original) {
        return this.serializer.copy(kryo, original);
    }
}

