/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.kryo.kryo5.serializers;

import com.esotericsoftware.kryo.kryo5.Kryo;
import com.esotericsoftware.kryo.kryo5.KryoException;
import com.esotericsoftware.kryo.kryo5.Registration;
import com.esotericsoftware.kryo.kryo5.io.Input;
import com.esotericsoftware.kryo.kryo5.io.InputChunked;
import com.esotericsoftware.kryo.kryo5.io.Output;
import com.esotericsoftware.kryo.kryo5.io.OutputChunked;
import com.esotericsoftware.kryo.kryo5.minlog.Log;
import com.esotericsoftware.kryo.kryo5.serializers.FieldSerializer;
import com.esotericsoftware.kryo.kryo5.util.IntMap;
import com.esotericsoftware.kryo.kryo5.util.Util;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.util.ArrayList;

public class TaggedFieldSerializer<T>
extends FieldSerializer<T> {
    private FieldSerializer.CachedField[] writeTags;
    private IntMap<FieldSerializer.CachedField> readTags;
    private final TaggedFieldSerializerConfig config;

    public TaggedFieldSerializer(Kryo kryo, Class type) {
        this(kryo, type, new TaggedFieldSerializerConfig());
    }

    public TaggedFieldSerializer(Kryo kryo, Class type, TaggedFieldSerializerConfig config) {
        super(kryo, type, config);
        this.config = config;
        this.setAcceptsNull(true);
    }

    @Override
    protected void initializeCachedFields() {
        FieldSerializer.CachedField[] fields = this.cachedFields.fields;
        int n2 = fields.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            Field field = fields[i2].field;
            if (field.getAnnotation(Tag.class) != null) continue;
            if (Log.TRACE) {
                Log.trace("kryo", "Ignoring field without tag: " + fields[i2]);
            }
            super.removeField(fields[i2]);
        }
        fields = this.cachedFields.fields;
        ArrayList<FieldSerializer.CachedField> writeTags = new ArrayList<FieldSerializer.CachedField>(fields.length);
        this.readTags = new IntMap((int)((float)fields.length / 0.8f));
        for (FieldSerializer.CachedField cachedField : fields) {
            Field field = cachedField.field;
            int tag = field.getAnnotation(Tag.class).value();
            if (this.readTags.containsKey(tag)) {
                throw new KryoException(String.format("Duplicate tag %d on fields: %s and %s", tag, field, writeTags.get(tag)));
            }
            this.readTags.put(tag, cachedField);
            if (field.getAnnotation(Deprecated.class) == null) {
                writeTags.add(cachedField);
            }
            cachedField.tag = tag;
        }
        this.writeTags = writeTags.toArray(new FieldSerializer.CachedField[writeTags.size()]);
    }

    @Override
    public void removeField(String fieldName) {
        super.removeField(fieldName);
        this.initializeCachedFields();
    }

    @Override
    public void removeField(FieldSerializer.CachedField field) {
        super.removeField(field);
        this.initializeCachedFields();
    }

    @Override
    public void write(Kryo kryo, Output output2, T object) {
        Output fieldOutput;
        if (object == null) {
            output2.writeByte((byte)0);
            return;
        }
        int pop = this.pushTypeVariables();
        FieldSerializer.CachedField[] writeTags = this.writeTags;
        output2.writeVarInt(writeTags.length + 1, true);
        this.writeHeader(kryo, output2, object);
        boolean chunked2 = this.config.chunked;
        boolean readUnknownTagData = this.config.readUnknownTagData;
        OutputChunked outputChunked = null;
        if (chunked2) {
            outputChunked = new OutputChunked(output2, this.config.chunkSize);
            fieldOutput = outputChunked;
        } else {
            fieldOutput = output2;
        }
        for (FieldSerializer.CachedField cachedField : writeTags) {
            if (Log.TRACE) {
                this.log("Write", cachedField, output2.position());
            }
            output2.writeVarInt(cachedField.tag, true);
            if (readUnknownTagData) {
                Class<?> valueClass = null;
                try {
                    Object value;
                    if (object != null && (value = cachedField.field.get(object)) != null) {
                        valueClass = value.getClass();
                    }
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
                kryo.writeClass(fieldOutput, valueClass);
                if (valueClass == null) {
                    if (!chunked2) continue;
                    outputChunked.endChunk();
                    continue;
                }
                cachedField.setCanBeNull(false);
                cachedField.setValueClass(valueClass);
                cachedField.setReuseSerializer(false);
            }
            cachedField.write(fieldOutput, object);
            if (!chunked2) continue;
            outputChunked.endChunk();
        }
        this.popTypeVariables(pop);
    }

    protected void writeHeader(Kryo kryo, Output output2, T object) {
    }

    @Override
    public T read(Kryo kryo, Input input2, Class<? extends T> type) {
        Input fieldInput;
        int fieldCount = input2.readVarInt(true);
        if (fieldCount == 0) {
            return null;
        }
        --fieldCount;
        int pop = this.pushTypeVariables();
        T object = this.create(kryo, input2, type);
        kryo.reference(object);
        boolean chunked2 = this.config.chunked;
        boolean readUnknownTagData = this.config.readUnknownTagData;
        InputChunked inputChunked = null;
        if (chunked2) {
            inputChunked = new InputChunked(input2, this.config.chunkSize);
            fieldInput = inputChunked;
        } else {
            fieldInput = input2;
        }
        IntMap<FieldSerializer.CachedField> readTags = this.readTags;
        for (int i2 = 0; i2 < fieldCount; ++i2) {
            int tag = input2.readVarInt(true);
            FieldSerializer.CachedField cachedField = readTags.get(tag);
            if (readUnknownTagData) {
                Registration registration;
                try {
                    registration = kryo.readClass(fieldInput);
                }
                catch (KryoException ex2) {
                    String message = "Unable to read unknown tag " + tag + " data (unknown type). (" + this.getType().getName() + "#" + cachedField + ")";
                    if (!chunked2) {
                        throw new KryoException(message, ex2);
                    }
                    if (Log.DEBUG) {
                        Log.debug("kryo", message, ex2);
                    }
                    inputChunked.nextChunk();
                    continue;
                }
                if (registration == null) {
                    if (!chunked2) continue;
                    inputChunked.nextChunk();
                    continue;
                }
                Class valueClass = registration.getType();
                if (cachedField == null) {
                    block20: {
                        if (Log.TRACE) {
                            Log.trace("kryo", "Read unknown tag " + tag + " data, type: " + Util.className(valueClass));
                        }
                        try {
                            kryo.readObject(fieldInput, valueClass);
                        }
                        catch (KryoException ex3) {
                            String message = "Unable to read unknown tag " + tag + " data, type: " + Util.className(valueClass) + " (" + this.getType().getName() + "#" + cachedField + ")";
                            if (!chunked2) {
                                throw new KryoException(message, ex3);
                            }
                            if (!Log.DEBUG) break block20;
                            Log.debug("kryo", message, ex3);
                        }
                    }
                    if (!chunked2) continue;
                    inputChunked.nextChunk();
                    continue;
                }
                cachedField.setCanBeNull(false);
                cachedField.setValueClass(valueClass);
                cachedField.setReuseSerializer(false);
            } else if (cachedField == null) {
                if (!chunked2) {
                    throw new KryoException("Unknown field tag: " + tag + " (" + this.getType().getName() + ")");
                }
                if (Log.TRACE) {
                    Log.trace("kryo", "Skip unknown field tag: " + tag);
                }
                inputChunked.nextChunk();
                continue;
            }
            if (Log.TRACE) {
                this.log("Read", cachedField, input2.position());
            }
            cachedField.read(fieldInput, object);
            if (!chunked2) continue;
            inputChunked.nextChunk();
        }
        this.popTypeVariables(pop);
        return object;
    }

    public TaggedFieldSerializerConfig getTaggedFieldSerializerConfig() {
        return this.config;
    }

    public static class TaggedFieldSerializerConfig
    extends FieldSerializer.FieldSerializerConfig {
        boolean readUnknownTagData;
        boolean chunked;
        int chunkSize = 1024;

        @Override
        public TaggedFieldSerializerConfig clone() {
            return (TaggedFieldSerializerConfig)super.clone();
        }

        public void setReadUnknownTagData(boolean readUnknownTagData) {
            this.readUnknownTagData = readUnknownTagData;
        }

        public boolean getReadUnknownTagData() {
            return this.readUnknownTagData;
        }

        public void setChunkedEncoding(boolean chunked2) {
            this.chunked = chunked2;
            if (Log.TRACE) {
                Log.trace("kryo", "TaggedFieldSerializerConfig setChunked: " + chunked2);
            }
        }

        public boolean getChunkedEncoding() {
            return this.chunked;
        }

        public void setChunkSize(int chunkSize) {
            this.chunkSize = chunkSize;
            if (Log.TRACE) {
                Log.trace("kryo", "TaggedFieldSerializerConfig setChunkSize: " + chunkSize);
            }
        }

        public int getChunkSize() {
            return this.chunkSize;
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Tag {
        public int value();
    }
}

