/*
 * Decompiled with CFR 0.152.
 */
package com.jediterm.terminal;

import com.jediterm.terminal.TtyConnector;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ProcessTtyConnector
implements TtyConnector {
    protected final InputStream myInputStream;
    protected final OutputStream myOutputStream;
    protected final InputStreamReader myReader;
    protected final Charset myCharset;
    private final Process myProcess;
    @Nullable
    private final List<String> myCommandLine;

    public ProcessTtyConnector(@NotNull Process process, @NotNull Charset charset) {
        this(process, charset, null);
    }

    public ProcessTtyConnector(@NotNull Process process, @NotNull Charset charset, @Nullable List<String> commandLine) {
        this.myOutputStream = process.getOutputStream();
        this.myCharset = charset;
        this.myInputStream = process.getInputStream();
        this.myReader = new InputStreamReader(this.myInputStream, charset);
        this.myProcess = process;
        this.myCommandLine = commandLine;
    }

    @NotNull
    public Process getProcess() {
        return this.myProcess;
    }

    @Override
    public abstract String getName();

    @Nullable
    public List<String> getCommandLine() {
        return this.myCommandLine != null ? Collections.unmodifiableList(this.myCommandLine) : null;
    }

    @Override
    public int read(char[] buf, int offset, int length) throws IOException {
        return this.myReader.read(buf, offset, length);
    }

    @Override
    public void write(byte[] bytes) throws IOException {
        this.myOutputStream.write(bytes);
        this.myOutputStream.flush();
    }

    @Override
    public boolean isConnected() {
        return this.myProcess.isAlive();
    }

    @Override
    public void write(String string2) throws IOException {
        this.write(string2.getBytes(this.myCharset));
    }

    @Override
    public void close() {
        this.myProcess.destroy();
        try {
            this.myOutputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            this.myInputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public int waitFor() throws InterruptedException {
        return this.myProcess.waitFor();
    }

    @Override
    public boolean ready() throws IOException {
        return this.myReader.ready();
    }
}

