/*
 * Decompiled with CFR 0.152.
 */
package com.jediterm.terminal.emulator;

import com.jediterm.terminal.TerminalDataStream;
import com.jediterm.terminal.util.CharUtils;
import java.io.IOException;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class ControlSequence {
    private int myArgc = 0;
    private int[] myArgv;
    private char myFinalChar;
    private ArrayList<Character> myUnhandledChars;
    private boolean myStartsWithExclamationMark = false;
    private boolean myStartsWithQuestionMark = false;
    private boolean myStartsWithMoreMark = false;
    private final StringBuilder mySequenceString = new StringBuilder();

    ControlSequence(TerminalDataStream channel) throws IOException {
        this.myArgv = new int[5];
        this.readControlSequence(channel);
    }

    private void readControlSequence(TerminalDataStream channel) throws IOException {
        char b2;
        this.myArgc = 0;
        int digit = 0;
        int seenDigit = 0;
        int pos = -1;
        while (true) {
            b2 = channel.getChar();
            this.mySequenceString.append(b2);
            if (b2 == '!' && ++pos == 0) {
                this.myStartsWithExclamationMark = true;
                continue;
            }
            if (b2 == '?' && pos == 0) {
                this.myStartsWithQuestionMark = true;
                continue;
            }
            if (b2 == '>' && pos == 0) {
                this.myStartsWithMoreMark = true;
                continue;
            }
            if (b2 == ';') {
                if (digit <= 0) continue;
                ++this.myArgc;
                if (this.myArgc == this.myArgv.length) {
                    int[] replacement = new int[this.myArgv.length * 2];
                    System.arraycopy(this.myArgv, 0, replacement, 0, this.myArgv.length);
                    this.myArgv = replacement;
                }
                this.myArgv[this.myArgc] = 0;
                digit = 0;
                continue;
            }
            if ('0' <= b2 && b2 <= '9') {
                this.myArgv[this.myArgc] = this.myArgv[this.myArgc] * 10 + b2 - 48;
                ++digit;
                seenDigit = 1;
                continue;
            }
            if (':' <= b2 && b2 <= '?') {
                this.addUnhandled(b2);
                continue;
            }
            if ('@' <= b2 && b2 <= '~') break;
            this.addUnhandled(b2);
        }
        this.myFinalChar = b2;
        this.myArgc += seenDigit;
    }

    private void addUnhandled(char b2) {
        if (this.myUnhandledChars == null) {
            this.myUnhandledChars = new ArrayList();
        }
        this.myUnhandledChars.add(Character.valueOf(b2));
    }

    public boolean pushBackReordered(TerminalDataStream channel) throws IOException {
        if (this.myUnhandledChars == null) {
            return false;
        }
        char[] bytes = new char[1024];
        int i2 = 0;
        for (char b2 : this.myUnhandledChars) {
            bytes[i2++] = b2;
        }
        bytes[i2++] = 27;
        bytes[i2++] = 91;
        if (this.myStartsWithExclamationMark) {
            bytes[i2++] = 33;
        }
        if (this.myStartsWithQuestionMark) {
            bytes[i2++] = 63;
        }
        if (this.myStartsWithMoreMark) {
            bytes[i2++] = 62;
        }
        for (int argi = 0; argi < this.myArgc; ++argi) {
            if (argi != 0) {
                bytes[i2++] = 59;
            }
            String s2 = Integer.toString(this.myArgv[argi]);
            for (int j2 = 0; j2 < s2.length(); ++j2) {
                bytes[i2++] = s2.charAt(j2);
            }
        }
        bytes[i2++] = this.myFinalChar;
        channel.pushBackBuffer(bytes, i2);
        return true;
    }

    int getCount() {
        return this.myArgc;
    }

    final int getArg(int index, int defaultValue) {
        if (index >= this.myArgc) {
            return defaultValue;
        }
        return this.myArgv[index];
    }

    private void appendToBuffer(StringBuilder sb) {
        sb.append("ESC[");
        if (this.myStartsWithExclamationMark) {
            sb.append("!");
        }
        if (this.myStartsWithQuestionMark) {
            sb.append("?");
        }
        if (this.myStartsWithMoreMark) {
            sb.append(">");
        }
        String sep = "";
        for (int i2 = 0; i2 < this.myArgc; ++i2) {
            sb.append(sep);
            sb.append(this.myArgv[i2]);
            sep = ";";
        }
        sb.append(this.myFinalChar);
        if (this.myUnhandledChars != null) {
            sb.append(" Unhandled:");
            CharUtils.CharacterType last = CharUtils.CharacterType.NONE;
            for (char b2 : this.myUnhandledChars) {
                last = CharUtils.appendChar(sb, last, b2);
            }
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.appendToBuffer(sb);
        return sb.toString();
    }

    public char getFinalChar() {
        return this.myFinalChar;
    }

    public boolean startsWithExclamationMark() {
        return this.myStartsWithExclamationMark;
    }

    public boolean startsWithQuestionMark() {
        return this.myStartsWithQuestionMark;
    }

    public boolean startsWithMoreMark() {
        return this.myStartsWithMoreMark;
    }

    @NotNull
    public String getDebugInfo() {
        StringBuilder sb = new StringBuilder();
        sb.append("parsed: ");
        this.appendToBuffer(sb);
        sb.append(", raw: ESC[");
        sb.append((CharSequence)this.mySequenceString);
        return sb.toString();
    }
}

