/*
 * Decompiled with CFR 0.152.
 */
package com.jediterm.terminal.emulator.charset;

import com.jediterm.terminal.emulator.charset.CharacterSet;
import org.jetbrains.annotations.NotNull;

public class GraphicSet {
    private final int myIndex;
    private CharacterSet myDesignation;

    public GraphicSet(int index) {
        if (index < 0 || index > 3) {
            throw new IllegalArgumentException("Invalid index!");
        }
        this.myIndex = index;
        this.myDesignation = CharacterSet.valueOf(index == 1 ? (char)'0' : 'B');
    }

    public CharacterSet getDesignation() {
        return this.myDesignation;
    }

    public int getIndex() {
        return this.myIndex;
    }

    public int map(char original, int index) {
        int result2 = this.myDesignation.map(index);
        if (result2 < 0) {
            result2 = original;
        }
        return result2;
    }

    public void setDesignation(@NotNull CharacterSet designation) {
        this.myDesignation = designation;
    }
}

