/*
 * Decompiled with CFR 0.152.
 */
package com.jediterm.terminal.model;

import com.jediterm.core.typeahead.Debouncer;
import com.jediterm.terminal.TerminalExecutorServiceManager;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public class JediTermDebouncerImpl
implements Debouncer {
    private final Object myLock = new Object();
    private final Runnable myRunnable;
    private final long myDelay;
    private final ScheduledExecutorService myScheduler;
    private TimerTask myTimerTask = null;

    public JediTermDebouncerImpl(@NotNull Runnable runnable2, long delay, @NotNull TerminalExecutorServiceManager executorServiceManager) {
        this.myRunnable = runnable2;
        this.myDelay = delay;
        this.myScheduler = executorServiceManager.getSingleThreadScheduledExecutor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void call() {
        Object object = this.myLock;
        synchronized (object) {
            if (this.myTimerTask != null) {
                this.myTimerTask.cancel();
            }
            this.myTimerTask = new TimerTask();
            this.myScheduler.schedule(this.myTimerTask, this.myDelay, TimeUnit.NANOSECONDS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void terminateCall() {
        Object object = this.myLock;
        synchronized (object) {
            if (this.myTimerTask != null) {
                this.myTimerTask.cancel();
                this.myTimerTask = null;
            }
        }
    }

    private class TimerTask
    implements Runnable {
        private final long myDueTime;
        private volatile boolean myIsActive = true;

        public TimerTask() {
            this.myDueTime = System.nanoTime() + JediTermDebouncerImpl.this.myDelay;
        }

        public void cancel() {
            this.myIsActive = false;
        }

        @Override
        public void run() {
            if (!this.myIsActive) {
                return;
            }
            long remaining = this.myDueTime - System.nanoTime();
            if (remaining > 0L) {
                JediTermDebouncerImpl.this.myScheduler.schedule(this, remaining, TimeUnit.NANOSECONDS);
            } else {
                this.myIsActive = false;
                JediTermDebouncerImpl.this.myRunnable.run();
            }
        }
    }
}

