/*
 * Decompiled with CFR 0.152.
 */
package com.jediterm.terminal.model;

import com.jediterm.core.compatibility.Point;
import com.jediterm.terminal.model.TerminalLine;
import com.jediterm.terminal.model.TerminalSelection;
import com.jediterm.terminal.model.TerminalTextBuffer;
import java.util.ArrayList;
import java.util.List;
import kotlin.Pair;
import org.jetbrains.annotations.NotNull;

public class SelectionUtil {
    private static final List<Character> SEPARATORS = new ArrayList<Character>();

    public static Pair<Point, Point> sortPoints(Point a2, Point b2) {
        if (a2.y == b2.y) {
            return new Pair((Object)(a2.x <= b2.x ? a2 : b2), (Object)(a2.x > b2.x ? a2 : b2));
        }
        return new Pair((Object)(a2.y < b2.y ? a2 : b2), (Object)(a2.y > b2.y ? a2 : b2));
    }

    public static String getSelectionText(TerminalSelection selection, TerminalTextBuffer terminalTextBuffer) {
        return SelectionUtil.getSelectionText(selection.getStart(), selection.getEnd(), terminalTextBuffer);
    }

    @NotNull
    public static String getSelectionText(@NotNull Point selectionStart, @NotNull Point selectionEnd, @NotNull TerminalTextBuffer terminalTextBuffer) {
        Pair<Point, Point> pair = SelectionUtil.sortPoints(selectionStart, selectionEnd);
        ((Point)pair.getFirst()).y = Math.max(((Point)pair.getFirst()).y, -terminalTextBuffer.getHistoryLinesCount());
        pair = SelectionUtil.sortPoints((Point)pair.getFirst(), (Point)pair.getSecond());
        Point top = (Point)pair.getFirst();
        Point bottom = (Point)pair.getSecond();
        StringBuilder selectionText = new StringBuilder();
        for (int i2 = top.y; i2 <= bottom.y; ++i2) {
            TerminalLine line = terminalTextBuffer.getLine(i2);
            String text = line.getText();
            if (i2 == top.y) {
                if (i2 == bottom.y) {
                    selectionText.append(SelectionUtil.processForSelection(text.substring(Math.min(text.length(), top.x), Math.min(text.length(), bottom.x))));
                } else {
                    selectionText.append(SelectionUtil.processForSelection(text.substring(Math.min(text.length(), top.x))));
                }
            } else if (i2 == bottom.y) {
                selectionText.append(SelectionUtil.processForSelection(text.substring(0, Math.min(text.length(), bottom.x))));
            } else {
                selectionText.append(SelectionUtil.processForSelection(line.getText()));
            }
            if ((line.isWrapped() || i2 >= bottom.y) && bottom.x <= text.length()) continue;
            selectionText.append("\n");
        }
        return selectionText.toString();
    }

    private static String processForSelection(String text) {
        if (text.indexOf(57344) != 0) {
            StringBuilder sb = new StringBuilder();
            for (char c2 : text.toCharArray()) {
                if (c2 == '\ue000') continue;
                sb.append(c2);
            }
            return sb.toString();
        }
        return text;
    }

    public static Point getPreviousSeparator(Point charCoords, TerminalTextBuffer terminalTextBuffer) {
        return SelectionUtil.getPreviousSeparator(charCoords, terminalTextBuffer, SEPARATORS);
    }

    public static Point getPreviousSeparator(Point charCoords, TerminalTextBuffer terminalTextBuffer, @NotNull List<Character> separators) {
        int x2 = charCoords.x;
        int y2 = charCoords.y;
        int terminalWidth = terminalTextBuffer.getWidth();
        if (separators.contains(Character.valueOf(terminalTextBuffer.getBuffersCharAt(x2, y2)))) {
            return new Point(x2, y2);
        }
        String line = terminalTextBuffer.getLine(y2).getText();
        while (x2 < line.length() && !separators.contains(Character.valueOf(line.charAt(x2)))) {
            if (--x2 >= 0) continue;
            if (y2 <= -terminalTextBuffer.getHistoryLinesCount()) {
                return new Point(0, y2);
            }
            x2 = terminalWidth - 1;
            line = terminalTextBuffer.getLine(--y2).getText();
        }
        if (++x2 >= terminalWidth) {
            ++y2;
            x2 = 0;
        }
        return new Point(x2, y2);
    }

    public static Point getNextSeparator(Point charCoords, TerminalTextBuffer terminalTextBuffer) {
        return SelectionUtil.getNextSeparator(charCoords, terminalTextBuffer, SEPARATORS);
    }

    public static Point getNextSeparator(Point charCoords, TerminalTextBuffer terminalTextBuffer, @NotNull List<Character> separators) {
        int x2 = charCoords.x;
        int y2 = charCoords.y;
        int terminalWidth = terminalTextBuffer.getWidth();
        int terminalHeight = terminalTextBuffer.getHeight();
        if (separators.contains(Character.valueOf(terminalTextBuffer.getBuffersCharAt(x2, y2)))) {
            return new Point(x2, y2);
        }
        String line = terminalTextBuffer.getLine(y2).getText();
        while (x2 < line.length() && !separators.contains(Character.valueOf(line.charAt(x2)))) {
            if (++x2 < terminalWidth) continue;
            if (y2 >= terminalHeight - 1) {
                return new Point(terminalWidth - 1, terminalHeight - 1);
            }
            x2 = 0;
            line = terminalTextBuffer.getLine(++y2).getText();
        }
        if (--x2 < 0) {
            --y2;
            x2 = terminalWidth - 1;
        }
        return new Point(x2, y2);
    }

    static {
        SEPARATORS.add(Character.valueOf(' '));
        SEPARATORS.add(Character.valueOf('\u00a0'));
        SEPARATORS.add(Character.valueOf('\t'));
        SEPARATORS.add(Character.valueOf('\''));
        SEPARATORS.add(Character.valueOf('\"'));
        SEPARATORS.add(Character.valueOf('$'));
        SEPARATORS.add(Character.valueOf('('));
        SEPARATORS.add(Character.valueOf(')'));
        SEPARATORS.add(Character.valueOf('['));
        SEPARATORS.add(Character.valueOf(']'));
        SEPARATORS.add(Character.valueOf('{'));
        SEPARATORS.add(Character.valueOf('}'));
        SEPARATORS.add(Character.valueOf('<'));
        SEPARATORS.add(Character.valueOf('>'));
    }
}

