/*
 * Decompiled with CFR 0.152.
 */
package com.jediterm.terminal.model;

import com.jediterm.terminal.StyledTextConsumer;
import com.jediterm.terminal.TextStyle;
import com.jediterm.terminal.model.CharBuffer;
import com.jediterm.terminal.model.SubCharBuffer;
import com.jediterm.terminal.model.TerminalLineIntervalHighlighting;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import kotlin.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TerminalLine {
    private static final Logger LOG = LoggerFactory.getLogger(TerminalLine.class);
    private TextEntries myTextEntries = new TextEntries();
    private boolean myWrapped = false;
    private final List<TerminalLineIntervalHighlighting> myCustomHighlightings = new CopyOnWriteArrayList<TerminalLineIntervalHighlighting>();
    private final AtomicInteger myModificationCount = new AtomicInteger(0);
    TerminalLine myTypeAheadLine;

    public TerminalLine() {
    }

    public TerminalLine(@NotNull TextEntry entry) {
        this.myTextEntries.add(entry);
    }

    public static TerminalLine createEmpty() {
        return new TerminalLine();
    }

    @NotNull
    public String getText() {
        StringBuilder result2 = new StringBuilder(this.myTextEntries.myLength);
        for (TextEntry textEntry : this.myTextEntries) {
            if (textEntry.getText().isNul()) break;
            result2.append(textEntry.getText());
        }
        return result2.toString();
    }

    @NotNull
    public TerminalLine copy() {
        TerminalLine result2 = new TerminalLine();
        for (TextEntry entry : this.myTextEntries) {
            result2.myTextEntries.add(entry);
        }
        result2.myWrapped = this.myWrapped;
        return result2;
    }

    public char charAt(int x2) {
        TerminalLine typeAheadLine = this.myTypeAheadLine;
        if (typeAheadLine != null) {
            return typeAheadLine.charAt(x2);
        }
        String text = this.getText();
        return x2 < text.length() ? text.charAt(x2) : (char)' ';
    }

    public int length() {
        return this.myTextEntries.length();
    }

    public boolean isWrapped() {
        return this.myWrapped;
    }

    public void setWrapped(boolean wrapped) {
        this.myWrapped = wrapped;
    }

    public void clear(@NotNull TextEntry filler) {
        this.myTextEntries.clear();
        this.myTextEntries.add(filler);
    }

    public void writeString(int x2, @NotNull CharBuffer str, @NotNull TextStyle style2) {
        this.writeCharacters(x2, style2, str);
    }

    public void insertString(int x2, @NotNull CharBuffer str, @NotNull TextStyle style2) {
        this.insertCharacters(x2, style2, str);
    }

    private void writeCharacters(int x2, @NotNull TextStyle style2, @NotNull CharBuffer characters) {
        int len = this.myTextEntries.length();
        if (x2 >= len) {
            if (x2 - len > 0) {
                this.myTextEntries.add(new TextEntry(TextStyle.EMPTY, new CharBuffer('\u0000', x2 - len)));
            }
            this.myTextEntries.add(new TextEntry(style2, characters));
        } else {
            len = Math.max(len, x2 + characters.length());
            this.myTextEntries = TerminalLine.merge(x2, characters, style2, this.myTextEntries, len);
        }
    }

    private void insertCharacters(int x2, @NotNull TextStyle style2, @NotNull CharBuffer characters) {
        int i2;
        int length = this.myTextEntries.length();
        if (x2 > length) {
            this.writeCharacters(x2, style2, characters);
            return;
        }
        Pair<char[], TextStyle[]> pair = TerminalLine.toBuf(this.myTextEntries, length + characters.length());
        for (i2 = length - 1; i2 >= x2; --i2) {
            ((char[])pair.getFirst())[i2 + characters.length()] = ((char[])pair.getFirst())[i2];
            ((TextStyle[])pair.getSecond())[i2 + characters.length()] = ((TextStyle[])pair.getSecond())[i2];
        }
        for (i2 = 0; i2 < characters.length(); ++i2) {
            ((char[])pair.getFirst())[i2 + x2] = characters.charAt(i2);
            ((TextStyle[])pair.getSecond())[i2 + x2] = style2;
        }
        this.myTextEntries = TerminalLine.collectFromBuffer((char[])pair.getFirst(), (TextStyle[])pair.getSecond());
    }

    private static TextEntries merge(int x2, @NotNull CharBuffer str, @NotNull TextStyle style2, @NotNull TextEntries entries2, int lineLength) {
        Pair<char[], TextStyle[]> pair = TerminalLine.toBuf(entries2, lineLength);
        for (int i2 = 0; i2 < str.length(); ++i2) {
            ((char[])pair.getFirst())[i2 + x2] = str.charAt(i2);
            ((TextStyle[])pair.getSecond())[i2 + x2] = style2;
        }
        return TerminalLine.collectFromBuffer((char[])pair.getFirst(), (TextStyle[])pair.getSecond());
    }

    private static Pair<char[], TextStyle[]> toBuf(TextEntries entries2, int lineLength) {
        Pair pair = new Pair((Object)new char[lineLength], (Object)new TextStyle[lineLength]);
        int p2 = 0;
        for (TextEntry entry : entries2) {
            for (int i2 = 0; i2 < entry.getLength(); ++i2) {
                ((char[])pair.getFirst())[p2 + i2] = entry.getText().charAt(i2);
                ((TextStyle[])pair.getSecond())[p2 + i2] = entry.getStyle();
            }
            p2 += entry.getLength();
        }
        return pair;
    }

    private static TextEntries collectFromBuffer(char[] buf, @NotNull TextStyle[] styles) {
        TextEntries result2 = new TextEntries();
        TextStyle curStyle = styles[0];
        int start = 0;
        for (int i2 = 1; i2 < buf.length; ++i2) {
            if (styles[i2] == curStyle) continue;
            result2.add(new TextEntry(curStyle, new CharBuffer(buf, start, i2 - start)));
            curStyle = styles[i2];
            start = i2;
        }
        result2.add(new TextEntry(curStyle, new CharBuffer(buf, start, buf.length - start)));
        return result2;
    }

    public void deleteCharacters(int x2) {
        this.deleteCharacters(x2, TextStyle.EMPTY);
    }

    public void deleteCharacters(int x2, @NotNull TextStyle style2) {
        this.deleteCharacters(x2, this.myTextEntries.length() - x2, style2);
    }

    public void deleteCharacters(int x2, int count, @NotNull TextStyle style2) {
        int p2 = 0;
        TextEntries newEntries = new TextEntries();
        int remaining = count;
        for (TextEntry entry : this.myTextEntries) {
            if (remaining == 0) {
                newEntries.add(entry);
                continue;
            }
            int len = entry.getLength();
            if (p2 + len <= x2) {
                p2 += len;
                newEntries.add(entry);
                continue;
            }
            int dx = x2 - p2;
            if (dx > 0) {
                newEntries.add(new TextEntry(entry.getStyle(), entry.getText().subBuffer(0, dx)));
                p2 = x2;
            }
            if (dx + remaining < len) {
                newEntries.add(new TextEntry(entry.getStyle(), entry.getText().subBuffer(dx + remaining, len - (dx + remaining))));
                remaining = 0;
                continue;
            }
            remaining -= len - dx;
            p2 = x2;
        }
        if (count > 0 && style2 != TextStyle.EMPTY) {
            newEntries.add(new TextEntry(style2, new CharBuffer('\u0000', count)));
        }
        this.myTextEntries = newEntries;
    }

    public void insertBlankCharacters(int x2, int count, int maxLen, @NotNull TextStyle style2) {
        int len = this.myTextEntries.length();
        len = Math.min(len + count, maxLen);
        char[] buf = new char[len];
        TextStyle[] styles = new TextStyle[len];
        int p2 = 0;
        for (TextEntry entry : this.myTextEntries) {
            for (int i2 = 0; i2 < entry.getLength() && p2 < len; ++i2) {
                if (p2 == x2) {
                    for (int j2 = 0; j2 < count && p2 < len; ++p2, ++j2) {
                        buf[p2] = 32;
                        styles[p2] = style2;
                    }
                }
                if (p2 >= len) continue;
                buf[p2] = entry.getText().charAt(i2);
                styles[p2] = entry.getStyle();
                ++p2;
            }
            if (p2 < len) continue;
            break;
        }
        while (p2 < x2 && p2 < len) {
            buf[p2] = 32;
            styles[p2] = TextStyle.EMPTY;
            ++p2;
            ++p2;
        }
        while (p2 < x2 + count && p2 < len) {
            buf[p2] = 32;
            styles[p2] = style2;
            ++p2;
            ++p2;
        }
        this.myTextEntries = TerminalLine.collectFromBuffer(buf, styles);
    }

    public void clearArea(int leftX, int rightX, @NotNull TextStyle style2) {
        if (rightX == -1) {
            rightX = Math.max(this.myTextEntries.length(), leftX);
        }
        this.writeCharacters(leftX, style2, new CharBuffer(rightX >= this.myTextEntries.length() ? (char)'\u0000' : ' ', rightX - leftX));
    }

    @Nullable
    public TextStyle getStyleAt(int x2) {
        int i2 = 0;
        for (TextEntry te : this.myTextEntries) {
            if (x2 >= i2 && x2 < i2 + te.getLength()) {
                return te.getStyle();
            }
            i2 += te.getLength();
        }
        return null;
    }

    public void process(int y2, StyledTextConsumer consumer, int startRow) {
        int x2 = 0;
        int nulIndex = -1;
        TerminalLineIntervalHighlighting highlighting = this.myCustomHighlightings.stream().findFirst().orElse(null);
        TerminalLine typeAheadLine = this.myTypeAheadLine;
        TextEntries textEntries = typeAheadLine != null ? typeAheadLine.myTextEntries : this.myTextEntries;
        for (TextEntry te : textEntries) {
            if (te.getText().isNul()) {
                if (nulIndex < 0) {
                    nulIndex = x2;
                }
                consumer.consumeNul(x2, y2, nulIndex, te.getStyle(), te.getText(), startRow);
            } else if (highlighting != null && te.getLength() > 0 && highlighting.intersectsWith(x2, x2 + te.getLength())) {
                this.processIntersection(x2, y2, te, consumer, startRow, highlighting);
            } else {
                consumer.consume(x2, y2, te.getStyle(), te.getText(), startRow);
            }
            x2 += te.getLength();
        }
        consumer.consumeQueue(x2, y2, nulIndex < 0 ? x2 : nulIndex, startRow);
    }

    private void processIntersection(int startTextOffset, int y2, @NotNull TextEntry te, @NotNull StyledTextConsumer consumer, int startRow, @NotNull TerminalLineIntervalHighlighting highlighting) {
        CharBuffer text = te.getText();
        int endTextOffset = startTextOffset + text.length();
        int[] offsets = new int[]{startTextOffset, endTextOffset, highlighting.getStartOffset(), highlighting.getEndOffset()};
        Arrays.sort(offsets);
        int startTextOffsetInd = Arrays.binarySearch(offsets, startTextOffset);
        int endTextOffsetInd = Arrays.binarySearch(offsets, endTextOffset);
        if (startTextOffsetInd < 0 || endTextOffsetInd < 0) {
            LOG.error("Cannot find " + Arrays.toString(new int[]{startTextOffset, endTextOffset}) + " in " + Arrays.toString(offsets) + ": " + Arrays.toString(new int[]{startTextOffsetInd, endTextOffsetInd}));
            consumer.consume(startTextOffset, y2, te.getStyle(), text, startRow);
            return;
        }
        for (int i2 = startTextOffsetInd; i2 < endTextOffsetInd; ++i2) {
            int length = offsets[i2 + 1] - offsets[i2];
            if (length == 0) continue;
            SubCharBuffer subText = new SubCharBuffer(text, offsets[i2] - startTextOffset, length);
            if (highlighting.intersectsWith(offsets[i2], offsets[i2 + 1])) {
                consumer.consume(offsets[i2], y2, highlighting.mergeWith(te.getStyle()), subText, startRow);
                continue;
            }
            consumer.consume(offsets[i2], y2, te.getStyle(), subText, startRow);
        }
    }

    public boolean isNul() {
        for (TextEntry e2 : this.myTextEntries) {
            if (e2.isNul()) continue;
            return false;
        }
        return true;
    }

    public boolean isEmpty() {
        for (TextEntry e2 : this.myTextEntries) {
            if (e2.isNul() || e2.getLength() <= 0) continue;
            return false;
        }
        return true;
    }

    public boolean isNulOrEmpty() {
        return this.isNul() || this.isEmpty();
    }

    public void forEachEntry(@NotNull Consumer<TextEntry> action) {
        this.myTextEntries.forEach(action);
    }

    @NotNull
    public List<TextEntry> getEntries() {
        return Collections.unmodifiableList(this.myTextEntries.entries());
    }

    void appendEntry(@NotNull TextEntry entry) {
        this.myTextEntries.add(entry);
    }

    int getModificationCount() {
        return this.myModificationCount.get();
    }

    void incrementAndGetModificationCount() {
        this.myModificationCount.incrementAndGet();
    }

    @NotNull
    public TerminalLineIntervalHighlighting addCustomHighlighting(int startOffset, int length, @NotNull TextStyle textStyle) {
        TerminalLineIntervalHighlighting highlighting = new TerminalLineIntervalHighlighting(this, startOffset, length, textStyle){

            @Override
            protected void doDispose() {
                TerminalLine.this.myCustomHighlightings.remove(this);
            }
        };
        this.myCustomHighlightings.add(highlighting);
        return highlighting;
    }

    public String toString() {
        return this.myTextEntries.length() + " chars, " + (this.myWrapped ? "wrapped, " : "") + this.myTextEntries.myTextEntries.size() + " entries: " + this.myTextEntries.myTextEntries.stream().map(entry -> entry.getText().toString()).collect(Collectors.joining("|"));
    }

    private static class TextEntries
    implements Iterable<TextEntry> {
        private final List<TextEntry> myTextEntries = new ArrayList<TextEntry>();
        private int myLength = 0;

        private TextEntries() {
        }

        public void add(TextEntry entry) {
            if (!entry.getText().isNul()) {
                for (TextEntry t2 : this.myTextEntries) {
                    if (!t2.getText().isNul()) continue;
                    t2.getText().unNullify();
                }
            }
            this.myTextEntries.add(entry);
            this.myLength += entry.getLength();
        }

        private List<TextEntry> entries() {
            return this.myTextEntries;
        }

        @Override
        @NotNull
        public Iterator<TextEntry> iterator() {
            return this.myTextEntries.iterator();
        }

        public int length() {
            return this.myLength;
        }

        public void clear() {
            this.myTextEntries.clear();
            this.myLength = 0;
        }
    }

    public static class TextEntry {
        private final TextStyle myStyle;
        private final CharBuffer myText;

        public TextEntry(@NotNull TextStyle style2, @NotNull CharBuffer text) {
            this.myStyle = style2;
            this.myText = text.clone();
        }

        public TextStyle getStyle() {
            return this.myStyle;
        }

        public CharBuffer getText() {
            return this.myText;
        }

        public int getLength() {
            return this.myText.length();
        }

        public boolean isNul() {
            return this.myText.isNul();
        }

        public String toString() {
            return this.myText.length() + " chars, style: " + this.myStyle + ", text: " + this.myText;
        }
    }
}

