/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cef.remote;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.ParameterizedType;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.function.Predicate;
import org.cef.misc.CefLog;
import org.cef.misc.Utils;

public class RemoteJavaObjectFactory<T> {
    private static boolean DEBUG = Utils.getBoolean("JCEF_DEBUG_REMOTE_JAVA_OBJECTS");
    private final Map<Integer, T> INSTANCES = new ConcurrentHashMap<Integer, T>();
    private AtomicInteger COUNTER = new AtomicInteger(0);

    public T create(Function<Integer, T> creator) {
        int newId = this.COUNTER.getAndIncrement();
        T result2 = creator.apply(newId);
        this.INSTANCES.put(newId, result2);
        return result2;
    }

    public T find(int id) {
        return this.INSTANCES.get(id);
    }

    public T find(Predicate<T> predicate) {
        for (T inst : this.INSTANCES.values()) {
            if (!predicate.test(inst)) continue;
            return inst;
        }
        return null;
    }

    public T get(int id) {
        T result2 = this.INSTANCES.get(id);
        if (result2 == null && DEBUG) {
            StringWriter sw = new StringWriter();
            new Throwable().printStackTrace(new PrintWriter(sw));
            CefLog.Error("Can't find instance in '%s' by id %d, stacktrace:\n%s", this.INSTANCES, id, sw.getBuffer().toString());
        }
        return result2;
    }

    public void dispose(int id) {
        this.INSTANCES.remove(id);
    }

    protected String getGenericName() {
        return ((Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0]).getTypeName();
    }
}

