/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cef.remote.network;

import com.jetbrains.cef.remote.RemoteServerObject;
import com.jetbrains.cef.remote.RpcContext;
import com.jetbrains.cef.remote.callback.RemoteCompletionCallback;
import com.jetbrains.cef.remote.network.RemoteCookieManager;
import com.jetbrains.cef.remote.network.RemoteCookieVisitor;
import com.jetbrains.cef.remote.thrift_codegen.RObject;
import org.cef.callback.CefCompletionCallback;
import org.cef.callback.CefCookieVisitor;
import org.cef.misc.CefLog;
import org.cef.network.CefCookie;

public class RemoteCookieManagerImpl
extends RemoteServerObject {
    private RemoteCookieManagerImpl(RpcContext rpcContext, RObject robj) {
        super(rpcContext, robj);
    }

    public static RemoteCookieManagerImpl create(RpcContext rpcContext) {
        RObject robj = rpcContext.execObj(s2 -> s2.CookieManager_Create());
        if (robj.isNull) {
            CefLog.Error("CookieManager_Create returns invalid objId %d.", robj.objId);
            return null;
        }
        return new RemoteCookieManagerImpl(rpcContext, robj);
    }

    @Override
    protected void disposeOnServerImpl() {
        RObject id = this.thriftId();
        this.myRpc.invokeLater(s2 -> s2.CookieManager_Dispose(id));
    }

    @Override
    public void flush() {
    }

    public boolean visitAllCookies(CefCookieVisitor visitor) {
        if (visitor == null) {
            return false;
        }
        RemoteCookieVisitor rvisitor = RemoteCookieVisitor.create(visitor);
        return this.myRpc.execObj(s2 -> s2.CookieManager_VisitAllCookies(this.thriftId(), rvisitor.thriftId()));
    }

    public boolean visitUrlCookies(String url, boolean includeHttpOnly, CefCookieVisitor visitor) {
        if (visitor == null) {
            return false;
        }
        RemoteCookieVisitor rvisitor = RemoteCookieVisitor.create(visitor);
        return this.myRpc.execObj(s2 -> s2.CookieManager_VisitUrlCookies(this.thriftId(), rvisitor.thriftId(), url, includeHttpOnly));
    }

    public boolean setCookie(String url, CefCookie cookie) {
        return this.myRpc.execObj(s2 -> s2.CookieManager_SetCookie(this.thriftId(), url, RemoteCookieManager.toThriftCookie(cookie)));
    }

    public boolean deleteCookies(String url, String cookieName) {
        return this.myRpc.execObj(s2 -> s2.CookieManager_DeleteCookies(this.thriftId(), url, cookieName));
    }

    public boolean flushStore(CefCompletionCallback callback) {
        RObject cbId = callback != null ? RemoteCompletionCallback.create(callback).thriftId() : new RObject();
        return this.myRpc.execObj(s2 -> s2.CookieManager_FlushStore(this.thriftId(), cbId));
    }
}

