/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cef.remote.thrift.protocol;

import com.jetbrains.cef.remote.thrift.TException;
import com.jetbrains.cef.remote.thrift.protocol.TBinaryProtocol;
import com.jetbrains.cef.remote.thrift.protocol.TCompactProtocol;
import com.jetbrains.cef.remote.thrift.protocol.TField;
import com.jetbrains.cef.remote.thrift.protocol.TJSONProtocol;
import com.jetbrains.cef.remote.thrift.protocol.TList;
import com.jetbrains.cef.remote.thrift.protocol.TMap;
import com.jetbrains.cef.remote.thrift.protocol.TProtocol;
import com.jetbrains.cef.remote.thrift.protocol.TProtocolException;
import com.jetbrains.cef.remote.thrift.protocol.TProtocolFactory;
import com.jetbrains.cef.remote.thrift.protocol.TSet;

public class TProtocolUtil {
    private static int maxSkipDepth = Integer.MAX_VALUE;

    private TProtocolUtil() {
    }

    public static void setMaxSkipDepth(int depth) {
        maxSkipDepth = depth;
    }

    public static void skip(TProtocol prot, byte type) throws TException {
        TProtocolUtil.skip(prot, type, maxSkipDepth);
    }

    public static void skip(TProtocol prot, byte type, int maxDepth) throws TException {
        if (maxDepth <= 0) {
            throw new TException("Maximum skip depth exceeded");
        }
        switch (type) {
            case 2: {
                prot.readBool();
                break;
            }
            case 3: {
                prot.readByte();
                break;
            }
            case 6: {
                prot.readI16();
                break;
            }
            case 8: {
                prot.readI32();
                break;
            }
            case 10: {
                prot.readI64();
                break;
            }
            case 16: {
                prot.readUuid();
                break;
            }
            case 4: {
                prot.readDouble();
                break;
            }
            case 11: {
                prot.readBinary();
                break;
            }
            case 12: {
                prot.readStructBegin();
                while (true) {
                    TField field = prot.readFieldBegin();
                    if (field.type == 0) break;
                    TProtocolUtil.skip(prot, field.type, maxDepth - 1);
                    prot.readFieldEnd();
                }
                prot.readStructEnd();
                break;
            }
            case 13: {
                TMap map2 = prot.readMapBegin();
                for (int i2 = 0; i2 < map2.size; ++i2) {
                    TProtocolUtil.skip(prot, map2.keyType, maxDepth - 1);
                    TProtocolUtil.skip(prot, map2.valueType, maxDepth - 1);
                }
                prot.readMapEnd();
                break;
            }
            case 14: {
                TSet set2 = prot.readSetBegin();
                for (int i3 = 0; i3 < set2.size; ++i3) {
                    TProtocolUtil.skip(prot, set2.elemType, maxDepth - 1);
                }
                prot.readSetEnd();
                break;
            }
            case 15: {
                TList list = prot.readListBegin();
                for (int i4 = 0; i4 < list.size; ++i4) {
                    TProtocolUtil.skip(prot, list.elemType, maxDepth - 1);
                }
                prot.readListEnd();
                break;
            }
            default: {
                throw new TProtocolException(1, "Unrecognized type " + type);
            }
        }
    }

    public static TProtocolFactory guessProtocolFactory(byte[] data, TProtocolFactory fallback) {
        if (123 == data[0] && 125 == data[data.length - 1]) {
            return new TJSONProtocol.Factory();
        }
        if (data[data.length - 1] != 0) {
            return new TBinaryProtocol.Factory();
        }
        if (data[0] > 16) {
            return new TCompactProtocol.Factory();
        }
        if (data.length > 1 && 0 == data[1]) {
            return new TBinaryProtocol.Factory();
        }
        if (data.length > 1 && (data[1] & 0x80) != 0) {
            return new TCompactProtocol.Factory();
        }
        return fallback;
    }
}

