/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cef.remote.thrift.server;

import com.jetbrains.cef.remote.thrift.Logger;
import com.jetbrains.cef.remote.thrift.LoggerFactory;
import com.jetbrains.cef.remote.thrift.TException;
import com.jetbrains.cef.remote.thrift.TProcessor;
import com.jetbrains.cef.remote.thrift.protocol.TProtocol;
import com.jetbrains.cef.remote.thrift.server.ServerContext;
import com.jetbrains.cef.remote.thrift.server.TServer;
import com.jetbrains.cef.remote.thrift.transport.TTransport;
import com.jetbrains.cef.remote.thrift.transport.TTransportException;

public class TSimpleServer
extends TServer {
    private static final Logger LOGGER = LoggerFactory.getLogger(TSimpleServer.class.getName());

    public TSimpleServer(TServer.AbstractServerArgs args) {
        super(args);
    }

    @Override
    public void serve() {
        try {
            this.serverTransport_.listen();
        }
        catch (TTransportException ttx) {
            LOGGER.error("Error occurred during listening.", ttx);
            return;
        }
        if (this.eventHandler_ != null) {
            this.eventHandler_.preServe();
        }
        this.setServing(true);
        while (!this.stopped_) {
            ServerContext connectionContext;
            TProtocol outputProtocol;
            TProtocol inputProtocol;
            TTransport outputTransport;
            TTransport inputTransport;
            block15: {
                TTransport client2 = null;
                TProcessor processor2 = null;
                inputTransport = null;
                outputTransport = null;
                inputProtocol = null;
                outputProtocol = null;
                connectionContext = null;
                try {
                    client2 = this.serverTransport_.accept();
                    if (client2 != null) {
                        processor2 = this.processorFactory_.getProcessor(client2);
                        inputTransport = this.inputTransportFactory_.getTransport(client2);
                        outputTransport = this.outputTransportFactory_.getTransport(client2);
                        inputProtocol = this.inputProtocolFactory_.getProtocol(inputTransport);
                        outputProtocol = this.outputProtocolFactory_.getProtocol(outputTransport);
                        if (this.eventHandler_ != null) {
                            connectionContext = this.eventHandler_.createContext(inputProtocol, outputProtocol);
                        }
                        while (true) {
                            if (this.eventHandler_ != null) {
                                this.eventHandler_.processContext(connectionContext, inputTransport, outputTransport);
                            }
                            processor2.process(inputProtocol, outputProtocol);
                        }
                    }
                }
                catch (TTransportException ttx) {
                    LOGGER.debug("Client Transportation Exception", ttx);
                }
                catch (TException tx) {
                    if (!this.stopped_) {
                        LOGGER.error("Thrift error occurred during processing of message.", tx);
                    }
                }
                catch (Exception x2) {
                    if (this.stopped_) break block15;
                    LOGGER.error("Error occurred during processing of message.", x2);
                }
            }
            if (this.eventHandler_ != null) {
                this.eventHandler_.deleteContext(connectionContext, inputProtocol, outputProtocol);
            }
            if (inputTransport != null) {
                inputTransport.close();
            }
            if (outputTransport == null) continue;
            outputTransport.close();
        }
        this.setServing(false);
    }

    @Override
    public void stop() {
        this.stopped_ = true;
        this.serverTransport_.interrupt();
    }
}

