/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.fus.reporting.configuration;

import com.jetbrains.fus.reporting.configuration.ConfigurationClient;
import com.jetbrains.fus.reporting.configuration.LocalConfigurationClient;
import com.jetbrains.fus.reporting.configuration.RegionCode;
import com.jetbrains.fus.reporting.configuration.RemoteConfigurationClient;
import com.jetbrains.fus.reporting.model.http.HttpClientBuilder;
import com.jetbrains.fus.reporting.model.http.HttpRequestBuilder;
import com.jetbrains.fus.reporting.model.serialization.Serializer;
import java.io.Reader;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lcom/jetbrains/fus/reporting/configuration/ConfigurationClientFactory;", "", "()V", "Companion", "configuration"})
public final class ConfigurationClientFactory {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @JvmStatic
    @NotNull
    public static final ConfigurationClient create(@NotNull String recorderId, @NotNull String productCode, @NotNull String productVersion, boolean isTestConfiguration, @NotNull HttpClientBuilder httpClientBuilder, @NotNull HttpRequestBuilder httpRequestBuilder, @NotNull RegionCode regionCode, long cacheTimeoutMs, @NotNull Serializer serializer2) {
        return Companion.create(recorderId, productCode, productVersion, isTestConfiguration, httpClientBuilder, httpRequestBuilder, regionCode, cacheTimeoutMs, serializer2);
    }

    @JvmStatic
    @NotNull
    public static final ConfigurationClient create(@NotNull Reader reader, @NotNull String productCode, @NotNull String productVersion, @NotNull Serializer serializer2) {
        return Companion.create(reader, productCode, productVersion, serializer2);
    }

    @JvmStatic
    @NotNull
    public static final ConfigurationClient createTest(@NotNull String productCode, @NotNull String productVersion, @NotNull HttpClientBuilder httpClientBuilder, @NotNull HttpRequestBuilder httpRequestBuilder, @NotNull String configurationUrl, long cacheTimeoutMs, @NotNull Serializer serializer2) {
        return Companion.createTest(productCode, productVersion, httpClientBuilder, httpRequestBuilder, configurationUrl, cacheTimeoutMs, serializer2);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bH\u0007JT\u0010\u0003\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\b\b\u0002\u0010\u0013\u001a\u00020\u00142\b\b\u0002\u0010\u0015\u001a\u00020\u00162\u0006\u0010\n\u001a\u00020\u000bH\u0007JP\u0010\u0017\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\n\u001a\u00020\u000bH\u0002JB\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\b2\b\b\u0002\u0010\u0015\u001a\u00020\u00162\u0006\u0010\n\u001a\u00020\u000bH\u0007\u00a8\u0006\u001a"}, d2={"Lcom/jetbrains/fus/reporting/configuration/ConfigurationClientFactory$Companion;", "", "()V", "create", "Lcom/jetbrains/fus/reporting/configuration/ConfigurationClient;", "reader", "Ljava/io/Reader;", "productCode", "", "productVersion", "serializer", "Lcom/jetbrains/fus/reporting/model/serialization/Serializer;", "recorderId", "isTestConfiguration", "", "httpClientBuilder", "Lcom/jetbrains/fus/reporting/model/http/HttpClientBuilder;", "httpRequestBuilder", "Lcom/jetbrains/fus/reporting/model/http/HttpRequestBuilder;", "regionCode", "Lcom/jetbrains/fus/reporting/configuration/RegionCode;", "cacheTimeoutMs", "", "createConfigurationClient", "createTest", "configurationUrl", "configuration"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final ConfigurationClient create(@NotNull String recorderId, @NotNull String productCode, @NotNull String productVersion, boolean isTestConfiguration, @NotNull HttpClientBuilder httpClientBuilder, @NotNull HttpRequestBuilder httpRequestBuilder, @NotNull RegionCode regionCode, long cacheTimeoutMs, @NotNull Serializer serializer2) {
            Intrinsics.checkNotNullParameter((Object)recorderId, (String)"recorderId");
            Intrinsics.checkNotNullParameter((Object)productCode, (String)"productCode");
            Intrinsics.checkNotNullParameter((Object)productVersion, (String)"productVersion");
            Intrinsics.checkNotNullParameter((Object)httpClientBuilder, (String)"httpClientBuilder");
            Intrinsics.checkNotNullParameter((Object)httpRequestBuilder, (String)"httpRequestBuilder");
            Intrinsics.checkNotNullParameter((Object)((Object)regionCode), (String)"regionCode");
            Intrinsics.checkNotNullParameter((Object)serializer2, (String)"serializer");
            return this.createConfigurationClient(recorderId, productCode, productVersion, isTestConfiguration, httpClientBuilder, httpRequestBuilder, regionCode, cacheTimeoutMs, serializer2);
        }

        public static /* synthetic */ ConfigurationClient create$default(Companion companion, String string2, String string3, String string4, boolean bl2, HttpClientBuilder httpClientBuilder, HttpRequestBuilder httpRequestBuilder, RegionCode regionCode, long l2, Serializer serializer2, int n2, Object object) {
            if ((n2 & 0x40) != 0) {
                regionCode = RegionCode.ALL;
            }
            if ((n2 & 0x80) != 0) {
                l2 = TimeUnit.MINUTES.toMillis(10L);
            }
            return companion.create(string2, string3, string4, bl2, httpClientBuilder, httpRequestBuilder, regionCode, l2, serializer2);
        }

        private final ConfigurationClient createConfigurationClient(String recorderId, String productCode, String productVersion, boolean isTestConfiguration, HttpClientBuilder httpClientBuilder, HttpRequestBuilder httpRequestBuilder, RegionCode regionCode, long cacheTimeoutMs, Serializer serializer2) {
            String string2;
            Object[] objectArray;
            String string3;
            if (isTestConfiguration) {
                string3 = regionCode.getEventLogSettingsURLTemplate();
                objectArray = new Object[]{"test/" + recorderId, productCode};
                String string4 = String.format(string3, Arrays.copyOf(objectArray, objectArray.length));
                string2 = string4;
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"format(...)");
            } else {
                string3 = regionCode.getEventLogSettingsURLTemplate();
                objectArray = new Object[]{recorderId, productCode};
                String string5 = String.format(string3, Arrays.copyOf(objectArray, objectArray.length));
                string2 = string5;
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"format(...)");
            }
            String configurationUrl = string2;
            return new RemoteConfigurationClient(configurationUrl, productCode, productVersion, httpClientBuilder.newClient(configurationUrl), httpRequestBuilder.newGetRequest(configurationUrl), serializer2, cacheTimeoutMs);
        }

        @JvmStatic
        @NotNull
        public final ConfigurationClient create(@NotNull Reader reader, @NotNull String productCode, @NotNull String productVersion, @NotNull Serializer serializer2) {
            Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
            Intrinsics.checkNotNullParameter((Object)productCode, (String)"productCode");
            Intrinsics.checkNotNullParameter((Object)productVersion, (String)"productVersion");
            Intrinsics.checkNotNullParameter((Object)serializer2, (String)"serializer");
            return new LocalConfigurationClient(reader, productCode, productVersion, serializer2);
        }

        @JvmStatic
        @NotNull
        public final ConfigurationClient createTest(@NotNull String productCode, @NotNull String productVersion, @NotNull HttpClientBuilder httpClientBuilder, @NotNull HttpRequestBuilder httpRequestBuilder, @NotNull String configurationUrl, long cacheTimeoutMs, @NotNull Serializer serializer2) {
            Intrinsics.checkNotNullParameter((Object)productCode, (String)"productCode");
            Intrinsics.checkNotNullParameter((Object)productVersion, (String)"productVersion");
            Intrinsics.checkNotNullParameter((Object)httpClientBuilder, (String)"httpClientBuilder");
            Intrinsics.checkNotNullParameter((Object)httpRequestBuilder, (String)"httpRequestBuilder");
            Intrinsics.checkNotNullParameter((Object)configurationUrl, (String)"configurationUrl");
            Intrinsics.checkNotNullParameter((Object)serializer2, (String)"serializer");
            return new RemoteConfigurationClient(configurationUrl, productCode, productVersion, httpClientBuilder.newClient(configurationUrl), httpRequestBuilder.newGetRequest(configurationUrl), serializer2, cacheTimeoutMs);
        }

        public static /* synthetic */ ConfigurationClient createTest$default(Companion companion, String string2, String string3, HttpClientBuilder httpClientBuilder, HttpRequestBuilder httpRequestBuilder, String string4, long l2, Serializer serializer2, int n2, Object object) {
            if ((n2 & 0x20) != 0) {
                l2 = TimeUnit.MINUTES.toMillis(10L);
            }
            return companion.createTest(string2, string3, httpClientBuilder, httpRequestBuilder, string4, l2, serializer2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

