/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.xstream.converters.reflection;

import com.thoughtworks.xstream.converters.ConversionException;
import com.thoughtworks.xstream.converters.ErrorWritingException;
import com.thoughtworks.xstream.converters.reflection.FieldDictionary;
import com.thoughtworks.xstream.converters.reflection.ObjectAccessException;
import com.thoughtworks.xstream.converters.reflection.PureJavaReflectionProvider;
import java.lang.reflect.Field;
import sun.misc.Unsafe;

public class SunLimitedUnsafeReflectionProvider
extends PureJavaReflectionProvider {
    protected static final Unsafe unsafe;
    protected static final Exception exception;

    public SunLimitedUnsafeReflectionProvider() {
    }

    public SunLimitedUnsafeReflectionProvider(FieldDictionary fieldDictionary) {
        super(fieldDictionary);
    }

    public Object newInstance(Class type) {
        if (exception != null) {
            ObjectAccessException ex2 = new ObjectAccessException("Cannot construct type", exception);
            ex2.add("construction-type", type.getName());
            throw ex2;
        }
        ErrorWritingException ex3 = null;
        if (type == Void.TYPE || type == Void.class) {
            ex3 = new ConversionException("Security alert: Marshalling rejected");
        } else {
            try {
                return unsafe.allocateInstance(type);
            }
            catch (SecurityException e2) {
                ex3 = new ObjectAccessException("Cannot construct type", e2);
            }
            catch (InstantiationException e3) {
                ex3 = new ConversionException("Cannot construct type", e3);
            }
            catch (IllegalArgumentException e4) {
                ex3 = new ObjectAccessException("Cannot construct type", e4);
            }
        }
        ex3.add("construction-type", type.getName());
        throw ex3;
    }

    protected void validateFieldAccess(Field field) {
    }

    private Object readResolve() {
        this.init();
        return this;
    }

    static {
        Unsafe u2 = null;
        Exception ex2 = null;
        try {
            Field unsafeField = Unsafe.class.getDeclaredField("theUnsafe");
            unsafeField.setAccessible(true);
            u2 = (Unsafe)unsafeField.get(null);
        }
        catch (SecurityException e2) {
            ex2 = e2;
        }
        catch (NoSuchFieldException e3) {
            ex2 = e3;
        }
        catch (IllegalArgumentException e4) {
            ex2 = e4;
        }
        catch (IllegalAccessException e5) {
            ex2 = e5;
        }
        exception = ex2;
        unsafe = u2;
    }
}

