/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.xstream.core.util;

import com.thoughtworks.xstream.core.StringCodec;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;

public class Base64Encoder
implements StringCodec {
    private static final char[] SIXTY_FOUR_CHARS = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/".toCharArray();
    private static final int[] REVERSE_MAPPING = new int[123];
    private final boolean lineBreaks;

    public Base64Encoder() {
        this(false);
    }

    public Base64Encoder(boolean lineBreaks) {
        this.lineBreaks = lineBreaks;
    }

    public String encode(byte[] input2) {
        int stringSize = this.computeResultingStringSize(input2);
        StringBuffer result2 = new StringBuffer(stringSize);
        int outputCharCount = 0;
        for (int i2 = 0; i2 < input2.length; i2 += 3) {
            int remaining = Math.min(3, input2.length - i2);
            int oneBigNumber = (input2[i2] & 0xFF) << 16 | (remaining <= 1 ? 0 : input2[i2 + 1] & 0xFF) << 8 | (remaining <= 2 ? 0 : input2[i2 + 2] & 0xFF);
            for (int j2 = 0; j2 < 4; ++j2) {
                result2.append(remaining + 1 > j2 ? SIXTY_FOUR_CHARS[0x3F & oneBigNumber >> 6 * (3 - j2)] : (char)'=');
            }
            if (!this.lineBreaks || (outputCharCount += 4) % 76 != 0 || i2 + 3 >= input2.length) continue;
            result2.append('\n');
        }
        String s2 = result2.toString();
        return s2;
    }

    int computeResultingStringSize(byte[] input2) {
        int stringSize = input2.length / 3 + (input2.length % 3 == 0 ? 0 : 1);
        stringSize *= 4;
        if (this.lineBreaks) {
            stringSize += stringSize / 76;
        }
        return stringSize;
    }

    public byte[] decode(String input2) {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            StringReader in = new StringReader(input2);
            for (int i2 = 0; i2 < input2.length(); i2 += 4) {
                int[] a2 = new int[]{this.mapCharToInt(in), this.mapCharToInt(in), this.mapCharToInt(in), this.mapCharToInt(in)};
                int oneBigNumber = (a2[0] & 0x3F) << 18 | (a2[1] & 0x3F) << 12 | (a2[2] & 0x3F) << 6 | a2[3] & 0x3F;
                for (int j2 = 0; j2 < 3; ++j2) {
                    if (a2[j2 + 1] < 0) continue;
                    out.write(0xFF & oneBigNumber >> 8 * (2 - j2));
                }
            }
            return out.toByteArray();
        }
        catch (IOException e2) {
            throw new Error(e2 + ": " + e2.getMessage());
        }
    }

    private int mapCharToInt(Reader input2) throws IOException {
        int c2;
        while ((c2 = input2.read()) != -1) {
            int result2 = REVERSE_MAPPING[c2];
            if (result2 != 0) {
                return result2 - 1;
            }
            if (c2 != 61) continue;
            return -1;
        }
        return -1;
    }

    static {
        for (int i2 = 0; i2 < SIXTY_FOUR_CHARS.length; ++i2) {
            Base64Encoder.REVERSE_MAPPING[Base64Encoder.SIXTY_FOUR_CHARS[i2]] = i2 + 1;
        }
    }
}

