/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.xstream.core.util;

import com.thoughtworks.xstream.converters.ConversionException;
import com.thoughtworks.xstream.converters.ErrorWritingException;
import com.thoughtworks.xstream.converters.reflection.ObjectAccessException;
import com.thoughtworks.xstream.core.Caching;
import com.thoughtworks.xstream.core.util.MemberStore;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class SerializationMembers
implements Caching {
    private static final Method NO_METHOD = NO_METHOD_MARKER.class.getDeclaredMethods()[0];
    private static final Object[] EMPTY_ARGS = new Object[0];
    private static final Class[] EMPTY_CLASSES = new Class[0];
    private static final ObjectStreamField[] NO_FIELDS = new ObjectStreamField[0];
    private static final int PERSISTENT_FIELDS_MODIFIER = 26;
    private static final String[] OBJECT_TYPE_FIELDS = new String[]{"readResolve", "writeReplace", "readObject", "writeObject"};
    private final MemberStore declaredCache = MemberStore.newSynchronizedInstance();
    private final MemberStore resRepCache = MemberStore.newSynchronizedInstance();
    private final Map fieldCache = Collections.synchronizedMap(new HashMap());

    public SerializationMembers() {
        int i2;
        for (i2 = 0; i2 < OBJECT_TYPE_FIELDS.length; ++i2) {
            this.declaredCache.put(class$java$lang$Object == null ? SerializationMembers.class$("java.lang.Object") : class$java$lang$Object, OBJECT_TYPE_FIELDS[i2], NO_METHOD);
        }
        for (i2 = 0; i2 < 2; ++i2) {
            this.resRepCache.put(class$java$lang$Object == null ? SerializationMembers.class$("java.lang.Object") : class$java$lang$Object, OBJECT_TYPE_FIELDS[i2], NO_METHOD);
        }
    }

    public Object callReadResolve(Object result2) {
        if (result2 == null) {
            return null;
        }
        Class<?> resultType = result2.getClass();
        Method readResolveMethod = this.getRRMethod(resultType, "readResolve");
        if (readResolveMethod != null) {
            ErrorWritingException ex2 = null;
            try {
                return readResolveMethod.invoke(result2, EMPTY_ARGS);
            }
            catch (IllegalAccessException e2) {
                ex2 = new ObjectAccessException("Cannot access method", e2);
            }
            catch (InvocationTargetException e3) {
                ex2 = new ConversionException("Failed calling method", e3.getTargetException());
            }
            ex2.add("method", resultType.getName() + ".readResolve()");
            throw ex2;
        }
        return result2;
    }

    public Object callWriteReplace(Object object) {
        if (object == null) {
            return null;
        }
        Class<?> objectType = object.getClass();
        Method writeReplaceMethod = this.getRRMethod(objectType, "writeReplace");
        if (writeReplaceMethod != null) {
            ErrorWritingException ex2 = null;
            try {
                Object replaced = writeReplaceMethod.invoke(object, EMPTY_ARGS);
                if (replaced != null && !object.getClass().equals(replaced.getClass())) {
                    replaced = this.callWriteReplace(replaced);
                }
                return replaced;
            }
            catch (IllegalAccessException e2) {
                ex2 = new ObjectAccessException("Cannot access method", e2);
            }
            catch (InvocationTargetException e3) {
                ex2 = new ConversionException("Failed calling method", e3.getTargetException());
            }
            catch (ErrorWritingException e4) {
                ex2 = e4;
            }
            ex2.add("method", objectType.getName() + ".writeReplace()");
            throw ex2;
        }
        return object;
    }

    public boolean supportsReadObject(Class type, boolean includeBaseClasses) {
        return this.getMethod(type, "readObject", new Class[]{ObjectInputStream.class}, includeBaseClasses) != null;
    }

    public void callReadObject(Class type, Object object, ObjectInputStream stream) {
        ErrorWritingException ex2 = null;
        try {
            Method readObjectMethod = this.getMethod(type, "readObject", new Class[]{ObjectInputStream.class}, false);
            readObjectMethod.invoke(object, stream);
        }
        catch (IllegalAccessException e2) {
            ex2 = new ObjectAccessException("Cannot access method", e2);
        }
        catch (InvocationTargetException e3) {
            ex2 = new ConversionException("Failed calling method", e3.getTargetException());
        }
        if (ex2 != null) {
            ex2.add("method", object.getClass().getName() + ".readObject()");
            throw ex2;
        }
    }

    public boolean supportsWriteObject(Class type, boolean includeBaseClasses) {
        return this.getMethod(type, "writeObject", new Class[]{ObjectOutputStream.class}, includeBaseClasses) != null;
    }

    public void callWriteObject(Class type, Object instance, ObjectOutputStream stream) {
        ErrorWritingException ex2 = null;
        try {
            Method readObjectMethod = this.getMethod(type, "writeObject", new Class[]{ObjectOutputStream.class}, false);
            readObjectMethod.invoke(instance, stream);
        }
        catch (IllegalAccessException e2) {
            ex2 = new ObjectAccessException("Cannot access method", e2);
        }
        catch (InvocationTargetException e3) {
            Throwable cause = e3.getTargetException();
            if (cause instanceof ConversionException) {
                throw (ConversionException)cause;
            }
            ex2 = new ConversionException("Failed calling method", e3.getTargetException());
        }
        if (ex2 != null) {
            ex2.add("method", instance.getClass().getName() + ".writeObject()");
            throw ex2;
        }
    }

    private Method getMethod(Class type, String name, Class[] parameterTypes, boolean includeBaseclasses) {
        Method method = this.getMethod(type, name, parameterTypes);
        return method == NO_METHOD || !includeBaseclasses && !method.getDeclaringClass().equals(type) ? null : method;
    }

    private Method getMethod(Class type, String name, Class[] parameterTypes) {
        if (type == null) {
            return null;
        }
        Method result2 = (Method)this.declaredCache.get(type, name);
        if (result2 == null) {
            try {
                result2 = type.getDeclaredMethod(name, parameterTypes);
                if (!result2.isAccessible()) {
                    result2.setAccessible(true);
                }
            }
            catch (NoSuchMethodException e2) {
                result2 = this.getMethod(type.getSuperclass(), name, parameterTypes);
            }
            this.declaredCache.put(type, name, result2);
        }
        return result2;
    }

    private Method getRRMethod(Class type, String name) {
        Method result2 = (Method)this.resRepCache.get(type, name);
        if (result2 == null) {
            result2 = this.getMethod(type, name, EMPTY_CLASSES, true);
            if (result2 != null && result2.getDeclaringClass() != type) {
                if ((result2.getModifiers() & 5) == 0 && ((result2.getModifiers() & 2) > 0 || type.getPackage() != result2.getDeclaringClass().getPackage())) {
                    result2 = NO_METHOD;
                }
            } else if (result2 == null) {
                result2 = NO_METHOD;
            }
            this.resRepCache.put(type, name, result2);
        }
        return result2 == NO_METHOD ? null : result2;
    }

    public boolean hasSerializablePersistentFields(Class type) {
        if (type == null) {
            return false;
        }
        ObjectStreamField[] result2 = (ObjectStreamField[])this.fieldCache.get(type.getName());
        if (result2 == null) {
            ErrorWritingException ex2 = null;
            try {
                Field field = type.getDeclaredField("serialPersistentFields");
                if ((field.getModifiers() & 0x1A) == 26) {
                    field.setAccessible(true);
                    result2 = (ObjectStreamField[])field.get(null);
                }
            }
            catch (NoSuchFieldException field) {
            }
            catch (IllegalAccessException e2) {
                ex2 = new ObjectAccessException("Cannot get field", e2);
            }
            catch (ClassCastException e3) {
                ex2 = new ConversionException("Incompatible field type", e3);
            }
            if (ex2 != null) {
                ex2.add("field", type.getName() + ".serialPersistentFields");
                throw ex2;
            }
            if (result2 == null) {
                result2 = NO_FIELDS;
            }
            this.fieldCache.put(type.getName(), result2);
        }
        return result2 != NO_FIELDS;
    }

    public void flushCache() {
        Set<String> classNames = Collections.singleton(Object.class.getName());
        this.declaredCache.keySet().retainAll(classNames);
        this.resRepCache.keySet().retainAll(classNames);
    }

    private static final class NO_METHOD_MARKER {
        private NO_METHOD_MARKER() {
        }

        private void noMethod() {
        }
    }
}

