/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.crypto.eddsa.math.bigint;

import java.io.Serializable;
import java.math.BigInteger;
import net.i2p.crypto.eddsa.math.Field;
import net.i2p.crypto.eddsa.math.FieldElement;

public class BigIntegerFieldElement
extends FieldElement
implements Serializable {
    private static final long serialVersionUID = 4890398908392808L;
    final BigInteger bi;

    public BigIntegerFieldElement(Field f2, BigInteger bi2) {
        super(f2);
        this.bi = bi2;
    }

    @Override
    public boolean isNonZero() {
        return !this.bi.equals(BigInteger.ZERO);
    }

    @Override
    public FieldElement add(FieldElement val) {
        return new BigIntegerFieldElement(this.f, this.bi.add(((BigIntegerFieldElement)val).bi)).mod(this.f.getQ());
    }

    @Override
    public FieldElement addOne() {
        return new BigIntegerFieldElement(this.f, this.bi.add(BigInteger.ONE)).mod(this.f.getQ());
    }

    @Override
    public FieldElement subtract(FieldElement val) {
        return new BigIntegerFieldElement(this.f, this.bi.subtract(((BigIntegerFieldElement)val).bi)).mod(this.f.getQ());
    }

    @Override
    public FieldElement subtractOne() {
        return new BigIntegerFieldElement(this.f, this.bi.subtract(BigInteger.ONE)).mod(this.f.getQ());
    }

    @Override
    public FieldElement negate() {
        return this.f.getQ().subtract(this);
    }

    @Override
    public FieldElement divide(FieldElement val) {
        return this.divide(((BigIntegerFieldElement)val).bi);
    }

    public FieldElement divide(BigInteger val) {
        return new BigIntegerFieldElement(this.f, this.bi.divide(val)).mod(this.f.getQ());
    }

    @Override
    public FieldElement multiply(FieldElement val) {
        return new BigIntegerFieldElement(this.f, this.bi.multiply(((BigIntegerFieldElement)val).bi)).mod(this.f.getQ());
    }

    @Override
    public FieldElement square() {
        return this.multiply(this);
    }

    @Override
    public FieldElement squareAndDouble() {
        FieldElement sq = this.square();
        return sq.add(sq);
    }

    @Override
    public FieldElement invert() {
        return new BigIntegerFieldElement(this.f, this.bi.modInverse(((BigIntegerFieldElement)this.f.getQ()).bi));
    }

    public FieldElement mod(FieldElement m2) {
        return new BigIntegerFieldElement(this.f, this.bi.mod(((BigIntegerFieldElement)m2).bi));
    }

    public FieldElement modPow(FieldElement e2, FieldElement m2) {
        return new BigIntegerFieldElement(this.f, this.bi.modPow(((BigIntegerFieldElement)e2).bi, ((BigIntegerFieldElement)m2).bi));
    }

    public FieldElement pow(FieldElement e2) {
        return this.modPow(e2, this.f.getQ());
    }

    @Override
    public FieldElement pow22523() {
        return this.pow(this.f.getQm5d8());
    }

    @Override
    public FieldElement cmov(FieldElement val, int b2) {
        return b2 == 0 ? this : val;
    }

    public int hashCode() {
        return this.bi.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof BigIntegerFieldElement)) {
            return false;
        }
        BigIntegerFieldElement fe = (BigIntegerFieldElement)obj;
        return this.bi.equals(fe.bi);
    }

    public String toString() {
        return "[BigIntegerFieldElement val=" + this.bi + "]";
    }
}

