/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.crypto.eddsa.math.ed25519;

import net.i2p.crypto.eddsa.math.Encoding;
import net.i2p.crypto.eddsa.math.FieldElement;
import net.i2p.crypto.eddsa.math.ed25519.Ed25519FieldElement;

public class Ed25519LittleEndianEncoding
extends Encoding {
    @Override
    public byte[] encode(FieldElement x2) {
        int[] h7 = ((Ed25519FieldElement)x2).t;
        int h0 = h7[0];
        int h12 = h7[1];
        int h22 = h7[2];
        int h32 = h7[3];
        int h42 = h7[4];
        int h52 = h7[5];
        int h62 = h7[6];
        int h72 = h7[7];
        int h8 = h7[8];
        int h9 = h7[9];
        int q2 = 19 * h9 + 0x1000000 >> 25;
        q2 = h0 + q2 >> 26;
        q2 = h12 + q2 >> 25;
        q2 = h22 + q2 >> 26;
        q2 = h32 + q2 >> 25;
        q2 = h42 + q2 >> 26;
        q2 = h52 + q2 >> 25;
        q2 = h62 + q2 >> 26;
        q2 = h72 + q2 >> 25;
        q2 = h8 + q2 >> 26;
        q2 = h9 + q2 >> 25;
        int carry0 = (h0 += 19 * q2) >> 26;
        h0 -= carry0 << 26;
        int carry1 = (h12 += carry0) >> 25;
        h12 -= carry1 << 25;
        int carry2 = (h22 += carry1) >> 26;
        h22 -= carry2 << 26;
        int carry3 = (h32 += carry2) >> 25;
        h32 -= carry3 << 25;
        int carry4 = (h42 += carry3) >> 26;
        h42 -= carry4 << 26;
        int carry5 = (h52 += carry4) >> 25;
        h52 -= carry5 << 25;
        int carry6 = (h62 += carry5) >> 26;
        int carry7 = (h72 += carry6) >> 25;
        int carry8 = (h8 += carry7) >> 26;
        int carry9 = (h9 += carry8) >> 25;
        byte[] s2 = new byte[]{(byte)h0, (byte)(h0 >> 8), (byte)(h0 >> 16), (byte)(h0 >> 24 | h12 << 2), (byte)(h12 >> 6), (byte)(h12 >> 14), (byte)(h12 >> 22 | h22 << 3), (byte)(h22 >> 5), (byte)(h22 >> 13), (byte)(h22 >> 21 | h32 << 5), (byte)(h32 >> 3), (byte)(h32 >> 11), (byte)(h32 >> 19 | h42 << 6), (byte)(h42 >> 2), (byte)(h42 >> 10), (byte)(h42 >> 18), (byte)h52, (byte)(h52 >> 8), (byte)(h52 >> 16), (byte)(h52 >> 24 | (h62 -= carry6 << 26) << 1), (byte)(h62 >> 7), (byte)(h62 >> 15), (byte)(h62 >> 23 | (h72 -= carry7 << 25) << 3), (byte)(h72 >> 5), (byte)(h72 >> 13), (byte)(h72 >> 21 | (h8 -= carry8 << 26) << 4), (byte)(h8 >> 4), (byte)(h8 >> 12), (byte)(h8 >> 20 | (h9 -= carry9 << 25) << 6), (byte)(h9 >> 2), (byte)(h9 >> 10), (byte)(h9 >> 18)};
        return s2;
    }

    static int load_3(byte[] in, int offset) {
        int result2 = in[offset++] & 0xFF;
        result2 |= (in[offset++] & 0xFF) << 8;
        return result2 |= (in[offset] & 0xFF) << 16;
    }

    static long load_4(byte[] in, int offset) {
        int result2 = in[offset++] & 0xFF;
        result2 |= (in[offset++] & 0xFF) << 8;
        result2 |= (in[offset++] & 0xFF) << 16;
        return (long)(result2 |= in[offset] << 24) & 0xFFFFFFFFL;
    }

    @Override
    public FieldElement decode(byte[] in) {
        long h0 = Ed25519LittleEndianEncoding.load_4(in, 0);
        long h12 = Ed25519LittleEndianEncoding.load_3(in, 4) << 6;
        long h22 = Ed25519LittleEndianEncoding.load_3(in, 7) << 5;
        long h32 = Ed25519LittleEndianEncoding.load_3(in, 10) << 3;
        long h42 = Ed25519LittleEndianEncoding.load_3(in, 13) << 2;
        long h52 = Ed25519LittleEndianEncoding.load_4(in, 16);
        long h62 = Ed25519LittleEndianEncoding.load_3(in, 20) << 7;
        long h7 = Ed25519LittleEndianEncoding.load_3(in, 23) << 5;
        long h8 = Ed25519LittleEndianEncoding.load_3(in, 26) << 4;
        long h9 = (Ed25519LittleEndianEncoding.load_3(in, 29) & 0x7FFFFF) << 2;
        long carry9 = h9 + 0x1000000L >> 25;
        h0 += carry9 * 19L;
        h9 -= carry9 << 25;
        long carry1 = h12 + 0x1000000L >> 25;
        h22 += carry1;
        h12 -= carry1 << 25;
        long carry3 = h32 + 0x1000000L >> 25;
        h42 += carry3;
        h32 -= carry3 << 25;
        long carry5 = h52 + 0x1000000L >> 25;
        h62 += carry5;
        h52 -= carry5 << 25;
        long carry7 = h7 + 0x1000000L >> 25;
        h8 += carry7;
        h7 -= carry7 << 25;
        long carry0 = h0 + 0x2000000L >> 26;
        h12 += carry0;
        h0 -= carry0 << 26;
        long carry2 = h22 + 0x2000000L >> 26;
        h32 += carry2;
        h22 -= carry2 << 26;
        long carry4 = h42 + 0x2000000L >> 26;
        long carry6 = h62 + 0x2000000L >> 26;
        long carry8 = h8 + 0x2000000L >> 26;
        int[] h10 = new int[]{(int)h0, (int)h12, (int)h22, (int)h32, (int)(h42 -= carry4 << 26), (int)(h52 += carry4), (int)(h62 -= carry6 << 26), (int)(h7 += carry6), (int)(h8 -= carry8 << 26), (int)(h9 += carry8)};
        return new Ed25519FieldElement(this.f, h10);
    }

    @Override
    public boolean isNegative(FieldElement x2) {
        byte[] s2 = this.encode(x2);
        return (s2[0] & 1) != 0;
    }
}

