/*
 * Decompiled with CFR 0.152.
 */
package net.schmizz.sshj.common;

import java.math.BigInteger;
import java.nio.charset.Charset;
import java.security.GeneralSecurityException;
import java.security.PublicKey;
import java.util.Arrays;
import net.schmizz.sshj.common.ByteArrayUtils;
import net.schmizz.sshj.common.IOUtils;
import net.schmizz.sshj.common.KeyType;
import net.schmizz.sshj.common.SSHException;
import net.schmizz.sshj.common.SSHRuntimeException;

public class Buffer<T extends Buffer<T>> {
    public static final int DEFAULT_SIZE = 256;
    public static final int MAX_SIZE = 0x40000000;
    public static final BigInteger MAX_UINT64_VALUE = BigInteger.ONE.shiftLeft(64).subtract(BigInteger.ONE);
    protected byte[] data;
    protected int rpos;
    protected int wpos;

    protected static int getNextPowerOf2(int i2) {
        int j2 = 1;
        while (j2 < i2) {
            if ((j2 <<= 1) > 0) continue;
            throw new IllegalArgumentException("Cannot get next power of 2; " + i2 + " is too large");
        }
        return j2;
    }

    public Buffer() {
        this(256);
    }

    public Buffer(Buffer<?> from) {
        this.wpos = from.wpos - from.rpos;
        this.data = new byte[this.wpos];
        System.arraycopy(from.data, from.rpos, this.data, 0, this.wpos);
    }

    public Buffer(byte[] data) {
        this(data, true);
    }

    public Buffer(int size) {
        this(new byte[Buffer.getNextPowerOf2(size)], false);
    }

    private Buffer(byte[] data, boolean read) {
        this.data = data;
        this.rpos = 0;
        this.wpos = read ? data.length : 0;
    }

    public byte[] array() {
        return this.data;
    }

    public int available() {
        return this.wpos - this.rpos;
    }

    public void clear() {
        this.rpos = 0;
        this.wpos = 0;
    }

    public int rpos() {
        return this.rpos;
    }

    public void rpos(int rpos) {
        this.rpos = rpos;
    }

    public int wpos() {
        return this.wpos;
    }

    public void wpos(int wpos) {
        this.ensureCapacity(wpos - this.wpos);
        this.wpos = wpos;
    }

    protected void ensureAvailable(int a2) throws BufferException {
        if (this.available() < a2) {
            throw new BufferException("Underflow");
        }
    }

    public void ensureCapacity(int capacity) {
        if (this.data.length - this.wpos < capacity) {
            int cw2 = this.wpos + capacity;
            byte[] tmp = new byte[Buffer.getNextPowerOf2(cw2)];
            System.arraycopy(this.data, 0, tmp, 0, this.data.length);
            this.data = tmp;
        }
    }

    public void compact() {
        if (this.available() > 0) {
            System.arraycopy(this.data, this.rpos, this.data, 0, this.wpos - this.rpos);
        }
        this.wpos -= this.rpos;
        this.rpos = 0;
    }

    public byte[] getCompactData() {
        int len = this.available();
        if (len > 0) {
            byte[] b2 = new byte[len];
            System.arraycopy(this.data, this.rpos, b2, 0, len);
            return b2;
        }
        return new byte[0];
    }

    public boolean readBoolean() throws BufferException {
        return this.readByte() != 0;
    }

    public T putBoolean(boolean b2) {
        return this.putByte(b2 ? (byte)1 : 0);
    }

    public byte readByte() throws BufferException {
        this.ensureAvailable(1);
        return this.data[this.rpos++];
    }

    public T putByte(byte b2) {
        this.ensureCapacity(1);
        this.data[this.wpos++] = b2;
        return (T)this;
    }

    public byte[] readBytes() throws BufferException {
        int len = this.readUInt32AsInt();
        if (len < 0 || len > 32768) {
            throw new BufferException("Bad item length: " + len);
        }
        byte[] b2 = new byte[len];
        this.readRawBytes(b2);
        return b2;
    }

    public T putBytes(byte[] b2) {
        return this.putBytes(b2, 0, b2.length);
    }

    public T putBytes(byte[] b2, int off, int len) {
        return ((Buffer)this.putUInt32(len)).putRawBytes(b2, off, len);
    }

    public void readRawBytes(byte[] buf) throws BufferException {
        this.readRawBytes(buf, 0, buf.length);
    }

    public void readRawBytes(byte[] buf, int off, int len) throws BufferException {
        this.ensureAvailable(len);
        System.arraycopy(this.data, this.rpos, buf, off, len);
        this.rpos += len;
    }

    public T putRawBytes(byte[] d2) {
        return this.putRawBytes(d2, 0, d2.length);
    }

    public T putRawBytes(byte[] d2, int off, int len) {
        this.ensureCapacity(len);
        System.arraycopy(d2, off, this.data, this.wpos, len);
        this.wpos += len;
        return (T)this;
    }

    public T putBuffer(Buffer<? extends Buffer<?>> buffer) {
        if (buffer != null) {
            int r2 = buffer.available();
            this.ensureCapacity(r2);
            System.arraycopy(buffer.data, buffer.rpos, this.data, this.wpos, r2);
            this.wpos += r2;
        }
        return (T)this;
    }

    public int readUInt32AsInt() throws BufferException {
        return (int)this.readUInt32();
    }

    public long readUInt32() throws BufferException {
        this.ensureAvailable(4);
        return (long)(this.data[this.rpos++] << 24) & 0xFF000000L | (long)(this.data[this.rpos++] << 16) & 0xFF0000L | (long)(this.data[this.rpos++] << 8) & 0xFF00L | (long)this.data[this.rpos++] & 0xFFL;
    }

    public T putUInt32FromInt(int uint32) {
        this.ensureCapacity(4);
        this.data[this.wpos++] = (byte)(uint32 >> 24);
        this.data[this.wpos++] = (byte)(uint32 >> 16);
        this.data[this.wpos++] = (byte)(uint32 >> 8);
        this.data[this.wpos++] = (byte)uint32;
        return (T)this;
    }

    public T putUInt32(long uint32) {
        this.ensureCapacity(4);
        if (uint32 < 0L || uint32 > 0xFFFFFFFFL) {
            throw new IllegalArgumentException("Invalid value: " + uint32);
        }
        this.data[this.wpos++] = (byte)(uint32 >> 24);
        this.data[this.wpos++] = (byte)(uint32 >> 16);
        this.data[this.wpos++] = (byte)(uint32 >> 8);
        this.data[this.wpos++] = (byte)uint32;
        return (T)this;
    }

    public BigInteger readMPInt() throws BufferException {
        return new BigInteger(this.readBytes());
    }

    public T putMPInt(BigInteger bi2) {
        byte[] asBytes = bi2.toByteArray();
        this.putUInt32(asBytes.length);
        return this.putRawBytes(asBytes);
    }

    public long readUInt64() throws BufferException {
        long uint64 = (this.readUInt32() << 32) + (this.readUInt32() & 0xFFFFFFFFL);
        if (uint64 < 0L) {
            throw new BufferException("Cannot handle values > Long.MAX_VALUE");
        }
        return uint64;
    }

    public BigInteger readUInt64AsBigInteger() throws BufferException {
        byte[] magnitude = new byte[8];
        this.readRawBytes(magnitude);
        return new BigInteger(1, magnitude);
    }

    public T putUInt64(long uint64) {
        if (uint64 < 0L) {
            throw new IllegalArgumentException("Invalid value: " + uint64);
        }
        return this.putUInt64Unchecked(uint64);
    }

    public T putUInt64(BigInteger uint64) {
        if (uint64.compareTo(MAX_UINT64_VALUE) > 0 || uint64.compareTo(BigInteger.ZERO) < 0) {
            throw new IllegalArgumentException("Invalid value: " + uint64);
        }
        return this.putUInt64Unchecked(uint64.longValue());
    }

    private T putUInt64Unchecked(long uint64) {
        this.ensureCapacity(8);
        this.data[this.wpos++] = (byte)(uint64 >> 56);
        this.data[this.wpos++] = (byte)(uint64 >> 48);
        this.data[this.wpos++] = (byte)(uint64 >> 40);
        this.data[this.wpos++] = (byte)(uint64 >> 32);
        this.data[this.wpos++] = (byte)(uint64 >> 24);
        this.data[this.wpos++] = (byte)(uint64 >> 16);
        this.data[this.wpos++] = (byte)(uint64 >> 8);
        this.data[this.wpos++] = (byte)uint64;
        return (T)this;
    }

    public String readString(Charset cs2) throws BufferException {
        int len = this.readUInt32AsInt();
        if (len < 0 || len > 32768) {
            throw new BufferException("Bad item length: " + len);
        }
        this.ensureAvailable(len);
        String s2 = new String(this.data, this.rpos, len, cs2);
        this.rpos += len;
        return s2;
    }

    public String readString() throws BufferException {
        return this.readString(IOUtils.UTF8);
    }

    public byte[] readStringAsBytes() throws BufferException {
        return this.readBytes();
    }

    public T putString(byte[] str) {
        return this.putBytes(str);
    }

    public T putString(byte[] str, int offset, int len) {
        return this.putBytes(str, offset, len);
    }

    public T putString(String string2, Charset cs2) {
        return this.putString(string2.getBytes(cs2));
    }

    public T putString(String string2) {
        return this.putString(string2, IOUtils.UTF8);
    }

    public T putSensitiveString(char[] str) {
        if (str == null) {
            return this.putString("");
        }
        byte[] utf8 = ByteArrayUtils.encodeSensitiveStringToUtf8(str);
        this.putUInt32(utf8.length);
        this.ensureCapacity(utf8.length);
        for (byte c2 : utf8) {
            this.data[this.wpos++] = c2;
        }
        Arrays.fill(utf8, (byte)0);
        return (T)this;
    }

    public PublicKey readPublicKey() throws BufferException {
        KeyType keyType = KeyType.fromString(this.readString());
        try {
            return keyType.readPubKeyFromBuffer(this);
        }
        catch (GeneralSecurityException e2) {
            throw new SSHRuntimeException(e2);
        }
        catch (UnsupportedOperationException uoe) {
            throw new BufferException("Could not decode keytype " + (Object)((Object)keyType));
        }
    }

    public T putPublicKey(PublicKey key) {
        KeyType.fromKey(key).putPubKeyIntoBuffer(key, this);
        return (T)this;
    }

    public T putSignature(String sigFormat, byte[] sigData) {
        byte[] sig = ((PlainBuffer)((PlainBuffer)new PlainBuffer().putString(sigFormat)).putBytes(sigData)).getCompactData();
        return this.putString(sig);
    }

    public String printHex() {
        return ByteArrayUtils.printHex(this.array(), this.rpos(), this.available());
    }

    public String toString() {
        return "Buffer [rpos=" + this.rpos + ", wpos=" + this.wpos + ", size=" + this.data.length + "]";
    }

    public static final class PlainBuffer
    extends Buffer<PlainBuffer> {
        public PlainBuffer() {
        }

        public PlainBuffer(Buffer<?> from) {
            super(from);
        }

        public PlainBuffer(byte[] b2) {
            super(b2);
        }

        public PlainBuffer(int size) {
            super(size);
        }
    }

    public static class BufferException
    extends SSHException {
        public BufferException(String message) {
            super(message);
        }
    }
}

