/*
 * Decompiled with CFR 0.152.
 */
package net.schmizz.sshj.common;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import net.schmizz.sshj.common.LoggerFactory;
import net.schmizz.sshj.common.StreamCopier;

public class IOUtils {
    public static final Charset UTF8 = Charset.forName("UTF-8");

    public static void closeQuietly(Closeable ... closeables) {
        IOUtils.closeQuietly(LoggerFactory.DEFAULT, closeables);
    }

    public static ByteArrayOutputStream readFully(InputStream stream) throws IOException {
        return IOUtils.readFully(stream, LoggerFactory.DEFAULT);
    }

    public static void closeQuietly(LoggerFactory loggerFactory, Closeable ... closeables) {
        for (Closeable c2 : closeables) {
            try {
                if (c2 == null) continue;
                c2.close();
            }
            catch (IOException logged) {
                loggerFactory.getLogger(IOUtils.class).warn("Error closing {} - {}", (Object)c2, (Object)logged);
            }
        }
    }

    public static ByteArrayOutputStream readFully(InputStream stream, LoggerFactory loggerFactory) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        new StreamCopier(stream, baos, loggerFactory).copy();
        return baos;
    }
}

