/*
 * Decompiled with CFR 0.152.
 */
package net.schmizz.sshj.sftp;

public class PathComponents {
    private final String parent;
    private final String name;
    private final String path;

    static String adjustForParent(String parent, String path, String pathSep) {
        if (path.startsWith(pathSep)) {
            return path;
        }
        if (parent.endsWith(pathSep)) {
            return parent + path;
        }
        if (parent.isEmpty()) {
            return path;
        }
        return parent + pathSep + path;
    }

    static String trimTrailingSeparator(String somePath, String pathSep) {
        return somePath.endsWith(pathSep) ? somePath.substring(0, somePath.length() - pathSep.length()) : somePath;
    }

    public PathComponents(String parent, String name, String pathSep) {
        this.parent = parent;
        this.name = name;
        String adjusted = PathComponents.adjustForParent(parent, name, pathSep);
        this.path = !pathSep.equals(adjusted) ? PathComponents.trimTrailingSeparator(adjusted, pathSep) : adjusted;
    }

    public String getParent() {
        return this.parent;
    }

    public String getName() {
        return this.name;
    }

    public String getPath() {
        return this.path;
    }

    public boolean equals(Object o2) {
        return this == o2 || o2 instanceof PathComponents && this.path.equals(((PathComponents)o2).path);
    }

    public int hashCode() {
        return this.path.hashCode();
    }

    public String toString() {
        return "[parent=" + this.parent + "; name=" + this.name + "; path=" + this.path + "]";
    }
}

