/*
 * Decompiled with CFR 0.152.
 */
package net.schmizz.sshj.sftp;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.util.Objects;
import net.schmizz.sshj.sftp.RemoteFile;

public class RandomAccessRemoteFile
implements DataInput,
DataOutput {
    private final byte[] singleByte = new byte[1];
    private final RemoteFile rf;
    private long fp;

    public RandomAccessRemoteFile(RemoteFile rf) {
        this.rf = rf;
    }

    public long getFilePointer() {
        return this.fp;
    }

    public void seek(long fp) {
        this.fp = fp;
    }

    public int read() throws IOException {
        return this.read(this.singleByte, 0, 1) == -1 ? -1 : this.singleByte[0];
    }

    public int read(byte[] b2) throws IOException {
        return this.read(b2, 0, b2.length);
    }

    public int read(byte[] b2, int off, int len) throws IOException {
        int count = this.rf.read(this.fp, b2, off, len);
        this.fp += (long)count;
        return count;
    }

    @Override
    public boolean readBoolean() throws IOException {
        int ch2 = this.read();
        if (ch2 < 0) {
            throw new EOFException();
        }
        return ch2 != 0;
    }

    @Override
    public byte readByte() throws IOException {
        int ch2 = this.read();
        if (ch2 < 0) {
            throw new EOFException();
        }
        return (byte)ch2;
    }

    @Override
    public char readChar() throws IOException {
        int ch2;
        int ch1 = this.read();
        if ((ch1 | (ch2 = this.read())) < 0) {
            throw new EOFException();
        }
        return (char)((ch1 << 8) + ch2);
    }

    @Override
    public double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    @Override
    public float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    @Override
    public void readFully(byte[] b2) throws IOException {
        this.readFully(b2, 0, b2.length);
    }

    @Override
    public void readFully(byte[] b2, int off, int len) throws IOException {
        int count;
        int n2 = 0;
        do {
            if ((count = this.read(b2, off + n2, len - n2)) >= 0) continue;
            throw new EOFException();
        } while ((n2 += count) < len);
    }

    @Override
    public int readInt() throws IOException {
        int ch4;
        int ch3;
        int ch2;
        int ch1 = this.read();
        if ((ch1 | (ch2 = this.read()) | (ch3 = this.read()) | (ch4 = this.read())) < 0) {
            throw new EOFException();
        }
        return (ch1 << 24) + (ch2 << 16) + (ch3 << 8) + ch4;
    }

    @Override
    public String readLine() throws IOException {
        StringBuffer input2 = new StringBuffer();
        int c2 = -1;
        boolean eol = false;
        block4: while (!eol) {
            c2 = this.read();
            switch (c2) {
                case -1: 
                case 10: {
                    eol = true;
                    continue block4;
                }
                case 13: {
                    eol = true;
                    long cur = this.getFilePointer();
                    if (this.read() == 10) continue block4;
                    this.seek(cur);
                    continue block4;
                }
            }
            input2.append((char)c2);
        }
        if (c2 == -1 && input2.length() == 0) {
            return null;
        }
        return input2.toString();
    }

    @Override
    public long readLong() throws IOException {
        return ((long)this.readInt() << 32) + ((long)this.readInt() & 0xFFFFFFFFL);
    }

    @Override
    public short readShort() throws IOException {
        int ch2;
        int ch1 = this.read();
        if ((ch1 | (ch2 = this.read())) < 0) {
            throw new EOFException();
        }
        return (short)((ch1 << 8) + ch2);
    }

    @Override
    public String readUTF() throws IOException {
        return DataInputStream.readUTF(this);
    }

    @Override
    public int readUnsignedByte() throws IOException {
        int ch2 = this.read();
        if (ch2 < 0) {
            throw new EOFException();
        }
        return ch2;
    }

    @Override
    public int readUnsignedShort() throws IOException {
        int ch2;
        int ch1 = this.read();
        if ((ch1 | (ch2 = this.read())) < 0) {
            throw new EOFException();
        }
        return (ch1 << 8) + ch2;
    }

    @Override
    public int skipBytes(int n2) throws IOException {
        long len;
        if (n2 <= 0) {
            return 0;
        }
        long pos = this.getFilePointer();
        long newpos = pos + (long)n2;
        if (newpos > (len = this.rf.length())) {
            newpos = len;
        }
        this.seek(newpos);
        return (int)(newpos - pos);
    }

    @Override
    public void write(int i2) throws IOException {
        this.singleByte[0] = (byte)i2;
        this.write(this.singleByte);
    }

    @Override
    public void write(byte[] b2) throws IOException {
        this.write(b2, 0, b2.length);
    }

    @Override
    public void write(byte[] b2, int off, int len) throws IOException {
        this.rf.write(this.fp, b2, off, len);
        this.fp += (long)(len - off);
    }

    @Override
    public void writeBoolean(boolean v2) throws IOException {
        this.write(v2 ? 1 : 0);
    }

    @Override
    public void writeByte(int v2) throws IOException {
        this.write(v2);
    }

    @Override
    public void writeBytes(String s2) throws IOException {
        byte[] b2 = s2.getBytes();
        this.write(b2, 0, b2.length);
    }

    @Override
    public void writeChar(int v2) throws IOException {
        this.write(v2 >>> 8 & 0xFF);
        this.write(v2 & 0xFF);
    }

    @Override
    public void writeChars(String s2) throws IOException {
        int clen = s2.length();
        int blen = 2 * clen;
        byte[] b2 = new byte[blen];
        char[] c2 = new char[clen];
        s2.getChars(0, clen, c2, 0);
        int j2 = 0;
        for (int i2 = 0; i2 < clen; ++i2) {
            b2[j2++] = (byte)(c2[i2] >>> 8);
            b2[j2++] = (byte)c2[i2];
        }
        this.write(b2, 0, blen);
    }

    @Override
    public void writeDouble(double v2) throws IOException {
        this.writeLong(Double.doubleToLongBits(v2));
    }

    @Override
    public void writeFloat(float v2) throws IOException {
        this.writeInt(Float.floatToIntBits(v2));
    }

    @Override
    public void writeInt(int v2) throws IOException {
        this.write(v2 >>> 24 & 0xFF);
        this.write(v2 >>> 16 & 0xFF);
        this.write(v2 >>> 8 & 0xFF);
        this.write(v2 & 0xFF);
    }

    @Override
    public void writeLong(long v2) throws IOException {
        this.write((int)(v2 >>> 56) & 0xFF);
        this.write((int)(v2 >>> 48) & 0xFF);
        this.write((int)(v2 >>> 40) & 0xFF);
        this.write((int)(v2 >>> 32) & 0xFF);
        this.write((int)(v2 >>> 24) & 0xFF);
        this.write((int)(v2 >>> 16) & 0xFF);
        this.write((int)(v2 >>> 8) & 0xFF);
        this.write((int)v2 & 0xFF);
    }

    @Override
    public void writeShort(int v2) throws IOException {
        this.write(v2 >>> 8 & 0xFF);
        this.write(v2 & 0xFF);
    }

    @Override
    public void writeUTF(String str) throws IOException {
        RemoteFile remoteFile = this.rf;
        Objects.requireNonNull(remoteFile);
        try (DataOutputStream dos = new DataOutputStream(remoteFile.new RemoteFile.RemoteFileOutputStream(this.fp));){
            dos.writeUTF(str);
        }
        this.fp += (long)dos.size();
    }
}

