/*
 * Decompiled with CFR 0.152.
 */
package net.schmizz.sshj.transport;

import com.hierynomus.sshj.common.ThreadNameProvider;
import com.hierynomus.sshj.key.KeyAlgorithm;
import com.hierynomus.sshj.key.KeyAlgorithms;
import com.hierynomus.sshj.transport.IdentificationStringParser;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import net.schmizz.concurrent.ErrorDeliveryUtil;
import net.schmizz.concurrent.Event;
import net.schmizz.sshj.AbstractService;
import net.schmizz.sshj.Config;
import net.schmizz.sshj.Service;
import net.schmizz.sshj.common.Buffer;
import net.schmizz.sshj.common.DisconnectReason;
import net.schmizz.sshj.common.Factory;
import net.schmizz.sshj.common.IOUtils;
import net.schmizz.sshj.common.KeyType;
import net.schmizz.sshj.common.LoggerFactory;
import net.schmizz.sshj.common.Message;
import net.schmizz.sshj.common.SSHException;
import net.schmizz.sshj.common.SSHPacket;
import net.schmizz.sshj.transport.Decoder;
import net.schmizz.sshj.transport.DisconnectListener;
import net.schmizz.sshj.transport.Encoder;
import net.schmizz.sshj.transport.KeyExchanger;
import net.schmizz.sshj.transport.Reader;
import net.schmizz.sshj.transport.Transport;
import net.schmizz.sshj.transport.TransportException;
import net.schmizz.sshj.transport.verification.AlgorithmsVerifier;
import net.schmizz.sshj.transport.verification.HostKeyVerifier;
import org.slf4j.Logger;

public final class TransportImpl
implements Transport,
DisconnectListener {
    private final LoggerFactory loggerFactory;
    private final Logger log;
    private final Service nullService;
    private final Config config;
    private final KeyExchanger kexer;
    private final Reader reader;
    private final Encoder encoder;
    private final Decoder decoder;
    private KeyAlgorithm hostKeyAlgorithm;
    private final Event<TransportException> serviceAccept;
    private final Event<TransportException> close;
    private final String clientID;
    private volatile int timeoutMs = 30000;
    private volatile boolean authed = false;
    private volatile Service service;
    private volatile Service nextService;
    private DisconnectListener disconnectListener;
    private ConnInfo connInfo;
    private String serverID;
    private Message msg;
    private final ReentrantLock writeLock = new ReentrantLock();

    public TransportImpl(Config config) {
        this.config = config;
        this.loggerFactory = config.getLoggerFactory();
        this.serviceAccept = new Event<TransportException>("service accept", TransportException.chainer, this.loggerFactory);
        this.close = new Event<TransportException>("transport close", TransportException.chainer, this.loggerFactory);
        this.service = this.nullService = new NullService(this);
        this.log = this.loggerFactory.getLogger(this.getClass());
        this.disconnectListener = this;
        this.reader = new Reader(this);
        this.encoder = new Encoder(config.getRandomFactory().create(), this.writeLock, this.loggerFactory);
        this.decoder = new Decoder(this);
        this.kexer = new KeyExchanger(this);
        this.clientID = String.format("SSH-2.0-%s", config.getVersion());
    }

    @Override
    public void init(String remoteHost, int remotePort, InputStream in, OutputStream out) throws TransportException {
        this.connInfo = new ConnInfo(remoteHost, remotePort, in, out);
        try {
            if (this.config.isWaitForServerIdentBeforeSendingClientIdent()) {
                this.receiveServerIdent();
                this.sendClientIdent();
            } else {
                this.sendClientIdent();
                this.receiveServerIdent();
            }
            this.log.info("Server identity string: {}", (Object)this.serverID);
        }
        catch (IOException e2) {
            throw new TransportException(e2);
        }
        ThreadNameProvider.setThreadName(this.reader, this);
        this.reader.start();
    }

    @Override
    public InetSocketAddress getRemoteSocketAddress() {
        return this.connInfo == null ? null : new InetSocketAddress(this.getRemoteHost(), this.getRemotePort());
    }

    @Override
    public void notifyDisconnect(DisconnectReason reason, String message) {
        this.log.info("Disconnected - {}", (Object)reason);
    }

    private void receiveServerIdent() throws IOException {
        Buffer.PlainBuffer buf = new Buffer.PlainBuffer();
        while ((this.serverID = this.readIdentification(buf)).isEmpty()) {
            int b2 = this.connInfo.in.read();
            if (b2 == -1) {
                this.log.error("Received end of connection, but no identification received. ");
                throw new TransportException("Server closed connection during identification exchange");
            }
            buf.putByte((byte)b2);
        }
    }

    private void sendClientIdent() throws IOException {
        this.log.info("Client identity string: {}", (Object)this.clientID);
        this.connInfo.out.write((this.clientID + "\r\n").getBytes(IOUtils.UTF8));
        this.connInfo.out.flush();
    }

    private String readIdentification(Buffer.PlainBuffer buffer) throws IOException {
        String ident = new IdentificationStringParser(buffer, this.loggerFactory).parseIdentificationString();
        if (ident.isEmpty()) {
            return ident;
        }
        if (!ident.startsWith("SSH-2.0-") && !ident.startsWith("SSH-1.99-")) {
            throw new TransportException(DisconnectReason.PROTOCOL_VERSION_NOT_SUPPORTED, "Server does not support SSHv2, identified as: " + ident);
        }
        return ident;
    }

    @Override
    public void addHostKeyVerifier(HostKeyVerifier hkv) {
        this.kexer.addHostKeyVerifier(hkv);
    }

    @Override
    public void addAlgorithmsVerifier(AlgorithmsVerifier verifier) {
        this.kexer.addAlgorithmsVerifier(verifier);
    }

    @Override
    public void doKex() throws TransportException {
        this.kexer.startKex(true);
    }

    public boolean isKexDone() {
        return this.kexer.isKexDone();
    }

    @Override
    public int getTimeoutMs() {
        return this.timeoutMs;
    }

    @Override
    public void setTimeoutMs(int timeoutMs) {
        this.timeoutMs = timeoutMs;
    }

    @Override
    public String getRemoteHost() {
        return this.connInfo.host;
    }

    @Override
    public int getRemotePort() {
        return this.connInfo.port;
    }

    @Override
    public String getClientVersion() {
        return this.clientID.substring(8);
    }

    @Override
    public Config getConfig() {
        return this.config;
    }

    @Override
    public String getServerVersion() {
        return this.serverID == null ? null : this.serverID.substring(8);
    }

    @Override
    public byte[] getSessionID() {
        return this.kexer.getSessionID();
    }

    @Override
    public synchronized Service getService() {
        return this.service;
    }

    @Override
    public synchronized void setService(Service service) {
        if (service == null) {
            service = this.nullService;
        }
        this.log.debug("Setting active service to {}", (Object)service.getName());
        this.service = service;
    }

    @Override
    public void reqService(Service service) throws TransportException {
        this.serviceAccept.lock();
        try {
            this.serviceAccept.clear();
            this.nextService = service;
            this.sendServiceRequest(service.getName());
            this.serviceAccept.await(this.timeoutMs, TimeUnit.MILLISECONDS);
        }
        finally {
            this.serviceAccept.unlock();
            this.nextService = null;
        }
    }

    private void sendServiceRequest(String serviceName) throws TransportException {
        this.log.debug("Sending SSH_MSG_SERVICE_REQUEST for {}", (Object)serviceName);
        this.write((SSHPacket)new SSHPacket(Message.SERVICE_REQUEST).putString(serviceName));
    }

    @Override
    public void setAuthenticated() {
        this.authed = true;
        this.encoder.setAuthenticated();
        this.decoder.setAuthenticated();
    }

    @Override
    public boolean isAuthenticated() {
        return this.authed;
    }

    @Override
    public long sendUnimplemented() throws TransportException {
        long seq = this.decoder.getSequenceNumber();
        this.log.debug("Sending SSH_MSG_UNIMPLEMENTED for packet #{}", (Object)seq);
        return this.write((SSHPacket)new SSHPacket(Message.UNIMPLEMENTED).putUInt32(seq));
    }

    @Override
    public void join() throws TransportException {
        this.close.await();
    }

    @Override
    public void join(int timeout2, TimeUnit unit) throws TransportException {
        this.close.await(timeout2, unit);
    }

    @Override
    public boolean isRunning() {
        return this.reader.isAlive() && !this.close.isSet();
    }

    @Override
    public void disconnect() {
        this.disconnect(DisconnectReason.BY_APPLICATION);
    }

    @Override
    public void disconnect(DisconnectReason reason) {
        this.disconnect(reason, "");
    }

    @Override
    public void disconnect(DisconnectReason reason, String message) {
        this.close.lock();
        try {
            if (this.isRunning()) {
                this.disconnectListener.notifyDisconnect(reason, message);
                this.getService().notifyError(new TransportException(reason, "Disconnected"));
                this.sendDisconnect(reason, message);
                this.finishOff();
                this.close.set();
            }
        }
        finally {
            this.close.unlock();
        }
    }

    @Override
    public void setDisconnectListener(DisconnectListener listener) {
        this.disconnectListener = listener == null ? this : listener;
    }

    @Override
    public DisconnectListener getDisconnectListener() {
        return this.disconnectListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long write(SSHPacket payload) throws TransportException {
        this.writeLock.lock();
        try {
            if (this.kexer.isKexOngoing()) {
                Message m2 = Message.fromByte(payload.array()[payload.rpos()]);
                if (!m2.in(1, 49) || m2 == Message.SERVICE_REQUEST) {
                    assert (m2 != Message.KEXINIT);
                    this.kexer.waitForDone();
                }
            } else if (this.encoder.isSequenceNumberAtMax()) {
                this.kexer.startKex(true);
            }
            long seq = this.encoder.encode(payload);
            try {
                this.connInfo.out.write(payload.array(), payload.rpos(), payload.available());
                this.connInfo.out.flush();
            }
            catch (IOException ioe) {
                throw new TransportException(ioe);
            }
            long l2 = seq;
            return l2;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private void sendDisconnect(DisconnectReason reason, String message) {
        if (message == null) {
            message = "";
        }
        this.log.debug("Sending SSH_MSG_DISCONNECT: reason=[{}], msg=[{}]", (Object)reason, (Object)message);
        try {
            this.write((SSHPacket)((SSHPacket)((SSHPacket)new SSHPacket(Message.DISCONNECT).putUInt32(reason.toInt())).putString(message)).putString(""));
        }
        catch (IOException worthless) {
            this.log.debug("Error writing packet: {}", (Object)worthless.toString());
        }
    }

    @Override
    public void handle(Message msg, SSHPacket buf) throws SSHException {
        this.msg = msg;
        this.log.trace("Received packet {}", (Object)msg);
        if (this.kexer.isInitialKex()) {
            if (this.decoder.isSequenceNumberAtMax()) {
                throw new TransportException(DisconnectReason.KEY_EXCHANGE_FAILED, "Sequence number of decoder is about to wrap during initial key exchange");
            }
            if (this.kexer.isStrictKex() && !TransportImpl.isKexerPacket(msg) && msg != Message.DISCONNECT) {
                throw new TransportException(DisconnectReason.KEY_EXCHANGE_FAILED, "Unexpected packet type during initial strict key exchange");
            }
        }
        if (msg.geq(50)) {
            this.service.handle(msg, buf);
        } else if (TransportImpl.isKexerPacket(msg)) {
            this.kexer.handle(msg, buf);
        } else {
            switch (msg) {
                case DISCONNECT: {
                    this.gotDisconnect(buf);
                    break;
                }
                case IGNORE: {
                    this.log.debug("Received SSH_MSG_IGNORE");
                    break;
                }
                case UNIMPLEMENTED: {
                    this.gotUnimplemented(buf);
                    break;
                }
                case DEBUG: {
                    this.gotDebug(buf);
                    break;
                }
                case SERVICE_ACCEPT: {
                    this.gotServiceAccept();
                    break;
                }
                case EXT_INFO: {
                    this.log.debug("Received SSH_MSG_EXT_INFO");
                    break;
                }
                case USERAUTH_BANNER: {
                    this.log.debug("Received USERAUTH_BANNER");
                    break;
                }
                default: {
                    this.sendUnimplemented();
                }
            }
        }
    }

    private static boolean isKexerPacket(Message msg) {
        return msg.in(20, 21) || msg.in(30, 49);
    }

    private void gotDebug(SSHPacket buf) throws TransportException {
        try {
            boolean display = buf.readBoolean();
            String message = buf.readString();
            this.log.debug("Received SSH_MSG_DEBUG (display={}) '{}'", (Object)display, (Object)message);
        }
        catch (Buffer.BufferException be2) {
            throw new TransportException(be2);
        }
    }

    private void gotDisconnect(SSHPacket buf) throws TransportException {
        try {
            DisconnectReason code2 = DisconnectReason.fromInt(buf.readUInt32AsInt());
            String message = buf.readString();
            this.log.info("Received SSH_MSG_DISCONNECT (reason={}, msg={})", (Object)code2, (Object)message);
            throw new TransportException(code2, message);
        }
        catch (Buffer.BufferException be2) {
            throw new TransportException(be2);
        }
    }

    private void gotServiceAccept() throws TransportException {
        this.serviceAccept.lock();
        try {
            if (!this.serviceAccept.hasWaiters()) {
                throw new TransportException(DisconnectReason.PROTOCOL_ERROR, "Got a service accept notification when none was awaited");
            }
            this.setService(this.nextService);
            this.serviceAccept.set();
        }
        finally {
            this.serviceAccept.unlock();
        }
    }

    private void gotUnimplemented(SSHPacket packet) throws SSHException {
        long seqNum = packet.readUInt32();
        this.log.debug("Received SSH_MSG_UNIMPLEMENTED #{}", (Object)seqNum);
        if (this.kexer.isKexOngoing()) {
            throw new TransportException("Received SSH_MSG_UNIMPLEMENTED while exchanging keys");
        }
        this.getService().notifyUnimplemented(seqNum);
    }

    private void finishOff() {
        this.reader.interrupt();
        IOUtils.closeQuietly(this.connInfo.in);
        IOUtils.closeQuietly(this.connInfo.out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void die(Exception ex2) {
        this.close.lock();
        try {
            if (!this.close.isSet()) {
                boolean gotRequiredInfo;
                this.log.error("Dying because - {}", (Object)ex2.getMessage(), (Object)ex2);
                SSHException causeOfDeath = SSHException.chainer.chain(ex2);
                this.disconnectListener.notifyDisconnect(causeOfDeath.getDisconnectReason(), causeOfDeath.getMessage());
                ErrorDeliveryUtil.alertEvents((Throwable)causeOfDeath, this.close, this.serviceAccept);
                this.kexer.notifyError(causeOfDeath);
                this.getService().notifyError(causeOfDeath);
                this.setService(this.nullService);
                boolean didNotReceiveDisconnect = this.msg != Message.DISCONNECT;
                boolean bl2 = gotRequiredInfo = causeOfDeath.getDisconnectReason() != DisconnectReason.UNKNOWN;
                if (didNotReceiveDisconnect && gotRequiredInfo) {
                    this.sendDisconnect(causeOfDeath.getDisconnectReason(), causeOfDeath.getMessage());
                }
                this.finishOff();
                this.close.set();
            }
        }
        finally {
            this.close.unlock();
        }
    }

    String getClientID() {
        return this.clientID;
    }

    String getServerID() {
        return this.serverID;
    }

    Encoder getEncoder() {
        return this.encoder;
    }

    Decoder getDecoder() {
        return this.decoder;
    }

    ReentrantLock getWriteLock() {
        return this.writeLock;
    }

    ConnInfo getConnInfo() {
        return this.connInfo;
    }

    public void setHostKeyAlgorithm(KeyAlgorithm keyAlgorithm) {
        this.hostKeyAlgorithm = keyAlgorithm;
    }

    @Override
    public KeyAlgorithm getHostKeyAlgorithm() {
        return this.hostKeyAlgorithm;
    }

    @Override
    public List<KeyAlgorithm> getClientKeyAlgorithms(KeyType keyType) throws TransportException {
        List<Factory.Named<KeyAlgorithm>> factories = this.getConfig().getKeyAlgorithms();
        ArrayList<KeyAlgorithm> available = new ArrayList<KeyAlgorithm>();
        if (factories != null) {
            for (Factory.Named<KeyAlgorithm> f2 : factories) {
                if ((!(f2 instanceof KeyAlgorithms.Factory) || !((KeyAlgorithms.Factory)f2).getKeyType().equals((Object)keyType)) && (f2 instanceof KeyAlgorithms.Factory || !f2.getName().equals(keyType.toString()))) continue;
                available.add((KeyAlgorithm)f2.create());
            }
        }
        if (available.isEmpty()) {
            throw new TransportException("Cannot find an available KeyAlgorithm for type " + (Object)((Object)keyType));
        }
        return available;
    }

    static final class ConnInfo {
        final String host;
        final int port;
        final InputStream in;
        final OutputStream out;

        ConnInfo(String host, int port, InputStream in, OutputStream out) {
            this.host = host;
            this.port = port;
            this.in = in;
            this.out = out;
        }
    }

    private static final class NullService
    extends AbstractService {
        NullService(Transport trans) {
            super("null-service", trans);
        }
    }
}

