/*
 * Decompiled with CFR 0.152.
 */
package nonapi.io.github.classgraph.classloaderhandler;

import io.github.classgraph.ClassGraphClassLoader;
import java.net.URL;
import nonapi.io.github.classgraph.classloaderhandler.ClassLoaderHandler;
import nonapi.io.github.classgraph.classpath.ClassLoaderFinder;
import nonapi.io.github.classgraph.classpath.ClassLoaderOrder;
import nonapi.io.github.classgraph.classpath.ClasspathOrder;
import nonapi.io.github.classgraph.scanspec.ScanSpec;
import nonapi.io.github.classgraph.utils.LogNode;

class ClassGraphClassLoaderHandler
implements ClassLoaderHandler {
    private ClassGraphClassLoaderHandler() {
    }

    public static boolean canHandle(Class<?> classLoaderClass, LogNode log2) {
        boolean matches = ClassLoaderFinder.classIsOrExtendsOrImplements(classLoaderClass, "io.github.classgraph.ClassGraphClassLoader");
        if (matches && log2 != null) {
            log2.log("Sharing a `ClassGraphClassLoader` between multiple nested scans is not advisable, because scan criteria may differ between scans. See: https://github.com/classgraph/classgraph/issues/485");
        }
        return matches;
    }

    public static void findClassLoaderOrder(ClassLoader classLoader, ClassLoaderOrder classLoaderOrder, LogNode log2) {
        classLoaderOrder.delegateTo(classLoader.getParent(), true, log2);
        classLoaderOrder.add(classLoader, log2);
    }

    public static void findClasspathOrder(ClassLoader classLoader, ClasspathOrder classpathOrder, ScanSpec scanSpec, LogNode log2) {
        for (URL url : ((ClassGraphClassLoader)classLoader).getURLs()) {
            if (url == null) continue;
            classpathOrder.addClasspathEntry((Object)url, classLoader, scanSpec, log2);
        }
    }
}

