/*
 * Decompiled with CFR 0.152.
 */
package nonapi.io.github.classgraph.classpath;

import java.util.LinkedHashSet;
import nonapi.io.github.classgraph.classpath.CallStackReader;
import nonapi.io.github.classgraph.reflection.ReflectionUtils;
import nonapi.io.github.classgraph.scanspec.ScanSpec;
import nonapi.io.github.classgraph.utils.LogNode;

public class ClassLoaderFinder {
    private final ClassLoader[] contextClassLoaders;

    public ClassLoader[] getContextClassLoaders() {
        return this.contextClassLoaders;
    }

    public static boolean classIsOrExtendsOrImplements(Class<?> cls, String className) {
        if (cls == null) {
            return false;
        }
        if (cls.getName().equals(className)) {
            return true;
        }
        if (ClassLoaderFinder.classIsOrExtendsOrImplements(cls.getSuperclass(), className)) {
            return true;
        }
        for (Class<?> iface : cls.getInterfaces()) {
            if (!ClassLoaderFinder.classIsOrExtendsOrImplements(iface, className)) continue;
            return true;
        }
        return false;
    }

    ClassLoaderFinder(ScanSpec scanSpec, ReflectionUtils reflectionUtils, LogNode log2) {
        LogNode classLoadersFoundLog;
        LinkedHashSet<Object> classLoadersUnique;
        if (scanSpec.overrideClassLoaders == null) {
            block11: {
                ClassLoader systemClassLoader;
                ClassLoader classLoader;
                classLoadersUnique = new LinkedHashSet();
                ClassLoader threadClassLoader = Thread.currentThread().getContextClassLoader();
                if (threadClassLoader != null) {
                    classLoadersUnique.add(threadClassLoader);
                }
                if ((classLoader = this.getClass().getClassLoader()) != null) {
                    classLoadersUnique.add(classLoader);
                }
                if ((systemClassLoader = ClassLoader.getSystemClassLoader()) != null) {
                    classLoadersUnique.add(systemClassLoader);
                }
                try {
                    Class<?>[] callStack = new CallStackReader(reflectionUtils).getClassContext(log2);
                    for (int i2 = callStack.length - 1; i2 >= 0; --i2) {
                        ClassLoader callerClassLoader = callStack[i2].getClassLoader();
                        if (callerClassLoader == null) continue;
                        classLoadersUnique.add(callerClassLoader);
                    }
                }
                catch (IllegalArgumentException e2) {
                    if (log2 == null) break block11;
                    log2.log("Could not get call stack", e2);
                }
            }
            if (scanSpec.addedClassLoaders != null) {
                classLoadersUnique.addAll(scanSpec.addedClassLoaders);
            }
            classLoadersFoundLog = log2 == null ? null : log2.log("Found ClassLoaders:");
        } else {
            classLoadersUnique = new LinkedHashSet<ClassLoader>(scanSpec.overrideClassLoaders);
            LogNode logNode = classLoadersFoundLog = log2 == null ? null : log2.log("Override ClassLoaders:");
        }
        if (classLoadersFoundLog != null) {
            for (ClassLoader classLoader : classLoadersUnique) {
                classLoadersFoundLog.log(classLoader.getClass().getName());
            }
        }
        this.contextClassLoaders = classLoadersUnique.toArray(new ClassLoader[0]);
    }
}

