/*
 * Decompiled with CFR 0.152.
 */
package one.util.streamex;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.stream.StreamSupport;

abstract class CrossSpliterator<T, A>
implements Spliterator<A> {
    long est;
    int splitPos;
    final Spliterator<T>[] spliterators;
    final Collection<T>[] collections;

    CrossSpliterator(Collection<? extends Collection<T>> source2) {
        this.splitPos = 0;
        long est = 1L;
        try {
            for (Collection<Collection> collection : source2) {
                long size = collection.size();
                est = StrictMath.multiplyExact(est, size);
            }
        }
        catch (ArithmeticException e2) {
            est = Long.MAX_VALUE;
        }
        this.est = est;
        this.collections = source2.toArray(new Collection[0]);
        this.spliterators = new Spliterator[this.collections.length];
    }

    abstract Spliterator<A> doSplit(long var1, Spliterator<T>[] var3, Collection<T>[] var4);

    abstract void accumulate(int var1, T var2);

    CrossSpliterator(long est, int splitPos, Spliterator<T>[] spliterators, Collection<T>[] collections) {
        this.est = est;
        this.splitPos = splitPos;
        this.spliterators = spliterators;
        this.collections = collections;
    }

    boolean advance(int i2) {
        Consumer<Object> action;
        if (this.spliterators[i2] == null) {
            if (i2 > 0 && this.collections[i2 - 1] != null && !this.advance(i2 - 1)) {
                return false;
            }
            this.spliterators[i2] = this.collections[i2].spliterator();
        }
        if (!this.spliterators[i2].tryAdvance(action = t2 -> this.accumulate(i2, t2))) {
            if (i2 == 0 || this.collections[i2 - 1] == null || !this.advance(i2 - 1)) {
                return false;
            }
            this.spliterators[i2] = this.collections[i2].spliterator();
            return this.spliterators[i2].tryAdvance(action);
        }
        return true;
    }

    @Override
    public Spliterator<A> trySplit() {
        Spliterator<T> res2;
        if (this.spliterators[this.splitPos] == null) {
            this.spliterators[this.splitPos] = this.collections[this.splitPos].spliterator();
        }
        if ((res2 = this.spliterators[this.splitPos].trySplit()) == null) {
            if (this.splitPos == this.spliterators.length - 1) {
                return null;
            }
            Object[] arr = StreamSupport.stream(this.spliterators[this.splitPos], false).toArray();
            if (arr.length == 0) {
                return null;
            }
            if (arr.length == 1) {
                this.accumulate(this.splitPos, arr[0]);
                ++this.splitPos;
                return this.trySplit();
            }
            this.spliterators[this.splitPos] = Spliterators.spliterator(arr, 16);
            return this.trySplit();
        }
        long prefixEst = Long.MAX_VALUE;
        long newEst = this.spliterators[this.splitPos].getExactSizeIfKnown();
        if (newEst == -1L) {
            newEst = Long.MAX_VALUE;
        } else {
            try {
                for (int i2 = this.splitPos + 1; i2 < this.collections.length; ++i2) {
                    long size = this.collections[i2].size();
                    newEst = StrictMath.multiplyExact(newEst, size);
                }
                if (this.est != Long.MAX_VALUE) {
                    prefixEst = this.est - newEst;
                }
            }
            catch (ArithmeticException e2) {
                newEst = Long.MAX_VALUE;
            }
        }
        Spliterator[] prefixSpliterators = (Spliterator[])this.spliterators.clone();
        Collection[] prefixCollections = (Collection[])this.collections.clone();
        prefixSpliterators[this.splitPos] = res2;
        this.est = newEst;
        Arrays.fill(this.spliterators, this.splitPos + 1, this.spliterators.length, null);
        return this.doSplit(prefixEst, prefixSpliterators, prefixCollections);
    }

    @Override
    public long estimateSize() {
        return this.est;
    }

    @Override
    public int characteristics() {
        int sized = this.est < Long.MAX_VALUE ? 64 : 0;
        return 0x10 | sized;
    }

    static final class ToList<T>
    extends CrossSpliterator<T, List<T>> {
        private List<T> elements;

        ToList(Collection<? extends Collection<T>> source2) {
            super(source2);
            this.elements = Arrays.asList(new Object[this.collections.length]);
        }

        private ToList(long est, int splitPos, Spliterator<T>[] spliterators, Collection<T>[] collections, List<T> elements) {
            super(est, splitPos, spliterators, collections);
            this.elements = elements;
        }

        @Override
        public boolean tryAdvance(Consumer<? super List<T>> action) {
            if (this.elements == null) {
                return false;
            }
            if (this.est < Long.MAX_VALUE && this.est > 0L) {
                --this.est;
            }
            if (this.advance(this.collections.length - 1)) {
                action.accept(new ArrayList<T>(this.elements));
                return true;
            }
            this.elements = null;
            this.est = 0L;
            return false;
        }

        @Override
        public void forEachRemaining(Consumer<? super List<T>> action) {
            if (this.elements == null) {
                return;
            }
            List<T> e2 = this.elements;
            int l2 = this.collections.length - 1;
            while (this.advance(l2)) {
                action.accept(new ArrayList<T>(e2));
            }
            this.elements = null;
            this.est = 0L;
        }

        @Override
        Spliterator<List<T>> doSplit(long prefixEst, Spliterator<T>[] prefixSpliterators, Collection<T>[] prefixCollections) {
            List<Object> prefixElements = Arrays.asList(this.elements.toArray());
            return new ToList<Object>(prefixEst, this.splitPos, prefixSpliterators, prefixCollections, prefixElements);
        }

        @Override
        void accumulate(int pos, T t2) {
            this.elements.set(pos, t2);
        }
    }

    static final class Reducing<T, A>
    extends CrossSpliterator<T, A> {
        private A[] elements;
        private final BiFunction<A, ? super T, A> accumulator;

        Reducing(Collection<? extends Collection<T>> source2, A identity, BiFunction<A, ? super T, A> accumulator) {
            super(source2);
            this.accumulator = accumulator;
            this.elements = new Object[this.collections.length + 1];
            this.elements[0] = identity;
        }

        private Reducing(long est, int splitPos, BiFunction<A, ? super T, A> accumulator, Spliterator<T>[] spliterators, Collection<T>[] collections, A[] elements) {
            super(est, splitPos, spliterators, collections);
            this.accumulator = accumulator;
            this.elements = elements;
        }

        @Override
        public boolean tryAdvance(Consumer<? super A> action) {
            int l2;
            if (this.elements == null) {
                return false;
            }
            if (this.est < Long.MAX_VALUE && this.est > 0L) {
                --this.est;
            }
            if (this.advance((l2 = this.collections.length) - 1)) {
                action.accept(this.elements[l2]);
                return true;
            }
            this.elements = null;
            this.est = 0L;
            return false;
        }

        @Override
        public void forEachRemaining(Consumer<? super A> action) {
            if (this.elements == null) {
                return;
            }
            int l2 = this.collections.length;
            A[] e2 = this.elements;
            while (this.advance(l2 - 1)) {
                action.accept(e2[l2]);
            }
            this.elements = null;
            this.est = 0L;
        }

        @Override
        Spliterator<A> doSplit(long prefixEst, Spliterator<T>[] prefixSpliterators, Collection<T>[] prefixCollections) {
            return new Reducing<T, Object>(prefixEst, this.splitPos, this.accumulator, prefixSpliterators, prefixCollections, (Object[])this.elements.clone());
        }

        @Override
        void accumulate(int pos, T t2) {
            this.elements[pos + 1] = this.accumulator.apply(this.elements[pos], t2);
        }
    }
}

