/*
 * Decompiled with CFR 0.152.
 */
package org.HdrHistogram.packedarray;

import java.io.Serializable;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.HdrHistogram.packedarray.AbstractPackedArrayContext;
import org.HdrHistogram.packedarray.IterationValue;
import org.HdrHistogram.packedarray.ResizeException;

public abstract class AbstractPackedLongArray
implements Iterable<Long>,
Serializable {
    private static final int NUMBER_OF_SETS = 8;
    private AbstractPackedArrayContext arrayContext;
    private long startTimeStampMsec = Long.MAX_VALUE;
    private long endTimeStampMsec = 0L;
    static final int NUMBER_OF_NON_ZEROS_TO_HASH = 8;

    AbstractPackedArrayContext getArrayContext() {
        return this.arrayContext;
    }

    void setArrayContext(AbstractPackedArrayContext newArrayContext) {
        this.arrayContext = newArrayContext;
    }

    public long getStartTimeStamp() {
        return this.startTimeStampMsec;
    }

    public void setStartTimeStamp(long timeStampMsec) {
        this.startTimeStampMsec = timeStampMsec;
    }

    public long getEndTimeStamp() {
        return this.endTimeStampMsec;
    }

    public void setEndTimeStamp(long timeStampMsec) {
        this.endTimeStampMsec = timeStampMsec;
    }

    public abstract void setVirtualLength(int var1);

    public abstract AbstractPackedLongArray copy();

    abstract void resizeStorageArray(int var1);

    abstract void clearContents();

    abstract long criticalSectionEnter();

    abstract void criticalSectionExit(long var1);

    public String toString() {
        String output2 = "PackedArray:\n";
        AbstractPackedArrayContext arrayContext = this.getArrayContext();
        output2 = output2 + arrayContext.toString();
        return output2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long get(int index) {
        long value = 0L;
        for (int byteNum = 0; byteNum < 8; ++byteNum) {
            int packedIndex = 0;
            long byteValueAtPackedIndex = 0L;
            do {
                int newArraySize = 0;
                long criticalValue = this.criticalSectionEnter();
                try {
                    AbstractPackedArrayContext arrayContext = this.getArrayContext();
                    if (!arrayContext.isPacked()) {
                        long l2 = arrayContext.getAtUnpackedIndex(index);
                        return l2;
                    }
                    packedIndex = arrayContext.getPackedIndex(byteNum, index, false);
                    if (packedIndex < 0) {
                        long l3 = value;
                        return l3;
                    }
                    byteValueAtPackedIndex = ((long)arrayContext.getAtByteIndex(packedIndex) & 0xFFL) << (byteNum << 3);
                }
                catch (ResizeException ex2) {
                    newArraySize = ex2.getNewSize();
                }
                finally {
                    this.criticalSectionExit(criticalValue);
                    if (newArraySize != 0) {
                        this.resizeStorageArray(newArraySize);
                    }
                }
            } while (packedIndex == 0);
            value += byteValueAtPackedIndex;
        }
        return value;
    }

    public void increment(int index) {
        this.add(index, 1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(int index, long value) {
        if (value == 0L) {
            return;
        }
        long remainingValueToAdd = value;
        while (true) {
            try {
                long byteMask = 255L;
                int byteNum = 0;
                int byteShift = 0;
                while (byteNum < 8) {
                    long criticalValue = this.criticalSectionEnter();
                    try {
                        AbstractPackedArrayContext arrayContext = this.getArrayContext();
                        if (!arrayContext.isPacked()) {
                            arrayContext.addAndGetAtUnpackedIndex(index, remainingValueToAdd);
                            return;
                        }
                        int packedIndex = arrayContext.getPackedIndex(byteNum, index, true);
                        long amountToAddAtSet = remainingValueToAdd & byteMask;
                        byte byteToAdd = (byte)(amountToAddAtSet >> byteShift);
                        long afterAddByteValue = arrayContext.addAtByteIndex(packedIndex, byteToAdd);
                        remainingValueToAdd -= amountToAddAtSet;
                        long carryAmount = afterAddByteValue & 0x100L;
                        if ((remainingValueToAdd += carryAmount << byteShift) == 0L) {
                            return;
                        }
                    }
                    finally {
                        this.criticalSectionExit(criticalValue);
                    }
                    ++byteNum;
                    byteShift += 8;
                    byteMask <<= 8;
                }
                return;
            }
            catch (ResizeException ex2) {
                this.resizeStorageArray(ex2.getNewSize());
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(int index, long value) {
        int bytesAlreadySet = 0;
        while (true) {
            long valueForNextLevels = value;
            try {
                for (int byteNum = 0; byteNum < 8; ++byteNum) {
                    long criticalValue = this.criticalSectionEnter();
                    try {
                        int packedIndex;
                        AbstractPackedArrayContext arrayContext = this.getArrayContext();
                        if (!arrayContext.isPacked()) {
                            arrayContext.setAtUnpackedIndex(index, value);
                            return;
                        }
                        if (valueForNextLevels == 0L && (packedIndex = arrayContext.getPackedIndex(byteNum, index, false)) < 0) {
                            return;
                        }
                        packedIndex = arrayContext.getPackedIndex(byteNum, index, true);
                        byte byteToWrite = (byte)(valueForNextLevels & 0xFFL);
                        valueForNextLevels >>= 8;
                        if (byteNum < bytesAlreadySet) continue;
                        arrayContext.setAtByteIndex(packedIndex, byteToWrite);
                        ++bytesAlreadySet;
                        continue;
                    }
                    finally {
                        this.criticalSectionExit(criticalValue);
                    }
                }
                return;
            }
            catch (ResizeException ex2) {
                this.resizeStorageArray(ex2.getNewSize());
                continue;
            }
            break;
        }
    }

    public void add(AbstractPackedLongArray other) {
        for (IterationValue v2 : other.nonZeroValues()) {
            this.add(v2.getIndex(), v2.getValue());
        }
    }

    public void clear() {
        this.clearContents();
    }

    public int getPhysicalLength() {
        return this.getArrayContext().length();
    }

    public int length() {
        return this.getArrayContext().getVirtualLength();
    }

    @Override
    public Iterator<Long> iterator() {
        return new AllValuesIterator();
    }

    public Iterable<IterationValue> nonZeroValues() {
        return this.getArrayContext().nonZeroValues();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof AbstractPackedLongArray)) {
            return false;
        }
        AbstractPackedLongArray that = (AbstractPackedLongArray)other;
        if (this.length() != that.length()) {
            return false;
        }
        if (this.arrayContext.isPacked() || that.arrayContext.isPacked()) {
            for (IterationValue v2 : this.nonZeroValues()) {
                if (that.get(v2.getIndex()) == v2.getValue()) continue;
                return false;
            }
            for (IterationValue v2 : that.nonZeroValues()) {
                if (this.get(v2.getIndex()) == v2.getValue()) continue;
                return false;
            }
        } else {
            for (int i2 = 0; i2 < this.length(); ++i2) {
                if (this.get(i2) == that.get(i2)) continue;
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        int h7 = 0;
        h7 = this.oneAtATimeHashStep(h7, this.length());
        int count = 0;
        for (IterationValue v2 : this.nonZeroValues()) {
            if (++count > 8) break;
            h7 = this.oneAtATimeHashStep(h7, v2.getIndex());
            h7 = this.oneAtATimeHashStep(h7, (int)v2.getValue());
        }
        h7 += h7 << 3;
        h7 ^= h7 >> 11;
        h7 += h7 << 15;
        return h7;
    }

    private int oneAtATimeHashStep(int incomingHash, int v2) {
        int h7 = incomingHash;
        h7 += v2;
        h7 += h7 << 10;
        h7 ^= h7 >> 6;
        return h7;
    }

    class AllValuesIterator
    implements Iterator<Long> {
        int nextVirtualIndex = 0;

        AllValuesIterator() {
        }

        @Override
        public Long next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return AbstractPackedLongArray.this.get(this.nextVirtualIndex++);
        }

        @Override
        public boolean hasNext() {
            return this.nextVirtualIndex >= 0 && this.nextVirtualIndex < AbstractPackedLongArray.this.length();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

