/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.cli.help;

import java.util.function.Supplier;
import org.apache.commons.cli.help.Util;

public final class TextStyle {
    public static final int UNSET_MAX_WIDTH = Integer.MAX_VALUE;
    public static final TextStyle DEFAULT = TextStyle.builder().get();
    private final Alignment alignment;
    private final int leftPad;
    private final int indent;
    private final boolean scalable;
    private final int minWidth;
    private final int maxWidth;

    public static Builder builder() {
        return new Builder();
    }

    private TextStyle(Builder builder) {
        this.alignment = builder.alignment;
        this.leftPad = builder.leftPad;
        this.indent = builder.indent;
        this.scalable = builder.scalable;
        this.minWidth = builder.minWidth;
        this.maxWidth = builder.maxWidth;
    }

    public Alignment getAlignment() {
        return this.alignment;
    }

    public int getIndent() {
        return this.indent;
    }

    public int getLeftPad() {
        return this.leftPad;
    }

    public int getMaxWidth() {
        return this.maxWidth;
    }

    public int getMinWidth() {
        return this.minWidth;
    }

    public boolean isScalable() {
        return this.scalable;
    }

    public CharSequence pad(boolean addIndent, CharSequence text) {
        if (text.length() >= this.maxWidth) {
            return text;
        }
        StringBuilder sb = new StringBuilder();
        switch (this.alignment.ordinal()) {
            case 1: {
                int padLen = this.maxWidth == Integer.MAX_VALUE ? (addIndent ? this.indent : 0) : this.maxWidth - text.length();
                int left = padLen / 2;
                String indentPad = Util.repeatSpace(left);
                String rest = Util.repeatSpace(padLen - left);
                sb.append(indentPad).append(text).append(rest);
                break;
            }
            default: {
                String rest;
                String indentPad;
                if (this.maxWidth == Integer.MAX_VALUE) {
                    indentPad = addIndent ? Util.repeatSpace(this.indent) : "";
                    rest = "";
                } else {
                    int restLen = this.maxWidth - text.length();
                    if (addIndent && restLen > this.indent) {
                        indentPad = Util.repeatSpace(this.indent);
                        restLen -= this.indent;
                    } else {
                        indentPad = "";
                    }
                    rest = Util.repeatSpace(restLen);
                }
                if (this.alignment == Alignment.LEFT) {
                    sb.append(indentPad).append(text).append(rest);
                    break;
                }
                sb.append(indentPad).append(rest).append(text);
            }
        }
        return sb.toString();
    }

    public String toString() {
        return String.format("TextStyle{%s, l:%s, i:%s, %s, min:%s, max:%s}", new Object[]{this.alignment, this.leftPad, this.indent, this.scalable, this.minWidth, this.maxWidth == Integer.MAX_VALUE ? "unset" : Integer.valueOf(this.maxWidth)});
    }

    public static enum Alignment {
        LEFT,
        CENTER,
        RIGHT;

    }

    public static final class Builder
    implements Supplier<TextStyle> {
        private Alignment alignment = Alignment.LEFT;
        private int leftPad;
        private int indent;
        private boolean scalable = true;
        private int minWidth;
        private int maxWidth = Integer.MAX_VALUE;

        private Builder() {
        }

        @Override
        public TextStyle get() {
            return new TextStyle(this);
        }

        public int getIndent() {
            return this.indent;
        }

        public int getLeftPad() {
            return this.leftPad;
        }

        public int getMaxWidth() {
            return this.maxWidth;
        }

        public int getMinWidth() {
            return this.minWidth;
        }

        public boolean isScalable() {
            return this.scalable;
        }

        public Builder setAlignment(Alignment alignment) {
            this.alignment = alignment;
            return this;
        }

        public Builder setIndent(int indent) {
            this.indent = indent;
            return this;
        }

        public Builder setLeftPad(int leftPad) {
            this.leftPad = leftPad;
            return this;
        }

        public Builder setMaxWidth(int maxWidth) {
            this.maxWidth = maxWidth;
            return this;
        }

        public Builder setMinWidth(int minWidth) {
            this.minWidth = minWidth;
            return this;
        }

        public Builder setScalable(boolean scalable) {
            this.scalable = scalable;
            return this;
        }

        public Builder setTextStyle(TextStyle style2) {
            this.alignment = style2.alignment;
            this.leftPad = style2.leftPad;
            this.indent = style2.indent;
            this.scalable = style2.scalable;
            this.minWidth = style2.minWidth;
            this.maxWidth = style2.maxWidth;
            return this;
        }
    }
}

