/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.zip;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import org.apache.commons.compress.archivers.zip.CharsetAccessor;
import org.apache.commons.compress.archivers.zip.ZipEncoding;
import org.apache.commons.compress.archivers.zip.ZipEncodingHelper;

final class NioZipEncoding
implements ZipEncoding,
CharsetAccessor {
    private static final char REPLACEMENT = '?';
    private static final byte[] REPLACEMENT_BYTES = new byte[]{63};
    private static final String REPLACEMENT_STRING = String.valueOf('?');
    private static final char[] HEX_CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private final Charset charset;
    private final boolean useReplacement;

    private static ByteBuffer encodeFully(CharsetEncoder enc, CharBuffer cb2, ByteBuffer out) {
        ByteBuffer o2 = out;
        while (cb2.hasRemaining()) {
            CoderResult result2 = enc.encode(cb2, o2, false);
            if (!result2.isOverflow()) continue;
            int increment = NioZipEncoding.estimateIncrementalEncodingSize(enc, cb2.remaining());
            o2 = ZipEncodingHelper.growBufferBy(o2, increment);
        }
        return o2;
    }

    private static CharBuffer encodeSurrogate(CharBuffer cb2, char c2) {
        cb2.position(0).limit(6);
        cb2.put('%');
        cb2.put('U');
        cb2.put(HEX_CHARS[c2 >> 12 & 0xF]);
        cb2.put(HEX_CHARS[c2 >> 8 & 0xF]);
        cb2.put(HEX_CHARS[c2 >> 4 & 0xF]);
        cb2.put(HEX_CHARS[c2 & 0xF]);
        cb2.flip();
        return cb2;
    }

    private static int estimateIncrementalEncodingSize(CharsetEncoder enc, int charCount) {
        return (int)Math.ceil((float)charCount * enc.averageBytesPerChar());
    }

    private static int estimateInitialBufferSize(CharsetEncoder enc, int charChount) {
        float first2 = enc.maxBytesPerChar();
        float rest = (float)(charChount - 1) * enc.averageBytesPerChar();
        return (int)Math.ceil(first2 + rest);
    }

    NioZipEncoding(Charset charset, boolean useReplacement) {
        this.charset = charset;
        this.useReplacement = useReplacement;
    }

    @Override
    public boolean canEncode(String name) {
        return this.newEncoder().canEncode(name);
    }

    @Override
    public String decode(byte[] data) throws IOException {
        return this.newDecoder().decode(ByteBuffer.wrap(data)).toString();
    }

    @Override
    public ByteBuffer encode(String name) {
        CharsetEncoder enc = this.newEncoder();
        CharBuffer cb2 = CharBuffer.wrap(name);
        CharBuffer tmp = null;
        ByteBuffer out = ByteBuffer.allocate(NioZipEncoding.estimateInitialBufferSize(enc, cb2.remaining()));
        while (cb2.hasRemaining()) {
            CoderResult res2 = enc.encode(cb2, out, false);
            if (res2.isUnmappable() || res2.isMalformed()) {
                int spaceForSurrogate = NioZipEncoding.estimateIncrementalEncodingSize(enc, 6 * res2.length());
                if (spaceForSurrogate > out.remaining()) {
                    int charCount = 0;
                    for (int i2 = cb2.position(); i2 < cb2.limit(); ++i2) {
                        charCount += !enc.canEncode(cb2.get(i2)) ? 6 : 1;
                    }
                    int totalExtraSpace = NioZipEncoding.estimateIncrementalEncodingSize(enc, charCount);
                    out = ZipEncodingHelper.growBufferBy(out, totalExtraSpace - out.remaining());
                }
                if (tmp == null) {
                    tmp = CharBuffer.allocate(6);
                }
                for (int i3 = 0; i3 < res2.length(); ++i3) {
                    out = NioZipEncoding.encodeFully(enc, NioZipEncoding.encodeSurrogate(tmp, cb2.get()), out);
                }
                continue;
            }
            if (res2.isOverflow()) {
                int increment = NioZipEncoding.estimateIncrementalEncodingSize(enc, cb2.remaining());
                out = ZipEncodingHelper.growBufferBy(out, increment);
                continue;
            }
            if (!res2.isUnderflow() && !res2.isError()) continue;
            break;
        }
        enc.encode(cb2, out, true);
        out.limit(out.position());
        out.rewind();
        return out;
    }

    @Override
    public Charset getCharset() {
        return this.charset;
    }

    private CharsetDecoder newDecoder() {
        if (!this.useReplacement) {
            return this.charset.newDecoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT);
        }
        return this.charset.newDecoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE).replaceWith(REPLACEMENT_STRING);
    }

    private CharsetEncoder newEncoder() {
        if (this.useReplacement) {
            return this.charset.newEncoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE).replaceWith(REPLACEMENT_BYTES);
        }
        return this.charset.newEncoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT);
    }
}

