/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.common;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.imaging.common.ImageMetadata;

public class GenericImageMetadata
implements ImageMetadata {
    private static final String NEWLINE = System.getProperty("line.separator");
    private final List<ImageMetadata.ImageMetadataItem> items = new ArrayList<ImageMetadata.ImageMetadataItem>();

    public void add(String keyword, String text) {
        this.add(new GenericImageMetadataItem(keyword, text));
    }

    public void add(ImageMetadata.ImageMetadataItem item) {
        this.items.add(item);
    }

    @Override
    public List<? extends ImageMetadata.ImageMetadataItem> getItems() {
        return new ArrayList<ImageMetadata.ImageMetadataItem>(this.items);
    }

    public String toString() {
        return this.toString(null);
    }

    @Override
    public String toString(String prefix) {
        if (null == prefix) {
            prefix = "";
        }
        StringBuilder result2 = new StringBuilder();
        for (int i2 = 0; i2 < this.items.size(); ++i2) {
            if (i2 > 0) {
                result2.append(NEWLINE);
            }
            ImageMetadata.ImageMetadataItem item = this.items.get(i2);
            result2.append(item.toString(prefix + "\t"));
        }
        return result2.toString();
    }

    public static class GenericImageMetadataItem
    implements ImageMetadata.ImageMetadataItem {
        private final String keyword;
        private final String text;

        public GenericImageMetadataItem(String keyword, String text) {
            this.keyword = keyword;
            this.text = text;
        }

        public String getKeyword() {
            return this.keyword;
        }

        public String getText() {
            return this.text;
        }

        @Override
        public String toString() {
            return this.toString(null);
        }

        @Override
        public String toString(String prefix) {
            String result2 = this.keyword + ": " + this.text;
            if (null != prefix) {
                return prefix + result2;
            }
            return result2;
        }
    }
}

