/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.jpeg.decoder;

import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.DirectColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Properties;
import org.apache.commons.imaging.ImageReadException;
import org.apache.commons.imaging.common.BinaryFileParser;
import org.apache.commons.imaging.common.BinaryFunctions;
import org.apache.commons.imaging.common.bytesource.ByteSource;
import org.apache.commons.imaging.formats.jpeg.JpegUtils;
import org.apache.commons.imaging.formats.jpeg.decoder.Block;
import org.apache.commons.imaging.formats.jpeg.decoder.Dct;
import org.apache.commons.imaging.formats.jpeg.decoder.JpegInputStream;
import org.apache.commons.imaging.formats.jpeg.decoder.YCbCrConverter;
import org.apache.commons.imaging.formats.jpeg.decoder.ZigZag;
import org.apache.commons.imaging.formats.jpeg.segments.DhtSegment;
import org.apache.commons.imaging.formats.jpeg.segments.DqtSegment;
import org.apache.commons.imaging.formats.jpeg.segments.SofnSegment;
import org.apache.commons.imaging.formats.jpeg.segments.SosSegment;

public class JpegDecoder
extends BinaryFileParser
implements JpegUtils.Visitor {
    private final DqtSegment.QuantizationTable[] quantizationTables = new DqtSegment.QuantizationTable[4];
    private final DhtSegment.HuffmanTable[] huffmanDCTables = new DhtSegment.HuffmanTable[4];
    private final DhtSegment.HuffmanTable[] huffmanACTables = new DhtSegment.HuffmanTable[4];
    private SofnSegment sofnSegment;
    private SosSegment sosSegment;
    private final float[][] scaledQuantizationTables = new float[4][];
    private BufferedImage image;
    private ImageReadException imageReadException;
    private IOException ioException;
    private final int[] zz = new int[64];
    private final int[] blockInt = new int[64];
    private final float[] block = new float[64];

    @Override
    public boolean beginSOS() {
        return true;
    }

    @Override
    public void visitSOS(int marker, byte[] markerBytes, byte[] imageData) {
        ByteArrayInputStream is = new ByteArrayInputStream(imageData);
        try {
            WritableRaster raster;
            DirectColorModel colorModel;
            int segmentLength = BinaryFunctions.read2Bytes("segmentLength", is, "Not a Valid JPEG File", this.getByteOrder());
            byte[] sosSegmentBytes = BinaryFunctions.readBytes("SosSegment", is, segmentLength - 2, "Not a Valid JPEG File");
            this.sosSegment = new SosSegment(marker, sosSegmentBytes);
            int hMax = 0;
            int vMax = 0;
            for (int i2 = 0; i2 < this.sofnSegment.numberOfComponents; ++i2) {
                hMax = Math.max(hMax, this.sofnSegment.getComponents((int)i2).horizontalSamplingFactor);
                vMax = Math.max(vMax, this.sofnSegment.getComponents((int)i2).verticalSamplingFactor);
            }
            int hSize = 8 * hMax;
            int vSize = 8 * vMax;
            JpegInputStream bitInputStream = new JpegInputStream(is);
            int xMCUs = (this.sofnSegment.width + hSize - 1) / hSize;
            int yMCUs = (this.sofnSegment.height + vSize - 1) / vSize;
            Block[] mcu = this.allocateMCUMemory();
            Block[] scaledMCU = new Block[mcu.length];
            for (int i3 = 0; i3 < scaledMCU.length; ++i3) {
                scaledMCU[i3] = new Block(hSize, vSize);
            }
            int[] preds = new int[this.sofnSegment.numberOfComponents];
            if (this.sofnSegment.numberOfComponents == 3) {
                colorModel = new DirectColorModel(24, 0xFF0000, 65280, 255);
                raster = Raster.createPackedRaster(3, this.sofnSegment.width, this.sofnSegment.height, new int[]{0xFF0000, 65280, 255}, null);
            } else if (this.sofnSegment.numberOfComponents == 1) {
                colorModel = new DirectColorModel(24, 0xFF0000, 65280, 255);
                raster = Raster.createPackedRaster(3, this.sofnSegment.width, this.sofnSegment.height, new int[]{0xFF0000, 65280, 255}, null);
            } else {
                throw new ImageReadException(this.sofnSegment.numberOfComponents + " components are invalid or unsupported");
            }
            DataBuffer dataBuffer = raster.getDataBuffer();
            for (int y1 = 0; y1 < vSize * yMCUs; y1 += vSize) {
                for (int x1 = 0; x1 < hSize * xMCUs; x1 += hSize) {
                    this.readMCU(bitInputStream, preds, mcu);
                    this.rescaleMCU(mcu, hSize, vSize, scaledMCU);
                    int srcRowOffset = 0;
                    int dstRowOffset = y1 * this.sofnSegment.width + x1;
                    for (int y2 = 0; y2 < vSize && y1 + y2 < this.sofnSegment.height; ++y2) {
                        for (int x2 = 0; x2 < hSize && x1 + x2 < this.sofnSegment.width; ++x2) {
                            int Y2;
                            if (scaledMCU.length == 3) {
                                Y2 = scaledMCU[0].samples[srcRowOffset + x2];
                                int Cb = scaledMCU[1].samples[srcRowOffset + x2];
                                int Cr = scaledMCU[2].samples[srcRowOffset + x2];
                                int rgb = YCbCrConverter.convertYCbCrToRGB(Y2, Cb, Cr);
                                dataBuffer.setElem(dstRowOffset + x2, rgb);
                                continue;
                            }
                            if (mcu.length == 1) {
                                Y2 = scaledMCU[0].samples[srcRowOffset + x2];
                                dataBuffer.setElem(dstRowOffset + x2, Y2 << 16 | Y2 << 8 | Y2);
                                continue;
                            }
                            throw new ImageReadException("Unsupported JPEG with " + mcu.length + " components");
                        }
                        srcRowOffset += hSize;
                        dstRowOffset += this.sofnSegment.width;
                    }
                }
            }
            this.image = new BufferedImage(colorModel, raster, colorModel.isAlphaPremultiplied(), new Properties());
        }
        catch (ImageReadException imageReadEx) {
            this.imageReadException = imageReadEx;
        }
        catch (IOException ioEx) {
            this.ioException = ioEx;
        }
        catch (RuntimeException ex2) {
            this.imageReadException = new ImageReadException("Error parsing JPEG", ex2);
        }
    }

    @Override
    public boolean visitSegment(int marker, byte[] markerBytes, int segmentLength, byte[] segmentLengthBytes, byte[] segmentData) throws ImageReadException, IOException {
        block11: {
            block12: {
                block10: {
                    int[] sofnSegments = new int[]{65472, 65473, 65474, 65475, 65477, 65478, 65479, 65481, 65482, 65483, 65485, 65486, 65487};
                    if (Arrays.binarySearch(sofnSegments, marker) < 0) break block10;
                    if (marker != 65472) {
                        throw new ImageReadException("Only sequential, baseline JPEGs are supported at the moment");
                    }
                    this.sofnSegment = new SofnSegment(marker, segmentData);
                    break block11;
                }
                if (marker != 65499) break block12;
                DqtSegment dqtSegment = new DqtSegment(marker, segmentData);
                for (int i2 = 0; i2 < dqtSegment.quantizationTables.size(); ++i2) {
                    DqtSegment.QuantizationTable table2 = dqtSegment.quantizationTables.get(i2);
                    if (0 > table2.destinationIdentifier || table2.destinationIdentifier >= this.quantizationTables.length) {
                        throw new ImageReadException("Invalid quantization table identifier " + table2.destinationIdentifier);
                    }
                    this.quantizationTables[table2.destinationIdentifier] = table2;
                    int[] quantizationMatrixInt = new int[64];
                    ZigZag.zigZagToBlock(table2.getElements(), quantizationMatrixInt);
                    float[] quantizationMatrixFloat = new float[64];
                    for (int j2 = 0; j2 < 64; ++j2) {
                        quantizationMatrixFloat[j2] = quantizationMatrixInt[j2];
                    }
                    Dct.scaleDequantizationMatrix(quantizationMatrixFloat);
                    this.scaledQuantizationTables[table2.destinationIdentifier] = quantizationMatrixFloat;
                }
                break block11;
            }
            if (marker != 65476) break block11;
            DhtSegment dhtSegment = new DhtSegment(marker, segmentData);
            for (int i3 = 0; i3 < dhtSegment.huffmanTables.size(); ++i3) {
                DhtSegment.HuffmanTable[] tables;
                DhtSegment.HuffmanTable table3 = dhtSegment.huffmanTables.get(i3);
                if (table3.tableClass == 0) {
                    tables = this.huffmanDCTables;
                } else if (table3.tableClass == 1) {
                    tables = this.huffmanACTables;
                } else {
                    throw new ImageReadException("Invalid huffman table class " + table3.tableClass);
                }
                if (0 > table3.destinationIdentifier || table3.destinationIdentifier >= tables.length) {
                    throw new ImageReadException("Invalid huffman table identifier " + table3.destinationIdentifier);
                }
                tables[table3.destinationIdentifier] = table3;
            }
        }
        return true;
    }

    private void rescaleMCU(Block[] dataUnits, int hSize, int vSize, Block[] ret) {
        for (int i2 = 0; i2 < dataUnits.length; ++i2) {
            Block dataUnit = dataUnits[i2];
            if (dataUnit.width == hSize && dataUnit.height == vSize) {
                System.arraycopy(dataUnit.samples, 0, ret[i2].samples, 0, hSize * vSize);
                continue;
            }
            int hScale = hSize / dataUnit.width;
            int vScale = vSize / dataUnit.height;
            if (hScale == 2 && vScale == 2) {
                int srcRowOffset = 0;
                int dstRowOffset = 0;
                for (int y2 = 0; y2 < dataUnit.height; ++y2) {
                    for (int x2 = 0; x2 < hSize; ++x2) {
                        int sample;
                        ret[i2].samples[dstRowOffset + x2] = sample = dataUnit.samples[srcRowOffset + (x2 >> 1)];
                        ret[i2].samples[dstRowOffset + hSize + x2] = sample;
                    }
                    srcRowOffset += dataUnit.width;
                    dstRowOffset += 2 * hSize;
                }
                continue;
            }
            int dstRowOffset = 0;
            for (int y3 = 0; y3 < vSize; ++y3) {
                for (int x3 = 0; x3 < hSize; ++x3) {
                    ret[i2].samples[dstRowOffset + x3] = dataUnit.samples[y3 / vScale * dataUnit.width + x3 / hScale];
                }
                dstRowOffset += hSize;
            }
        }
    }

    private Block[] allocateMCUMemory() throws ImageReadException {
        Block[] mcu = new Block[this.sosSegment.numberOfComponents];
        for (int i2 = 0; i2 < this.sosSegment.numberOfComponents; ++i2) {
            Block fullBlock;
            SosSegment.Component scanComponent = this.sosSegment.getComponents(i2);
            SofnSegment.Component frameComponent = null;
            for (int j2 = 0; j2 < this.sofnSegment.numberOfComponents; ++j2) {
                if (this.sofnSegment.getComponents((int)j2).componentIdentifier != scanComponent.scanComponentSelector) continue;
                frameComponent = this.sofnSegment.getComponents(j2);
                break;
            }
            if (frameComponent == null) {
                throw new ImageReadException("Invalid component");
            }
            mcu[i2] = fullBlock = new Block(8 * frameComponent.horizontalSamplingFactor, 8 * frameComponent.verticalSamplingFactor);
        }
        return mcu;
    }

    private void readMCU(JpegInputStream is, int[] preds, Block[] mcu) throws IOException, ImageReadException {
        for (int i2 = 0; i2 < this.sosSegment.numberOfComponents; ++i2) {
            SosSegment.Component scanComponent = this.sosSegment.getComponents(i2);
            SofnSegment.Component frameComponent = null;
            for (int j2 = 0; j2 < this.sofnSegment.numberOfComponents; ++j2) {
                if (this.sofnSegment.getComponents((int)j2).componentIdentifier != scanComponent.scanComponentSelector) continue;
                frameComponent = this.sofnSegment.getComponents(j2);
                break;
            }
            if (frameComponent == null) {
                throw new ImageReadException("Invalid component");
            }
            Block fullBlock = mcu[i2];
            for (int y2 = 0; y2 < frameComponent.verticalSamplingFactor; ++y2) {
                for (int x2 = 0; x2 < frameComponent.horizontalSamplingFactor; ++x2) {
                    Arrays.fill(this.zz, 0);
                    int t2 = this.decode(is, this.huffmanDCTables[scanComponent.dcCodingTableSelector]);
                    int diff = this.receive(t2, is);
                    diff = this.extend(diff, t2);
                    this.zz[0] = preds[i2] + diff;
                    preds[i2] = this.zz[0];
                    int k2 = 1;
                    while (true) {
                        int rrrr;
                        int rs = this.decode(is, this.huffmanACTables[scanComponent.acCodingTableSelector]);
                        int ssss = rs & 0xF;
                        int r2 = rrrr = rs >> 4;
                        if (ssss == 0) {
                            if (r2 != 15) break;
                            k2 += 16;
                            continue;
                        }
                        this.zz[k2 += r2] = this.receive(ssss, is);
                        this.zz[k2] = this.extend(this.zz[k2], ssss);
                        if (k2 == 63) break;
                        ++k2;
                    }
                    int shift = 1 << this.sofnSegment.precision - 1;
                    int max = (1 << this.sofnSegment.precision) - 1;
                    float[] scaledQuantizationTable = this.scaledQuantizationTables[frameComponent.quantTabDestSelector];
                    ZigZag.zigZagToBlock(this.zz, this.blockInt);
                    for (int j3 = 0; j3 < 64; ++j3) {
                        this.block[j3] = (float)this.blockInt[j3] * scaledQuantizationTable[j3];
                    }
                    Dct.inverseDCT8x8(this.block);
                    int dstRowOffset = 8 * y2 * 8 * frameComponent.horizontalSamplingFactor + 8 * x2;
                    int srcNext = 0;
                    for (int yy = 0; yy < 8; ++yy) {
                        for (int xx = 0; xx < 8; ++xx) {
                            float sample = this.block[srcNext++];
                            int result2 = (sample += (float)shift) < 0.0f ? 0 : (sample > (float)max ? max : JpegDecoder.fastRound(sample));
                            fullBlock.samples[dstRowOffset + xx] = result2;
                        }
                        dstRowOffset += 8 * frameComponent.horizontalSamplingFactor;
                    }
                }
            }
        }
    }

    private static int fastRound(float x2) {
        return (int)(x2 + 0.5f);
    }

    private int extend(int v2, int t2) {
        int vt = 1 << t2 - 1;
        while (v2 < vt) {
            vt = (-1 << t2) + 1;
            v2 += vt;
        }
        return v2;
    }

    private int receive(int ssss, JpegInputStream is) throws IOException, ImageReadException {
        int v2 = 0;
        for (int i2 = 0; i2 != ssss; ++i2) {
            v2 = (v2 << 1) + is.nextBit();
        }
        return v2;
    }

    private int decode(JpegInputStream is, DhtSegment.HuffmanTable huffmanTable) throws IOException, ImageReadException {
        int i2 = 1;
        int code2 = is.nextBit();
        while (code2 > huffmanTable.getMaxCode(i2)) {
            ++i2;
            code2 = code2 << 1 | is.nextBit();
        }
        int j2 = huffmanTable.getValPtr(i2);
        return huffmanTable.getHuffVal(j2 += code2 - huffmanTable.getMinCode(i2));
    }

    public BufferedImage decode(ByteSource byteSource) throws IOException, ImageReadException {
        JpegUtils jpegUtils = new JpegUtils();
        jpegUtils.traverseJFIF(byteSource, this);
        if (this.imageReadException != null) {
            throw this.imageReadException;
        }
        if (this.ioException != null) {
            throw this.ioException;
        }
        return this.image;
    }
}

