/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.pnm;

import java.io.IOException;
import java.io.InputStream;

class WhiteSpaceReader {
    private final InputStream is;

    public WhiteSpaceReader(InputStream is) {
        this.is = is;
    }

    private char read() throws IOException {
        int result2 = this.is.read();
        if (result2 < 0) {
            throw new IOException("PNM: Unexpected EOF");
        }
        return (char)result2;
    }

    public char nextChar() throws IOException {
        char c2 = this.read();
        if (c2 == '#') {
            while (c2 != '\n' && c2 != '\r') {
                c2 = this.read();
            }
        }
        return c2;
    }

    public String readtoWhiteSpace() throws IOException {
        char c2 = this.nextChar();
        while (Character.isWhitespace(c2)) {
            c2 = this.nextChar();
        }
        StringBuilder buffer = new StringBuilder();
        while (!Character.isWhitespace(c2)) {
            buffer.append(c2);
            c2 = this.nextChar();
        }
        return buffer.toString();
    }

    public String readLine() throws IOException {
        StringBuilder buffer = new StringBuilder();
        char c2 = this.read();
        while (c2 != '\n' && c2 != '\r') {
            buffer.append(c2);
            c2 = this.read();
        }
        return buffer.length() > 0 ? buffer.toString() : null;
    }
}

