/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.psd.dataparsers;

import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import org.apache.commons.imaging.formats.psd.PsdHeaderInfo;
import org.apache.commons.imaging.formats.psd.PsdImageContents;

public abstract class DataParser {
    public final void parseData(int[][][] data, BufferedImage bi2, PsdImageContents imageContents) {
        DataBuffer buffer = bi2.getRaster().getDataBuffer();
        PsdHeaderInfo header2 = imageContents.header;
        int width = header2.columns;
        int height = header2.rows;
        for (int y2 = 0; y2 < height; ++y2) {
            for (int x2 = 0; x2 < width; ++x2) {
                int rgb = this.getRGB(data, x2, y2, imageContents);
                buffer.setElem(y2 * width + x2, rgb);
            }
        }
    }

    protected abstract int getRGB(int[][][] var1, int var2, int var3, PsdImageContents var4);

    public abstract int getBasicChannelsCount();
}

