/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.psd.datareaders;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteOrder;
import org.apache.commons.imaging.ImageReadException;
import org.apache.commons.imaging.common.BinaryFileParser;
import org.apache.commons.imaging.common.mylzw.BitsToByteInputStream;
import org.apache.commons.imaging.common.mylzw.MyBitInputStream;
import org.apache.commons.imaging.formats.psd.PsdHeaderInfo;
import org.apache.commons.imaging.formats.psd.PsdImageContents;
import org.apache.commons.imaging.formats.psd.dataparsers.DataParser;
import org.apache.commons.imaging.formats.psd.datareaders.DataReader;

public class UncompressedDataReader
implements DataReader {
    private final DataParser dataParser;

    public UncompressedDataReader(DataParser dataParser) {
        this.dataParser = dataParser;
    }

    @Override
    public void readData(InputStream is, BufferedImage bi2, PsdImageContents imageContents, BinaryFileParser bfp) throws ImageReadException, IOException {
        PsdHeaderInfo header2 = imageContents.header;
        int width = header2.columns;
        int height = header2.rows;
        bfp.setDebug(false);
        int channelCount = this.dataParser.getBasicChannelsCount();
        int depth = header2.depth;
        MyBitInputStream mbis = new MyBitInputStream(is, ByteOrder.BIG_ENDIAN);
        try (BitsToByteInputStream bbis = new BitsToByteInputStream(mbis, 8);){
            int[][][] data = new int[channelCount][height][width];
            for (int channel = 0; channel < channelCount; ++channel) {
                for (int y2 = 0; y2 < height; ++y2) {
                    for (int x2 = 0; x2 < width; ++x2) {
                        int b2 = bbis.readBits(depth);
                        data[channel][y2][x2] = (byte)b2;
                    }
                }
            }
            this.dataParser.parseData(data, bi2, imageContents);
        }
    }
}

