/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.tiff.fieldtypes;

import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import org.apache.commons.imaging.ImageWriteException;
import org.apache.commons.imaging.formats.tiff.TiffField;
import org.apache.commons.imaging.formats.tiff.fieldtypes.FieldType;

public class FieldTypeAscii
extends FieldType {
    public FieldTypeAscii(int type, String name) {
        super(type, name, 1);
    }

    @Override
    public Object getValue(TiffField entry) {
        byte[] bytes = entry.getByteArrayValue();
        int nullCount = 1;
        for (int i2 = 0; i2 < bytes.length - 1; ++i2) {
            if (bytes[i2] != 0) continue;
            ++nullCount;
        }
        String[] strings = new String[nullCount];
        int stringsAdded = 0;
        strings[0] = "";
        int nextStringPos = 0;
        for (int i3 = 0; i3 < bytes.length; ++i3) {
            if (bytes[i3] != 0) continue;
            String string2 = new String(bytes, nextStringPos, i3 - nextStringPos, StandardCharsets.UTF_8);
            strings[stringsAdded++] = string2;
            nextStringPos = i3 + 1;
        }
        if (nextStringPos < bytes.length) {
            String string3 = new String(bytes, nextStringPos, bytes.length - nextStringPos, StandardCharsets.UTF_8);
            strings[stringsAdded++] = string3;
        }
        if (strings.length == 1) {
            return strings[0];
        }
        return strings;
    }

    @Override
    public byte[] writeData(Object o2, ByteOrder byteOrder) throws ImageWriteException {
        if (o2 instanceof byte[]) {
            byte[] bytes = (byte[])o2;
            byte[] result2 = new byte[bytes.length + 1];
            System.arraycopy(bytes, 0, result2, 0, bytes.length);
            result2[result2.length - 1] = 0;
            return result2;
        }
        if (o2 instanceof String) {
            byte[] bytes = ((String)o2).getBytes(StandardCharsets.UTF_8);
            byte[] result3 = new byte[bytes.length + 1];
            System.arraycopy(bytes, 0, result3, 0, bytes.length);
            result3[result3.length - 1] = 0;
            return result3;
        }
        if (o2 instanceof String[]) {
            String[] strings = (String[])o2;
            int totalLength = 0;
            for (String string2 : strings) {
                byte[] bytes = string2.getBytes(StandardCharsets.UTF_8);
                totalLength += bytes.length + 1;
            }
            byte[] result4 = new byte[totalLength];
            int position = 0;
            for (String string3 : strings) {
                byte[] bytes = string3.getBytes(StandardCharsets.UTF_8);
                System.arraycopy(bytes, 0, result4, position, bytes.length);
                position += bytes.length + 1;
            }
            return result4;
        }
        throw new ImageWriteException("Unknown data type: " + o2);
    }
}

