/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.tiff.fieldtypes;

import java.nio.ByteOrder;
import org.apache.commons.imaging.ImageWriteException;
import org.apache.commons.imaging.formats.tiff.TiffField;
import org.apache.commons.imaging.formats.tiff.fieldtypes.FieldType;

public class FieldTypeByte
extends FieldType {
    public FieldTypeByte(int type, String name) {
        super(type, name, 1);
    }

    @Override
    public Object getValue(TiffField entry) {
        byte[] bytes = entry.getByteArrayValue();
        if (entry.getCount() == 1L) {
            return bytes[0];
        }
        return bytes;
    }

    @Override
    public byte[] writeData(Object o2, ByteOrder byteOrder) throws ImageWriteException {
        if (o2 instanceof Byte) {
            return new byte[]{(Byte)o2};
        }
        if (o2 instanceof byte[]) {
            return (byte[])o2;
        }
        throw new ImageWriteException("Invalid data", o2);
    }
}

