/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.tiff.fieldtypes;

import java.nio.ByteOrder;
import org.apache.commons.imaging.ImageWriteException;
import org.apache.commons.imaging.common.ByteConversions;
import org.apache.commons.imaging.formats.tiff.TiffField;
import org.apache.commons.imaging.formats.tiff.fieldtypes.FieldType;

public class FieldTypeDouble
extends FieldType {
    public FieldTypeDouble(int type, String name) {
        super(type, name, 8);
    }

    @Override
    public Object getValue(TiffField entry) {
        byte[] bytes = entry.getByteArrayValue();
        if (entry.getCount() == 1L) {
            return ByteConversions.toDouble(bytes, entry.getByteOrder());
        }
        return ByteConversions.toDoubles(bytes, entry.getByteOrder());
    }

    @Override
    public byte[] writeData(Object o2, ByteOrder byteOrder) throws ImageWriteException {
        if (o2 instanceof Double) {
            return ByteConversions.toBytes((Double)o2, byteOrder);
        }
        if (o2 instanceof double[]) {
            double[] numbers = (double[])o2;
            return ByteConversions.toBytes(numbers, byteOrder);
        }
        if (o2 instanceof Double[]) {
            Double[] numbers = (Double[])o2;
            double[] values = new double[numbers.length];
            for (int i2 = 0; i2 < values.length; ++i2) {
                values[i2] = numbers[i2];
            }
            return ByteConversions.toBytes(values, byteOrder);
        }
        throw new ImageWriteException("Invalid data", o2);
    }
}

