/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.tiff.fieldtypes;

import java.nio.ByteOrder;
import org.apache.commons.imaging.ImageWriteException;
import org.apache.commons.imaging.common.ByteConversions;
import org.apache.commons.imaging.formats.tiff.TiffField;
import org.apache.commons.imaging.formats.tiff.fieldtypes.FieldType;

public class FieldTypeShort
extends FieldType {
    public FieldTypeShort(int type, String name) {
        super(type, name, 2);
    }

    @Override
    public Object getValue(TiffField entry) {
        byte[] bytes = entry.getByteArrayValue();
        if (entry.getCount() == 1L) {
            return ByteConversions.toShort(bytes, entry.getByteOrder());
        }
        return ByteConversions.toShorts(bytes, entry.getByteOrder());
    }

    @Override
    public byte[] writeData(Object o2, ByteOrder byteOrder) throws ImageWriteException {
        if (o2 instanceof Short) {
            return ByteConversions.toBytes((Short)o2, byteOrder);
        }
        if (o2 instanceof short[]) {
            short[] numbers = (short[])o2;
            return ByteConversions.toBytes(numbers, byteOrder);
        }
        if (o2 instanceof Short[]) {
            Short[] numbers = (Short[])o2;
            short[] values = new short[numbers.length];
            for (int i2 = 0; i2 < values.length; ++i2) {
                values[i2] = numbers[i2];
            }
            return ByteConversions.toBytes(values, byteOrder);
        }
        throw new ImageWriteException("Invalid data", o2);
    }
}

